/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container;

import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigBuilder;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.DoubleNode;
import com.yahoo.config.EnumNode;
import com.yahoo.config.InnerNode;
import com.yahoo.config.InnerNodeVector;
import com.yahoo.config.IntegerNode;
import com.yahoo.config.LeafNode;
import com.yahoo.config.LeafNodeVector;
import com.yahoo.config.ReferenceNode;
import com.yahoo.config.StringNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;

public final class QrSearchersConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "9134e53217f3619879370dc942c7751c";
    public static final String CONFIG_DEF_NAME = "qr-searchers";
    public static final String CONFIG_DEF_NAMESPACE = "container";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"namespace=container", "tag.bold.open string default=\"<hi>\"", "tag.bold.close string default=\"</hi>\"", "tag.separator string default=\"<sep />\"", "com.yahoo.prelude.searcher.FieldCollapsingSearcher.collapsesize int default=1", "com.yahoo.prelude.searcher.FieldCollapsingSearcher.extrafactor double default=2.0", "com.yahoo.prelude.searcher.FieldCollapsingSearcher.collapsefield string default=\"mid\"", "com.yahoo.prelude.searcher.BlendingSearcher.numthreads int default=200", "com.yahoo.prelude.searcher.BlendingSearcher.docid string default=\"\"", "com.yahoo.prelude.searcher.JuniperSearcher.source string default=\"\"", "com.yahoo.prelude.searcher.JuniperSearcher.defaultdoctype string default=\"\"", "com.yahoo.prelude.searcher.XMLStringSearcher.source string default=\"\"", "com.yahoo.prelude.fastsearch.FastSearcher.docsum.defaultclass string default=\"\"", "com.yahoo.prelude.querytransform.PhrasingSearcher.automatonfile string default=\"\"", "com.yahoo.prelude.querytransform.NonPhrasingSearcher.automatonfile string default=\"\"", "com.yahoo.prelude.querytransform.TermReplacingSearcher.termlist[] string", "com.yahoo.prelude.querytransform.CompleteBoostSearcher.source string default=\"\"", "com.yahoo.prelude.querytransform.ExactStringSearcher.source string default=\"\"", "com.yahoo.prelude.querytransform.LiteralBoostSearcher.source string default=\"\"", "com.yahoo.prelude.querytransform.TermBoostSearcher.source string default=\"\"", "com.yahoo.prelude.querytransform.NormalizingSearcher.source string default=\"\"", "com.yahoo.prelude.querytransform.StemmingSearcher.source string default=\"\"", "com.yahoo.prelude.statistics.StatisticsSearcher.latencybucketsize int default=30", "customizedsearchers.rawquery[] string", "customizedsearchers.transformedquery[] string", "customizedsearchers.blendedresult[] string", "customizedsearchers.unblendedresult[] string", "customizedsearchers.backend[] string", "customizedsearchers.argument[].key string", "customizedsearchers.argument[].value string", "external[].name string", "external[].searcher[] string", "searchcluster[].name string", "searchcluster[].searchdef[] string", "searchcluster[].rankprofiles.configid reference default=\"\"", "searchcluster[].indexingmode enum { REALTIME, STREAMING } default=REALTIME", "searchcluster[].storagecluster.routespec string default=\"\""};
    private final Tag tag;
    private final Com com;
    private final Customizedsearchers customizedsearchers;
    private final InnerNodeVector<External> external;
    private final InnerNodeVector<Searchcluster> searchcluster;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return CONFIG_DEF_NAME;
    }

    public static String getDefNamespace() {
        return CONFIG_DEF_NAMESPACE;
    }

    public QrSearchersConfig(Builder builder) {
        this(builder, true);
    }

    private QrSearchersConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for qr-searchers must be initialized: " + builder.__uninitialized);
        }
        this.tag = new Tag(builder.tag, throwIfUninitialized);
        this.com = new Com(builder.com, throwIfUninitialized);
        this.customizedsearchers = new Customizedsearchers(builder.customizedsearchers, throwIfUninitialized);
        this.external = External.createVector(builder.external);
        this.searchcluster = Searchcluster.createVector(builder.searchcluster);
    }

    public Tag tag() {
        return this.tag;
    }

    public Com com() {
        return this.com;
    }

    public Customizedsearchers customizedsearchers() {
        return this.customizedsearchers;
    }

    public List<External> external() {
        return this.external;
    }

    public External external(int i) {
        return (External)((Object)this.external.get(i));
    }

    public List<Searchcluster> searchcluster() {
        return this.searchcluster;
    }

    public Searchcluster searchcluster(int i) {
        return (Searchcluster)((Object)this.searchcluster.get(i));
    }

    private ChangesRequiringRestart getChangesRequiringRestart(QrSearchersConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart(CONFIG_DEF_NAME);
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return false;
    }

    public static final class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>();
        public Tag.Builder tag = new Tag.Builder();
        public Com.Builder com = new Com.Builder();
        public Customizedsearchers.Builder customizedsearchers = new Customizedsearchers.Builder();
        public List<External.Builder> external = new ArrayList<External.Builder>();
        public List<Searchcluster.Builder> searchcluster = new ArrayList<Searchcluster.Builder>();
        private boolean _applyOnRestart = false;

        public Builder() {
        }

        public Builder(QrSearchersConfig config) {
            this.tag(new Tag.Builder(config.tag()));
            this.com(new Com.Builder(config.com()));
            this.customizedsearchers(new Customizedsearchers.Builder(config.customizedsearchers()));
            for (External e : config.external()) {
                this.external(new External.Builder(e));
            }
            for (Searchcluster s : config.searchcluster()) {
                this.searchcluster(new Searchcluster.Builder(s));
            }
        }

        private Builder override(Builder __superior) {
            this.tag(this.tag.override(__superior.tag));
            this.com(this.com.override(__superior.com));
            this.customizedsearchers(this.customizedsearchers.override(__superior.customizedsearchers));
            if (!__superior.external.isEmpty()) {
                this.external.addAll(__superior.external);
            }
            if (!__superior.searchcluster.isEmpty()) {
                this.searchcluster.addAll(__superior.searchcluster);
            }
            return this;
        }

        public Builder tag(Tag.Builder __builder) {
            this.tag = __builder;
            return this;
        }

        public Builder tag(Consumer<Tag.Builder> __func) {
            Tag.Builder __inner = new Tag.Builder();
            __func.accept(__inner);
            this.tag = __inner;
            return this;
        }

        public Builder com(Com.Builder __builder) {
            this.com = __builder;
            return this;
        }

        public Builder com(Consumer<Com.Builder> __func) {
            Com.Builder __inner = new Com.Builder();
            __func.accept(__inner);
            this.com = __inner;
            return this;
        }

        public Builder customizedsearchers(Customizedsearchers.Builder __builder) {
            this.customizedsearchers = __builder;
            return this;
        }

        public Builder customizedsearchers(Consumer<Customizedsearchers.Builder> __func) {
            Customizedsearchers.Builder __inner = new Customizedsearchers.Builder();
            __func.accept(__inner);
            this.customizedsearchers = __inner;
            return this;
        }

        public Builder external(External.Builder __builder) {
            this.external.add(__builder);
            return this;
        }

        public Builder external(Consumer<External.Builder> __func) {
            External.Builder __inner = new External.Builder();
            __func.accept(__inner);
            this.external.add(__inner);
            return this;
        }

        public Builder external(List<External.Builder> __builders) {
            this.external = __builders;
            return this;
        }

        public Builder searchcluster(Searchcluster.Builder __builder) {
            this.searchcluster.add(__builder);
            return this;
        }

        public Builder searchcluster(Consumer<Searchcluster.Builder> __func) {
            Searchcluster.Builder __inner = new Searchcluster.Builder();
            __func.accept(__inner);
            this.searchcluster.add(__inner);
            return this;
        }

        public Builder searchcluster(List<Searchcluster.Builder> __builders) {
            this.searchcluster = __builders;
            return this;
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return QrSearchersConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return QrSearchersConfig.CONFIG_DEF_NAME;
        }

        public final String getDefNamespace() {
            return QrSearchersConfig.CONFIG_DEF_NAMESPACE;
        }

        public final boolean getApplyOnRestart() {
            return this._applyOnRestart;
        }

        public final void setApplyOnRestart(boolean applyOnRestart) {
            this._applyOnRestart = applyOnRestart;
        }

        public QrSearchersConfig build() {
            return new QrSearchersConfig(this);
        }
    }

    public static final class Tag
    extends InnerNode {
        private final Bold bold;
        private final StringNode separator;

        public Tag(Builder builder) {
            this(builder, true);
        }

        private Tag(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for qr-searchers.tag must be initialized: " + builder.__uninitialized);
            }
            this.bold = new Bold(builder.bold, throwIfUninitialized);
            this.separator = builder.separator == null ? new StringNode("<sep />") : new StringNode(builder.separator);
        }

        public Bold bold() {
            return this.bold;
        }

        public String separator() {
            return this.separator.value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Tag newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("tag");
            return changes;
        }

        public static final class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>();
            public Bold.Builder bold = new Bold.Builder();
            private String separator = null;

            public Builder() {
            }

            public Builder(Tag config) {
                this.bold(new Bold.Builder(config.bold()));
                this.separator(config.separator());
            }

            private Builder override(Builder __superior) {
                this.bold(this.bold.override(__superior.bold));
                if (__superior.separator != null) {
                    this.separator(__superior.separator);
                }
                return this;
            }

            public Builder bold(Bold.Builder __builder) {
                this.bold = __builder;
                return this;
            }

            public Builder bold(Consumer<Bold.Builder> __func) {
                Bold.Builder __inner = new Bold.Builder();
                __func.accept(__inner);
                this.bold = __inner;
                return this;
            }

            public Builder separator(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.separator = __value;
                return this;
            }

            public Tag build() {
                return new Tag(this);
            }
        }

        public static final class Bold
        extends InnerNode {
            private final StringNode open;
            private final StringNode close;

            public Bold(Builder builder) {
                this(builder, true);
            }

            private Bold(Builder builder, boolean throwIfUninitialized) {
                if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                    throw new IllegalArgumentException("The following builder parameters for qr-searchers.tag.bold must be initialized: " + builder.__uninitialized);
                }
                this.open = builder.open == null ? new StringNode("<hi>") : new StringNode(builder.open);
                this.close = builder.close == null ? new StringNode("</hi>") : new StringNode(builder.close);
            }

            public String open() {
                return this.open.value();
            }

            public String close() {
                return this.close.value();
            }

            private ChangesRequiringRestart getChangesRequiringRestart(Bold newConfig) {
                ChangesRequiringRestart changes = new ChangesRequiringRestart("bold");
                return changes;
            }

            public static final class Builder
            implements ConfigBuilder {
                private Set<String> __uninitialized = new HashSet<String>();
                private String open = null;
                private String close = null;

                public Builder() {
                }

                public Builder(Bold config) {
                    this.open(config.open());
                    this.close(config.close());
                }

                private Builder override(Builder __superior) {
                    if (__superior.open != null) {
                        this.open(__superior.open);
                    }
                    if (__superior.close != null) {
                        this.close(__superior.close);
                    }
                    return this;
                }

                public Builder open(String __value) {
                    if (__value == null) {
                        throw new IllegalArgumentException("Null value is not allowed.");
                    }
                    this.open = __value;
                    return this;
                }

                public Builder close(String __value) {
                    if (__value == null) {
                        throw new IllegalArgumentException("Null value is not allowed.");
                    }
                    this.close = __value;
                    return this;
                }

                public Bold build() {
                    return new Bold(this);
                }
            }
        }
    }

    public static final class Com
    extends InnerNode {
        private final Yahoo yahoo;

        public Com(Builder builder) {
            this(builder, true);
        }

        private Com(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for qr-searchers.com must be initialized: " + builder.__uninitialized);
            }
            this.yahoo = new Yahoo(builder.yahoo, throwIfUninitialized);
        }

        public Yahoo yahoo() {
            return this.yahoo;
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Com newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("com");
            return changes;
        }

        public static final class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>();
            public Yahoo.Builder yahoo = new Yahoo.Builder();

            public Builder() {
            }

            public Builder(Com config) {
                this.yahoo(new Yahoo.Builder(config.yahoo()));
            }

            private Builder override(Builder __superior) {
                this.yahoo(this.yahoo.override(__superior.yahoo));
                return this;
            }

            public Builder yahoo(Yahoo.Builder __builder) {
                this.yahoo = __builder;
                return this;
            }

            public Builder yahoo(Consumer<Yahoo.Builder> __func) {
                Yahoo.Builder __inner = new Yahoo.Builder();
                __func.accept(__inner);
                this.yahoo = __inner;
                return this;
            }

            public Com build() {
                return new Com(this);
            }
        }

        public static final class Yahoo
        extends InnerNode {
            private final Prelude prelude;

            public Yahoo(Builder builder) {
                this(builder, true);
            }

            private Yahoo(Builder builder, boolean throwIfUninitialized) {
                if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                    throw new IllegalArgumentException("The following builder parameters for qr-searchers.com.yahoo must be initialized: " + builder.__uninitialized);
                }
                this.prelude = new Prelude(builder.prelude, throwIfUninitialized);
            }

            public Prelude prelude() {
                return this.prelude;
            }

            private ChangesRequiringRestart getChangesRequiringRestart(Yahoo newConfig) {
                ChangesRequiringRestart changes = new ChangesRequiringRestart("yahoo");
                return changes;
            }

            public static final class Builder
            implements ConfigBuilder {
                private Set<String> __uninitialized = new HashSet<String>();
                public Prelude.Builder prelude = new Prelude.Builder();

                public Builder() {
                }

                public Builder(Yahoo config) {
                    this.prelude(new Prelude.Builder(config.prelude()));
                }

                private Builder override(Builder __superior) {
                    this.prelude(this.prelude.override(__superior.prelude));
                    return this;
                }

                public Builder prelude(Prelude.Builder __builder) {
                    this.prelude = __builder;
                    return this;
                }

                public Builder prelude(Consumer<Prelude.Builder> __func) {
                    Prelude.Builder __inner = new Prelude.Builder();
                    __func.accept(__inner);
                    this.prelude = __inner;
                    return this;
                }

                public Yahoo build() {
                    return new Yahoo(this);
                }
            }

            public static final class Prelude
            extends InnerNode {
                private final Searcher searcher;
                private final Fastsearch fastsearch;
                private final Querytransform querytransform;
                private final Statistics statistics;

                public Prelude(Builder builder) {
                    this(builder, true);
                }

                private Prelude(Builder builder, boolean throwIfUninitialized) {
                    if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                        throw new IllegalArgumentException("The following builder parameters for qr-searchers.com.yahoo.prelude must be initialized: " + builder.__uninitialized);
                    }
                    this.searcher = new Searcher(builder.searcher, throwIfUninitialized);
                    this.fastsearch = new Fastsearch(builder.fastsearch, throwIfUninitialized);
                    this.querytransform = new Querytransform(builder.querytransform, throwIfUninitialized);
                    this.statistics = new Statistics(builder.statistics, throwIfUninitialized);
                }

                public Searcher searcher() {
                    return this.searcher;
                }

                public Fastsearch fastsearch() {
                    return this.fastsearch;
                }

                public Querytransform querytransform() {
                    return this.querytransform;
                }

                public Statistics statistics() {
                    return this.statistics;
                }

                private ChangesRequiringRestart getChangesRequiringRestart(Prelude newConfig) {
                    ChangesRequiringRestart changes = new ChangesRequiringRestart("prelude");
                    return changes;
                }

                public static final class Builder
                implements ConfigBuilder {
                    private Set<String> __uninitialized = new HashSet<String>();
                    public Searcher.Builder searcher = new Searcher.Builder();
                    public Fastsearch.Builder fastsearch = new Fastsearch.Builder();
                    public Querytransform.Builder querytransform = new Querytransform.Builder();
                    public Statistics.Builder statistics = new Statistics.Builder();

                    public Builder() {
                    }

                    public Builder(Prelude config) {
                        this.searcher(new Searcher.Builder(config.searcher()));
                        this.fastsearch(new Fastsearch.Builder(config.fastsearch()));
                        this.querytransform(new Querytransform.Builder(config.querytransform()));
                        this.statistics(new Statistics.Builder(config.statistics()));
                    }

                    private Builder override(Builder __superior) {
                        this.searcher(this.searcher.override(__superior.searcher));
                        this.fastsearch(this.fastsearch.override(__superior.fastsearch));
                        this.querytransform(this.querytransform.override(__superior.querytransform));
                        this.statistics(this.statistics.override(__superior.statistics));
                        return this;
                    }

                    public Builder searcher(Searcher.Builder __builder) {
                        this.searcher = __builder;
                        return this;
                    }

                    public Builder searcher(Consumer<Searcher.Builder> __func) {
                        Searcher.Builder __inner = new Searcher.Builder();
                        __func.accept(__inner);
                        this.searcher = __inner;
                        return this;
                    }

                    public Builder fastsearch(Fastsearch.Builder __builder) {
                        this.fastsearch = __builder;
                        return this;
                    }

                    public Builder fastsearch(Consumer<Fastsearch.Builder> __func) {
                        Fastsearch.Builder __inner = new Fastsearch.Builder();
                        __func.accept(__inner);
                        this.fastsearch = __inner;
                        return this;
                    }

                    public Builder querytransform(Querytransform.Builder __builder) {
                        this.querytransform = __builder;
                        return this;
                    }

                    public Builder querytransform(Consumer<Querytransform.Builder> __func) {
                        Querytransform.Builder __inner = new Querytransform.Builder();
                        __func.accept(__inner);
                        this.querytransform = __inner;
                        return this;
                    }

                    public Builder statistics(Statistics.Builder __builder) {
                        this.statistics = __builder;
                        return this;
                    }

                    public Builder statistics(Consumer<Statistics.Builder> __func) {
                        Statistics.Builder __inner = new Statistics.Builder();
                        __func.accept(__inner);
                        this.statistics = __inner;
                        return this;
                    }

                    public Prelude build() {
                        return new Prelude(this);
                    }
                }

                public static final class Searcher
                extends InnerNode {
                    private final FieldCollapsingSearcher FieldCollapsingSearcher;
                    private final BlendingSearcher BlendingSearcher;
                    private final JuniperSearcher JuniperSearcher;
                    private final XMLStringSearcher XMLStringSearcher;

                    public Searcher(Builder builder) {
                        this(builder, true);
                    }

                    private Searcher(Builder builder, boolean throwIfUninitialized) {
                        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                            throw new IllegalArgumentException("The following builder parameters for qr-searchers.com.yahoo.prelude.searcher must be initialized: " + builder.__uninitialized);
                        }
                        this.FieldCollapsingSearcher = new FieldCollapsingSearcher(builder.FieldCollapsingSearcher, throwIfUninitialized);
                        this.BlendingSearcher = new BlendingSearcher(builder.BlendingSearcher, throwIfUninitialized);
                        this.JuniperSearcher = new JuniperSearcher(builder.JuniperSearcher, throwIfUninitialized);
                        this.XMLStringSearcher = new XMLStringSearcher(builder.XMLStringSearcher, throwIfUninitialized);
                    }

                    public FieldCollapsingSearcher FieldCollapsingSearcher() {
                        return this.FieldCollapsingSearcher;
                    }

                    public BlendingSearcher BlendingSearcher() {
                        return this.BlendingSearcher;
                    }

                    public JuniperSearcher JuniperSearcher() {
                        return this.JuniperSearcher;
                    }

                    public XMLStringSearcher XMLStringSearcher() {
                        return this.XMLStringSearcher;
                    }

                    private ChangesRequiringRestart getChangesRequiringRestart(Searcher newConfig) {
                        ChangesRequiringRestart changes = new ChangesRequiringRestart("searcher");
                        return changes;
                    }

                    public static final class Builder
                    implements ConfigBuilder {
                        private Set<String> __uninitialized = new HashSet<String>();
                        public FieldCollapsingSearcher.Builder FieldCollapsingSearcher = new FieldCollapsingSearcher.Builder();
                        public BlendingSearcher.Builder BlendingSearcher = new BlendingSearcher.Builder();
                        public JuniperSearcher.Builder JuniperSearcher = new JuniperSearcher.Builder();
                        public XMLStringSearcher.Builder XMLStringSearcher = new XMLStringSearcher.Builder();

                        public Builder() {
                        }

                        public Builder(Searcher config) {
                            this.FieldCollapsingSearcher(new FieldCollapsingSearcher.Builder(config.FieldCollapsingSearcher()));
                            this.BlendingSearcher(new BlendingSearcher.Builder(config.BlendingSearcher()));
                            this.JuniperSearcher(new JuniperSearcher.Builder(config.JuniperSearcher()));
                            this.XMLStringSearcher(new XMLStringSearcher.Builder(config.XMLStringSearcher()));
                        }

                        private Builder override(Builder __superior) {
                            this.FieldCollapsingSearcher(this.FieldCollapsingSearcher.override(__superior.FieldCollapsingSearcher));
                            this.BlendingSearcher(this.BlendingSearcher.override(__superior.BlendingSearcher));
                            this.JuniperSearcher(this.JuniperSearcher.override(__superior.JuniperSearcher));
                            this.XMLStringSearcher(this.XMLStringSearcher.override(__superior.XMLStringSearcher));
                            return this;
                        }

                        public Builder FieldCollapsingSearcher(FieldCollapsingSearcher.Builder __builder) {
                            this.FieldCollapsingSearcher = __builder;
                            return this;
                        }

                        public Builder FieldCollapsingSearcher(Consumer<FieldCollapsingSearcher.Builder> __func) {
                            FieldCollapsingSearcher.Builder __inner = new FieldCollapsingSearcher.Builder();
                            __func.accept(__inner);
                            this.FieldCollapsingSearcher = __inner;
                            return this;
                        }

                        public Builder BlendingSearcher(BlendingSearcher.Builder __builder) {
                            this.BlendingSearcher = __builder;
                            return this;
                        }

                        public Builder BlendingSearcher(Consumer<BlendingSearcher.Builder> __func) {
                            BlendingSearcher.Builder __inner = new BlendingSearcher.Builder();
                            __func.accept(__inner);
                            this.BlendingSearcher = __inner;
                            return this;
                        }

                        public Builder JuniperSearcher(JuniperSearcher.Builder __builder) {
                            this.JuniperSearcher = __builder;
                            return this;
                        }

                        public Builder JuniperSearcher(Consumer<JuniperSearcher.Builder> __func) {
                            JuniperSearcher.Builder __inner = new JuniperSearcher.Builder();
                            __func.accept(__inner);
                            this.JuniperSearcher = __inner;
                            return this;
                        }

                        public Builder XMLStringSearcher(XMLStringSearcher.Builder __builder) {
                            this.XMLStringSearcher = __builder;
                            return this;
                        }

                        public Builder XMLStringSearcher(Consumer<XMLStringSearcher.Builder> __func) {
                            XMLStringSearcher.Builder __inner = new XMLStringSearcher.Builder();
                            __func.accept(__inner);
                            this.XMLStringSearcher = __inner;
                            return this;
                        }

                        public Searcher build() {
                            return new Searcher(this);
                        }
                    }

                    public static final class FieldCollapsingSearcher
                    extends InnerNode {
                        private final IntegerNode collapsesize;
                        private final DoubleNode extrafactor;
                        private final StringNode collapsefield;

                        public FieldCollapsingSearcher(Builder builder) {
                            this(builder, true);
                        }

                        private FieldCollapsingSearcher(Builder builder, boolean throwIfUninitialized) {
                            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                                throw new IllegalArgumentException("The following builder parameters for qr-searchers.com.yahoo.prelude.searcher.FieldCollapsingSearcher must be initialized: " + builder.__uninitialized);
                            }
                            this.collapsesize = builder.collapsesize == null ? new IntegerNode(1) : new IntegerNode(builder.collapsesize.intValue());
                            this.extrafactor = builder.extrafactor == null ? new DoubleNode(2.0) : new DoubleNode(builder.extrafactor.doubleValue());
                            this.collapsefield = builder.collapsefield == null ? new StringNode("mid") : new StringNode(builder.collapsefield);
                        }

                        public int collapsesize() {
                            return this.collapsesize.value();
                        }

                        public double extrafactor() {
                            return this.extrafactor.value();
                        }

                        public String collapsefield() {
                            return this.collapsefield.value();
                        }

                        private ChangesRequiringRestart getChangesRequiringRestart(FieldCollapsingSearcher newConfig) {
                            ChangesRequiringRestart changes = new ChangesRequiringRestart("FieldCollapsingSearcher");
                            return changes;
                        }

                        public static final class Builder
                        implements ConfigBuilder {
                            private Set<String> __uninitialized = new HashSet<String>();
                            private Integer collapsesize = null;
                            private Double extrafactor = null;
                            private String collapsefield = null;

                            public Builder() {
                            }

                            public Builder(FieldCollapsingSearcher config) {
                                this.collapsesize(config.collapsesize());
                                this.extrafactor(config.extrafactor());
                                this.collapsefield(config.collapsefield());
                            }

                            private Builder override(Builder __superior) {
                                if (__superior.collapsesize != null) {
                                    this.collapsesize(__superior.collapsesize);
                                }
                                if (__superior.extrafactor != null) {
                                    this.extrafactor(__superior.extrafactor);
                                }
                                if (__superior.collapsefield != null) {
                                    this.collapsefield(__superior.collapsefield);
                                }
                                return this;
                            }

                            public Builder collapsesize(int __value) {
                                this.collapsesize = __value;
                                return this;
                            }

                            private Builder collapsesize(String __value) {
                                return this.collapsesize(Integer.valueOf(__value));
                            }

                            public Builder extrafactor(double __value) {
                                this.extrafactor = __value;
                                return this;
                            }

                            private Builder extrafactor(String __value) {
                                return this.extrafactor(Double.valueOf(__value));
                            }

                            public Builder collapsefield(String __value) {
                                if (__value == null) {
                                    throw new IllegalArgumentException("Null value is not allowed.");
                                }
                                this.collapsefield = __value;
                                return this;
                            }

                            public FieldCollapsingSearcher build() {
                                return new FieldCollapsingSearcher(this);
                            }
                        }
                    }

                    public static final class BlendingSearcher
                    extends InnerNode {
                        private final IntegerNode numthreads;
                        private final StringNode docid;

                        public BlendingSearcher(Builder builder) {
                            this(builder, true);
                        }

                        private BlendingSearcher(Builder builder, boolean throwIfUninitialized) {
                            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                                throw new IllegalArgumentException("The following builder parameters for qr-searchers.com.yahoo.prelude.searcher.BlendingSearcher must be initialized: " + builder.__uninitialized);
                            }
                            this.numthreads = builder.numthreads == null ? new IntegerNode(200) : new IntegerNode(builder.numthreads.intValue());
                            this.docid = builder.docid == null ? new StringNode("") : new StringNode(builder.docid);
                        }

                        public int numthreads() {
                            return this.numthreads.value();
                        }

                        public String docid() {
                            return this.docid.value();
                        }

                        private ChangesRequiringRestart getChangesRequiringRestart(BlendingSearcher newConfig) {
                            ChangesRequiringRestart changes = new ChangesRequiringRestart("BlendingSearcher");
                            return changes;
                        }

                        public static final class Builder
                        implements ConfigBuilder {
                            private Set<String> __uninitialized = new HashSet<String>();
                            private Integer numthreads = null;
                            private String docid = null;

                            public Builder() {
                            }

                            public Builder(BlendingSearcher config) {
                                this.numthreads(config.numthreads());
                                this.docid(config.docid());
                            }

                            private Builder override(Builder __superior) {
                                if (__superior.numthreads != null) {
                                    this.numthreads(__superior.numthreads);
                                }
                                if (__superior.docid != null) {
                                    this.docid(__superior.docid);
                                }
                                return this;
                            }

                            public Builder numthreads(int __value) {
                                this.numthreads = __value;
                                return this;
                            }

                            private Builder numthreads(String __value) {
                                return this.numthreads(Integer.valueOf(__value));
                            }

                            public Builder docid(String __value) {
                                if (__value == null) {
                                    throw new IllegalArgumentException("Null value is not allowed.");
                                }
                                this.docid = __value;
                                return this;
                            }

                            public BlendingSearcher build() {
                                return new BlendingSearcher(this);
                            }
                        }
                    }

                    public static final class JuniperSearcher
                    extends InnerNode {
                        private final StringNode source;
                        private final StringNode defaultdoctype;

                        public JuniperSearcher(Builder builder) {
                            this(builder, true);
                        }

                        private JuniperSearcher(Builder builder, boolean throwIfUninitialized) {
                            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                                throw new IllegalArgumentException("The following builder parameters for qr-searchers.com.yahoo.prelude.searcher.JuniperSearcher must be initialized: " + builder.__uninitialized);
                            }
                            this.source = builder.source == null ? new StringNode("") : new StringNode(builder.source);
                            this.defaultdoctype = builder.defaultdoctype == null ? new StringNode("") : new StringNode(builder.defaultdoctype);
                        }

                        public String source() {
                            return this.source.value();
                        }

                        public String defaultdoctype() {
                            return this.defaultdoctype.value();
                        }

                        private ChangesRequiringRestart getChangesRequiringRestart(JuniperSearcher newConfig) {
                            ChangesRequiringRestart changes = new ChangesRequiringRestart("JuniperSearcher");
                            return changes;
                        }

                        public static final class Builder
                        implements ConfigBuilder {
                            private Set<String> __uninitialized = new HashSet<String>();
                            private String source = null;
                            private String defaultdoctype = null;

                            public Builder() {
                            }

                            public Builder(JuniperSearcher config) {
                                this.source(config.source());
                                this.defaultdoctype(config.defaultdoctype());
                            }

                            private Builder override(Builder __superior) {
                                if (__superior.source != null) {
                                    this.source(__superior.source);
                                }
                                if (__superior.defaultdoctype != null) {
                                    this.defaultdoctype(__superior.defaultdoctype);
                                }
                                return this;
                            }

                            public Builder source(String __value) {
                                if (__value == null) {
                                    throw new IllegalArgumentException("Null value is not allowed.");
                                }
                                this.source = __value;
                                return this;
                            }

                            public Builder defaultdoctype(String __value) {
                                if (__value == null) {
                                    throw new IllegalArgumentException("Null value is not allowed.");
                                }
                                this.defaultdoctype = __value;
                                return this;
                            }

                            public JuniperSearcher build() {
                                return new JuniperSearcher(this);
                            }
                        }
                    }

                    public static final class XMLStringSearcher
                    extends InnerNode {
                        private final StringNode source;

                        public XMLStringSearcher(Builder builder) {
                            this(builder, true);
                        }

                        private XMLStringSearcher(Builder builder, boolean throwIfUninitialized) {
                            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                                throw new IllegalArgumentException("The following builder parameters for qr-searchers.com.yahoo.prelude.searcher.XMLStringSearcher must be initialized: " + builder.__uninitialized);
                            }
                            this.source = builder.source == null ? new StringNode("") : new StringNode(builder.source);
                        }

                        public String source() {
                            return this.source.value();
                        }

                        private ChangesRequiringRestart getChangesRequiringRestart(XMLStringSearcher newConfig) {
                            ChangesRequiringRestart changes = new ChangesRequiringRestart("XMLStringSearcher");
                            return changes;
                        }

                        public static final class Builder
                        implements ConfigBuilder {
                            private Set<String> __uninitialized = new HashSet<String>();
                            private String source = null;

                            public Builder() {
                            }

                            public Builder(XMLStringSearcher config) {
                                this.source(config.source());
                            }

                            private Builder override(Builder __superior) {
                                if (__superior.source != null) {
                                    this.source(__superior.source);
                                }
                                return this;
                            }

                            public Builder source(String __value) {
                                if (__value == null) {
                                    throw new IllegalArgumentException("Null value is not allowed.");
                                }
                                this.source = __value;
                                return this;
                            }

                            public XMLStringSearcher build() {
                                return new XMLStringSearcher(this);
                            }
                        }
                    }
                }

                public static final class Fastsearch
                extends InnerNode {
                    private final FastSearcher FastSearcher;

                    public Fastsearch(Builder builder) {
                        this(builder, true);
                    }

                    private Fastsearch(Builder builder, boolean throwIfUninitialized) {
                        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                            throw new IllegalArgumentException("The following builder parameters for qr-searchers.com.yahoo.prelude.fastsearch must be initialized: " + builder.__uninitialized);
                        }
                        this.FastSearcher = new FastSearcher(builder.FastSearcher, throwIfUninitialized);
                    }

                    public FastSearcher FastSearcher() {
                        return this.FastSearcher;
                    }

                    private ChangesRequiringRestart getChangesRequiringRestart(Fastsearch newConfig) {
                        ChangesRequiringRestart changes = new ChangesRequiringRestart("fastsearch");
                        return changes;
                    }

                    public static final class Builder
                    implements ConfigBuilder {
                        private Set<String> __uninitialized = new HashSet<String>();
                        public FastSearcher.Builder FastSearcher = new FastSearcher.Builder();

                        public Builder() {
                        }

                        public Builder(Fastsearch config) {
                            this.FastSearcher(new FastSearcher.Builder(config.FastSearcher()));
                        }

                        private Builder override(Builder __superior) {
                            this.FastSearcher(this.FastSearcher.override(__superior.FastSearcher));
                            return this;
                        }

                        public Builder FastSearcher(FastSearcher.Builder __builder) {
                            this.FastSearcher = __builder;
                            return this;
                        }

                        public Builder FastSearcher(Consumer<FastSearcher.Builder> __func) {
                            FastSearcher.Builder __inner = new FastSearcher.Builder();
                            __func.accept(__inner);
                            this.FastSearcher = __inner;
                            return this;
                        }

                        public Fastsearch build() {
                            return new Fastsearch(this);
                        }
                    }

                    public static final class FastSearcher
                    extends InnerNode {
                        private final Docsum docsum;

                        public FastSearcher(Builder builder) {
                            this(builder, true);
                        }

                        private FastSearcher(Builder builder, boolean throwIfUninitialized) {
                            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                                throw new IllegalArgumentException("The following builder parameters for qr-searchers.com.yahoo.prelude.fastsearch.FastSearcher must be initialized: " + builder.__uninitialized);
                            }
                            this.docsum = new Docsum(builder.docsum, throwIfUninitialized);
                        }

                        public Docsum docsum() {
                            return this.docsum;
                        }

                        private ChangesRequiringRestart getChangesRequiringRestart(FastSearcher newConfig) {
                            ChangesRequiringRestart changes = new ChangesRequiringRestart("FastSearcher");
                            return changes;
                        }

                        public static final class Builder
                        implements ConfigBuilder {
                            private Set<String> __uninitialized = new HashSet<String>();
                            public Docsum.Builder docsum = new Docsum.Builder();

                            public Builder() {
                            }

                            public Builder(FastSearcher config) {
                                this.docsum(new Docsum.Builder(config.docsum()));
                            }

                            private Builder override(Builder __superior) {
                                this.docsum(this.docsum.override(__superior.docsum));
                                return this;
                            }

                            public Builder docsum(Docsum.Builder __builder) {
                                this.docsum = __builder;
                                return this;
                            }

                            public Builder docsum(Consumer<Docsum.Builder> __func) {
                                Docsum.Builder __inner = new Docsum.Builder();
                                __func.accept(__inner);
                                this.docsum = __inner;
                                return this;
                            }

                            public FastSearcher build() {
                                return new FastSearcher(this);
                            }
                        }

                        public static final class Docsum
                        extends InnerNode {
                            private final StringNode defaultclass;

                            public Docsum(Builder builder) {
                                this(builder, true);
                            }

                            private Docsum(Builder builder, boolean throwIfUninitialized) {
                                if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                                    throw new IllegalArgumentException("The following builder parameters for qr-searchers.com.yahoo.prelude.fastsearch.FastSearcher.docsum must be initialized: " + builder.__uninitialized);
                                }
                                this.defaultclass = builder.defaultclass == null ? new StringNode("") : new StringNode(builder.defaultclass);
                            }

                            public String defaultclass() {
                                return this.defaultclass.value();
                            }

                            private ChangesRequiringRestart getChangesRequiringRestart(Docsum newConfig) {
                                ChangesRequiringRestart changes = new ChangesRequiringRestart("docsum");
                                return changes;
                            }

                            public static final class Builder
                            implements ConfigBuilder {
                                private Set<String> __uninitialized = new HashSet<String>();
                                private String defaultclass = null;

                                public Builder() {
                                }

                                public Builder(Docsum config) {
                                    this.defaultclass(config.defaultclass());
                                }

                                private Builder override(Builder __superior) {
                                    if (__superior.defaultclass != null) {
                                        this.defaultclass(__superior.defaultclass);
                                    }
                                    return this;
                                }

                                public Builder defaultclass(String __value) {
                                    if (__value == null) {
                                        throw new IllegalArgumentException("Null value is not allowed.");
                                    }
                                    this.defaultclass = __value;
                                    return this;
                                }

                                public Docsum build() {
                                    return new Docsum(this);
                                }
                            }
                        }
                    }
                }

                public static final class Querytransform
                extends InnerNode {
                    private final PhrasingSearcher PhrasingSearcher;
                    private final NonPhrasingSearcher NonPhrasingSearcher;
                    private final TermReplacingSearcher TermReplacingSearcher;
                    private final CompleteBoostSearcher CompleteBoostSearcher;
                    private final ExactStringSearcher ExactStringSearcher;
                    private final LiteralBoostSearcher LiteralBoostSearcher;
                    private final TermBoostSearcher TermBoostSearcher;
                    private final NormalizingSearcher NormalizingSearcher;
                    private final StemmingSearcher StemmingSearcher;

                    public Querytransform(Builder builder) {
                        this(builder, true);
                    }

                    private Querytransform(Builder builder, boolean throwIfUninitialized) {
                        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                            throw new IllegalArgumentException("The following builder parameters for qr-searchers.com.yahoo.prelude.querytransform must be initialized: " + builder.__uninitialized);
                        }
                        this.PhrasingSearcher = new PhrasingSearcher(builder.PhrasingSearcher, throwIfUninitialized);
                        this.NonPhrasingSearcher = new NonPhrasingSearcher(builder.NonPhrasingSearcher, throwIfUninitialized);
                        this.TermReplacingSearcher = new TermReplacingSearcher(builder.TermReplacingSearcher, throwIfUninitialized);
                        this.CompleteBoostSearcher = new CompleteBoostSearcher(builder.CompleteBoostSearcher, throwIfUninitialized);
                        this.ExactStringSearcher = new ExactStringSearcher(builder.ExactStringSearcher, throwIfUninitialized);
                        this.LiteralBoostSearcher = new LiteralBoostSearcher(builder.LiteralBoostSearcher, throwIfUninitialized);
                        this.TermBoostSearcher = new TermBoostSearcher(builder.TermBoostSearcher, throwIfUninitialized);
                        this.NormalizingSearcher = new NormalizingSearcher(builder.NormalizingSearcher, throwIfUninitialized);
                        this.StemmingSearcher = new StemmingSearcher(builder.StemmingSearcher, throwIfUninitialized);
                    }

                    public PhrasingSearcher PhrasingSearcher() {
                        return this.PhrasingSearcher;
                    }

                    public NonPhrasingSearcher NonPhrasingSearcher() {
                        return this.NonPhrasingSearcher;
                    }

                    public TermReplacingSearcher TermReplacingSearcher() {
                        return this.TermReplacingSearcher;
                    }

                    public CompleteBoostSearcher CompleteBoostSearcher() {
                        return this.CompleteBoostSearcher;
                    }

                    public ExactStringSearcher ExactStringSearcher() {
                        return this.ExactStringSearcher;
                    }

                    public LiteralBoostSearcher LiteralBoostSearcher() {
                        return this.LiteralBoostSearcher;
                    }

                    public TermBoostSearcher TermBoostSearcher() {
                        return this.TermBoostSearcher;
                    }

                    public NormalizingSearcher NormalizingSearcher() {
                        return this.NormalizingSearcher;
                    }

                    public StemmingSearcher StemmingSearcher() {
                        return this.StemmingSearcher;
                    }

                    private ChangesRequiringRestart getChangesRequiringRestart(Querytransform newConfig) {
                        ChangesRequiringRestart changes = new ChangesRequiringRestart("querytransform");
                        return changes;
                    }

                    public static final class Builder
                    implements ConfigBuilder {
                        private Set<String> __uninitialized = new HashSet<String>();
                        public PhrasingSearcher.Builder PhrasingSearcher = new PhrasingSearcher.Builder();
                        public NonPhrasingSearcher.Builder NonPhrasingSearcher = new NonPhrasingSearcher.Builder();
                        public TermReplacingSearcher.Builder TermReplacingSearcher = new TermReplacingSearcher.Builder();
                        public CompleteBoostSearcher.Builder CompleteBoostSearcher = new CompleteBoostSearcher.Builder();
                        public ExactStringSearcher.Builder ExactStringSearcher = new ExactStringSearcher.Builder();
                        public LiteralBoostSearcher.Builder LiteralBoostSearcher = new LiteralBoostSearcher.Builder();
                        public TermBoostSearcher.Builder TermBoostSearcher = new TermBoostSearcher.Builder();
                        public NormalizingSearcher.Builder NormalizingSearcher = new NormalizingSearcher.Builder();
                        public StemmingSearcher.Builder StemmingSearcher = new StemmingSearcher.Builder();

                        public Builder() {
                        }

                        public Builder(Querytransform config) {
                            this.PhrasingSearcher(new PhrasingSearcher.Builder(config.PhrasingSearcher()));
                            this.NonPhrasingSearcher(new NonPhrasingSearcher.Builder(config.NonPhrasingSearcher()));
                            this.TermReplacingSearcher(new TermReplacingSearcher.Builder(config.TermReplacingSearcher()));
                            this.CompleteBoostSearcher(new CompleteBoostSearcher.Builder(config.CompleteBoostSearcher()));
                            this.ExactStringSearcher(new ExactStringSearcher.Builder(config.ExactStringSearcher()));
                            this.LiteralBoostSearcher(new LiteralBoostSearcher.Builder(config.LiteralBoostSearcher()));
                            this.TermBoostSearcher(new TermBoostSearcher.Builder(config.TermBoostSearcher()));
                            this.NormalizingSearcher(new NormalizingSearcher.Builder(config.NormalizingSearcher()));
                            this.StemmingSearcher(new StemmingSearcher.Builder(config.StemmingSearcher()));
                        }

                        private Builder override(Builder __superior) {
                            this.PhrasingSearcher(this.PhrasingSearcher.override(__superior.PhrasingSearcher));
                            this.NonPhrasingSearcher(this.NonPhrasingSearcher.override(__superior.NonPhrasingSearcher));
                            this.TermReplacingSearcher(this.TermReplacingSearcher.override(__superior.TermReplacingSearcher));
                            this.CompleteBoostSearcher(this.CompleteBoostSearcher.override(__superior.CompleteBoostSearcher));
                            this.ExactStringSearcher(this.ExactStringSearcher.override(__superior.ExactStringSearcher));
                            this.LiteralBoostSearcher(this.LiteralBoostSearcher.override(__superior.LiteralBoostSearcher));
                            this.TermBoostSearcher(this.TermBoostSearcher.override(__superior.TermBoostSearcher));
                            this.NormalizingSearcher(this.NormalizingSearcher.override(__superior.NormalizingSearcher));
                            this.StemmingSearcher(this.StemmingSearcher.override(__superior.StemmingSearcher));
                            return this;
                        }

                        public Builder PhrasingSearcher(PhrasingSearcher.Builder __builder) {
                            this.PhrasingSearcher = __builder;
                            return this;
                        }

                        public Builder PhrasingSearcher(Consumer<PhrasingSearcher.Builder> __func) {
                            PhrasingSearcher.Builder __inner = new PhrasingSearcher.Builder();
                            __func.accept(__inner);
                            this.PhrasingSearcher = __inner;
                            return this;
                        }

                        public Builder NonPhrasingSearcher(NonPhrasingSearcher.Builder __builder) {
                            this.NonPhrasingSearcher = __builder;
                            return this;
                        }

                        public Builder NonPhrasingSearcher(Consumer<NonPhrasingSearcher.Builder> __func) {
                            NonPhrasingSearcher.Builder __inner = new NonPhrasingSearcher.Builder();
                            __func.accept(__inner);
                            this.NonPhrasingSearcher = __inner;
                            return this;
                        }

                        public Builder TermReplacingSearcher(TermReplacingSearcher.Builder __builder) {
                            this.TermReplacingSearcher = __builder;
                            return this;
                        }

                        public Builder TermReplacingSearcher(Consumer<TermReplacingSearcher.Builder> __func) {
                            TermReplacingSearcher.Builder __inner = new TermReplacingSearcher.Builder();
                            __func.accept(__inner);
                            this.TermReplacingSearcher = __inner;
                            return this;
                        }

                        public Builder CompleteBoostSearcher(CompleteBoostSearcher.Builder __builder) {
                            this.CompleteBoostSearcher = __builder;
                            return this;
                        }

                        public Builder CompleteBoostSearcher(Consumer<CompleteBoostSearcher.Builder> __func) {
                            CompleteBoostSearcher.Builder __inner = new CompleteBoostSearcher.Builder();
                            __func.accept(__inner);
                            this.CompleteBoostSearcher = __inner;
                            return this;
                        }

                        public Builder ExactStringSearcher(ExactStringSearcher.Builder __builder) {
                            this.ExactStringSearcher = __builder;
                            return this;
                        }

                        public Builder ExactStringSearcher(Consumer<ExactStringSearcher.Builder> __func) {
                            ExactStringSearcher.Builder __inner = new ExactStringSearcher.Builder();
                            __func.accept(__inner);
                            this.ExactStringSearcher = __inner;
                            return this;
                        }

                        public Builder LiteralBoostSearcher(LiteralBoostSearcher.Builder __builder) {
                            this.LiteralBoostSearcher = __builder;
                            return this;
                        }

                        public Builder LiteralBoostSearcher(Consumer<LiteralBoostSearcher.Builder> __func) {
                            LiteralBoostSearcher.Builder __inner = new LiteralBoostSearcher.Builder();
                            __func.accept(__inner);
                            this.LiteralBoostSearcher = __inner;
                            return this;
                        }

                        public Builder TermBoostSearcher(TermBoostSearcher.Builder __builder) {
                            this.TermBoostSearcher = __builder;
                            return this;
                        }

                        public Builder TermBoostSearcher(Consumer<TermBoostSearcher.Builder> __func) {
                            TermBoostSearcher.Builder __inner = new TermBoostSearcher.Builder();
                            __func.accept(__inner);
                            this.TermBoostSearcher = __inner;
                            return this;
                        }

                        public Builder NormalizingSearcher(NormalizingSearcher.Builder __builder) {
                            this.NormalizingSearcher = __builder;
                            return this;
                        }

                        public Builder NormalizingSearcher(Consumer<NormalizingSearcher.Builder> __func) {
                            NormalizingSearcher.Builder __inner = new NormalizingSearcher.Builder();
                            __func.accept(__inner);
                            this.NormalizingSearcher = __inner;
                            return this;
                        }

                        public Builder StemmingSearcher(StemmingSearcher.Builder __builder) {
                            this.StemmingSearcher = __builder;
                            return this;
                        }

                        public Builder StemmingSearcher(Consumer<StemmingSearcher.Builder> __func) {
                            StemmingSearcher.Builder __inner = new StemmingSearcher.Builder();
                            __func.accept(__inner);
                            this.StemmingSearcher = __inner;
                            return this;
                        }

                        public Querytransform build() {
                            return new Querytransform(this);
                        }
                    }

                    public static final class PhrasingSearcher
                    extends InnerNode {
                        private final StringNode automatonfile;

                        public PhrasingSearcher(Builder builder) {
                            this(builder, true);
                        }

                        private PhrasingSearcher(Builder builder, boolean throwIfUninitialized) {
                            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                                throw new IllegalArgumentException("The following builder parameters for qr-searchers.com.yahoo.prelude.querytransform.PhrasingSearcher must be initialized: " + builder.__uninitialized);
                            }
                            this.automatonfile = builder.automatonfile == null ? new StringNode("") : new StringNode(builder.automatonfile);
                        }

                        public String automatonfile() {
                            return this.automatonfile.value();
                        }

                        private ChangesRequiringRestart getChangesRequiringRestart(PhrasingSearcher newConfig) {
                            ChangesRequiringRestart changes = new ChangesRequiringRestart("PhrasingSearcher");
                            return changes;
                        }

                        public static final class Builder
                        implements ConfigBuilder {
                            private Set<String> __uninitialized = new HashSet<String>();
                            private String automatonfile = null;

                            public Builder() {
                            }

                            public Builder(PhrasingSearcher config) {
                                this.automatonfile(config.automatonfile());
                            }

                            private Builder override(Builder __superior) {
                                if (__superior.automatonfile != null) {
                                    this.automatonfile(__superior.automatonfile);
                                }
                                return this;
                            }

                            public Builder automatonfile(String __value) {
                                if (__value == null) {
                                    throw new IllegalArgumentException("Null value is not allowed.");
                                }
                                this.automatonfile = __value;
                                return this;
                            }

                            public PhrasingSearcher build() {
                                return new PhrasingSearcher(this);
                            }
                        }
                    }

                    public static final class NonPhrasingSearcher
                    extends InnerNode {
                        private final StringNode automatonfile;

                        public NonPhrasingSearcher(Builder builder) {
                            this(builder, true);
                        }

                        private NonPhrasingSearcher(Builder builder, boolean throwIfUninitialized) {
                            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                                throw new IllegalArgumentException("The following builder parameters for qr-searchers.com.yahoo.prelude.querytransform.NonPhrasingSearcher must be initialized: " + builder.__uninitialized);
                            }
                            this.automatonfile = builder.automatonfile == null ? new StringNode("") : new StringNode(builder.automatonfile);
                        }

                        public String automatonfile() {
                            return this.automatonfile.value();
                        }

                        private ChangesRequiringRestart getChangesRequiringRestart(NonPhrasingSearcher newConfig) {
                            ChangesRequiringRestart changes = new ChangesRequiringRestart("NonPhrasingSearcher");
                            return changes;
                        }

                        public static final class Builder
                        implements ConfigBuilder {
                            private Set<String> __uninitialized = new HashSet<String>();
                            private String automatonfile = null;

                            public Builder() {
                            }

                            public Builder(NonPhrasingSearcher config) {
                                this.automatonfile(config.automatonfile());
                            }

                            private Builder override(Builder __superior) {
                                if (__superior.automatonfile != null) {
                                    this.automatonfile(__superior.automatonfile);
                                }
                                return this;
                            }

                            public Builder automatonfile(String __value) {
                                if (__value == null) {
                                    throw new IllegalArgumentException("Null value is not allowed.");
                                }
                                this.automatonfile = __value;
                                return this;
                            }

                            public NonPhrasingSearcher build() {
                                return new NonPhrasingSearcher(this);
                            }
                        }
                    }

                    public static final class TermReplacingSearcher
                    extends InnerNode {
                        private final LeafNodeVector<String, StringNode> termlist;

                        public TermReplacingSearcher(Builder builder) {
                            this(builder, true);
                        }

                        private TermReplacingSearcher(Builder builder, boolean throwIfUninitialized) {
                            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                                throw new IllegalArgumentException("The following builder parameters for qr-searchers.com.yahoo.prelude.querytransform.TermReplacingSearcher must be initialized: " + builder.__uninitialized);
                            }
                            this.termlist = new LeafNodeVector(builder.termlist, (LeafNode)new StringNode());
                        }

                        public List<String> termlist() {
                            return this.termlist.asList();
                        }

                        public String termlist(int i) {
                            return ((StringNode)this.termlist.get(i)).value();
                        }

                        private ChangesRequiringRestart getChangesRequiringRestart(TermReplacingSearcher newConfig) {
                            ChangesRequiringRestart changes = new ChangesRequiringRestart("TermReplacingSearcher");
                            return changes;
                        }

                        public static final class Builder
                        implements ConfigBuilder {
                            private Set<String> __uninitialized = new HashSet<String>();
                            public List<String> termlist = new ArrayList<String>();

                            public Builder() {
                            }

                            public Builder(TermReplacingSearcher config) {
                                this.termlist(config.termlist());
                            }

                            private Builder override(Builder __superior) {
                                if (!__superior.termlist.isEmpty()) {
                                    this.termlist.addAll(__superior.termlist);
                                }
                                return this;
                            }

                            public Builder termlist(String __value) {
                                this.termlist.add(__value);
                                return this;
                            }

                            public Builder termlist(Collection<String> __values) {
                                this.termlist.addAll(__values);
                                return this;
                            }

                            public TermReplacingSearcher build() {
                                return new TermReplacingSearcher(this);
                            }
                        }
                    }

                    public static final class CompleteBoostSearcher
                    extends InnerNode {
                        private final StringNode source;

                        public CompleteBoostSearcher(Builder builder) {
                            this(builder, true);
                        }

                        private CompleteBoostSearcher(Builder builder, boolean throwIfUninitialized) {
                            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                                throw new IllegalArgumentException("The following builder parameters for qr-searchers.com.yahoo.prelude.querytransform.CompleteBoostSearcher must be initialized: " + builder.__uninitialized);
                            }
                            this.source = builder.source == null ? new StringNode("") : new StringNode(builder.source);
                        }

                        public String source() {
                            return this.source.value();
                        }

                        private ChangesRequiringRestart getChangesRequiringRestart(CompleteBoostSearcher newConfig) {
                            ChangesRequiringRestart changes = new ChangesRequiringRestart("CompleteBoostSearcher");
                            return changes;
                        }

                        public static final class Builder
                        implements ConfigBuilder {
                            private Set<String> __uninitialized = new HashSet<String>();
                            private String source = null;

                            public Builder() {
                            }

                            public Builder(CompleteBoostSearcher config) {
                                this.source(config.source());
                            }

                            private Builder override(Builder __superior) {
                                if (__superior.source != null) {
                                    this.source(__superior.source);
                                }
                                return this;
                            }

                            public Builder source(String __value) {
                                if (__value == null) {
                                    throw new IllegalArgumentException("Null value is not allowed.");
                                }
                                this.source = __value;
                                return this;
                            }

                            public CompleteBoostSearcher build() {
                                return new CompleteBoostSearcher(this);
                            }
                        }
                    }

                    public static final class ExactStringSearcher
                    extends InnerNode {
                        private final StringNode source;

                        public ExactStringSearcher(Builder builder) {
                            this(builder, true);
                        }

                        private ExactStringSearcher(Builder builder, boolean throwIfUninitialized) {
                            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                                throw new IllegalArgumentException("The following builder parameters for qr-searchers.com.yahoo.prelude.querytransform.ExactStringSearcher must be initialized: " + builder.__uninitialized);
                            }
                            this.source = builder.source == null ? new StringNode("") : new StringNode(builder.source);
                        }

                        public String source() {
                            return this.source.value();
                        }

                        private ChangesRequiringRestart getChangesRequiringRestart(ExactStringSearcher newConfig) {
                            ChangesRequiringRestart changes = new ChangesRequiringRestart("ExactStringSearcher");
                            return changes;
                        }

                        public static final class Builder
                        implements ConfigBuilder {
                            private Set<String> __uninitialized = new HashSet<String>();
                            private String source = null;

                            public Builder() {
                            }

                            public Builder(ExactStringSearcher config) {
                                this.source(config.source());
                            }

                            private Builder override(Builder __superior) {
                                if (__superior.source != null) {
                                    this.source(__superior.source);
                                }
                                return this;
                            }

                            public Builder source(String __value) {
                                if (__value == null) {
                                    throw new IllegalArgumentException("Null value is not allowed.");
                                }
                                this.source = __value;
                                return this;
                            }

                            public ExactStringSearcher build() {
                                return new ExactStringSearcher(this);
                            }
                        }
                    }

                    public static final class LiteralBoostSearcher
                    extends InnerNode {
                        private final StringNode source;

                        public LiteralBoostSearcher(Builder builder) {
                            this(builder, true);
                        }

                        private LiteralBoostSearcher(Builder builder, boolean throwIfUninitialized) {
                            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                                throw new IllegalArgumentException("The following builder parameters for qr-searchers.com.yahoo.prelude.querytransform.LiteralBoostSearcher must be initialized: " + builder.__uninitialized);
                            }
                            this.source = builder.source == null ? new StringNode("") : new StringNode(builder.source);
                        }

                        public String source() {
                            return this.source.value();
                        }

                        private ChangesRequiringRestart getChangesRequiringRestart(LiteralBoostSearcher newConfig) {
                            ChangesRequiringRestart changes = new ChangesRequiringRestart("LiteralBoostSearcher");
                            return changes;
                        }

                        public static final class Builder
                        implements ConfigBuilder {
                            private Set<String> __uninitialized = new HashSet<String>();
                            private String source = null;

                            public Builder() {
                            }

                            public Builder(LiteralBoostSearcher config) {
                                this.source(config.source());
                            }

                            private Builder override(Builder __superior) {
                                if (__superior.source != null) {
                                    this.source(__superior.source);
                                }
                                return this;
                            }

                            public Builder source(String __value) {
                                if (__value == null) {
                                    throw new IllegalArgumentException("Null value is not allowed.");
                                }
                                this.source = __value;
                                return this;
                            }

                            public LiteralBoostSearcher build() {
                                return new LiteralBoostSearcher(this);
                            }
                        }
                    }

                    public static final class TermBoostSearcher
                    extends InnerNode {
                        private final StringNode source;

                        public TermBoostSearcher(Builder builder) {
                            this(builder, true);
                        }

                        private TermBoostSearcher(Builder builder, boolean throwIfUninitialized) {
                            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                                throw new IllegalArgumentException("The following builder parameters for qr-searchers.com.yahoo.prelude.querytransform.TermBoostSearcher must be initialized: " + builder.__uninitialized);
                            }
                            this.source = builder.source == null ? new StringNode("") : new StringNode(builder.source);
                        }

                        public String source() {
                            return this.source.value();
                        }

                        private ChangesRequiringRestart getChangesRequiringRestart(TermBoostSearcher newConfig) {
                            ChangesRequiringRestart changes = new ChangesRequiringRestart("TermBoostSearcher");
                            return changes;
                        }

                        public static final class Builder
                        implements ConfigBuilder {
                            private Set<String> __uninitialized = new HashSet<String>();
                            private String source = null;

                            public Builder() {
                            }

                            public Builder(TermBoostSearcher config) {
                                this.source(config.source());
                            }

                            private Builder override(Builder __superior) {
                                if (__superior.source != null) {
                                    this.source(__superior.source);
                                }
                                return this;
                            }

                            public Builder source(String __value) {
                                if (__value == null) {
                                    throw new IllegalArgumentException("Null value is not allowed.");
                                }
                                this.source = __value;
                                return this;
                            }

                            public TermBoostSearcher build() {
                                return new TermBoostSearcher(this);
                            }
                        }
                    }

                    public static final class NormalizingSearcher
                    extends InnerNode {
                        private final StringNode source;

                        public NormalizingSearcher(Builder builder) {
                            this(builder, true);
                        }

                        private NormalizingSearcher(Builder builder, boolean throwIfUninitialized) {
                            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                                throw new IllegalArgumentException("The following builder parameters for qr-searchers.com.yahoo.prelude.querytransform.NormalizingSearcher must be initialized: " + builder.__uninitialized);
                            }
                            this.source = builder.source == null ? new StringNode("") : new StringNode(builder.source);
                        }

                        public String source() {
                            return this.source.value();
                        }

                        private ChangesRequiringRestart getChangesRequiringRestart(NormalizingSearcher newConfig) {
                            ChangesRequiringRestart changes = new ChangesRequiringRestart("NormalizingSearcher");
                            return changes;
                        }

                        public static final class Builder
                        implements ConfigBuilder {
                            private Set<String> __uninitialized = new HashSet<String>();
                            private String source = null;

                            public Builder() {
                            }

                            public Builder(NormalizingSearcher config) {
                                this.source(config.source());
                            }

                            private Builder override(Builder __superior) {
                                if (__superior.source != null) {
                                    this.source(__superior.source);
                                }
                                return this;
                            }

                            public Builder source(String __value) {
                                if (__value == null) {
                                    throw new IllegalArgumentException("Null value is not allowed.");
                                }
                                this.source = __value;
                                return this;
                            }

                            public NormalizingSearcher build() {
                                return new NormalizingSearcher(this);
                            }
                        }
                    }

                    public static final class StemmingSearcher
                    extends InnerNode {
                        private final StringNode source;

                        public StemmingSearcher(Builder builder) {
                            this(builder, true);
                        }

                        private StemmingSearcher(Builder builder, boolean throwIfUninitialized) {
                            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                                throw new IllegalArgumentException("The following builder parameters for qr-searchers.com.yahoo.prelude.querytransform.StemmingSearcher must be initialized: " + builder.__uninitialized);
                            }
                            this.source = builder.source == null ? new StringNode("") : new StringNode(builder.source);
                        }

                        public String source() {
                            return this.source.value();
                        }

                        private ChangesRequiringRestart getChangesRequiringRestart(StemmingSearcher newConfig) {
                            ChangesRequiringRestart changes = new ChangesRequiringRestart("StemmingSearcher");
                            return changes;
                        }

                        public static final class Builder
                        implements ConfigBuilder {
                            private Set<String> __uninitialized = new HashSet<String>();
                            private String source = null;

                            public Builder() {
                            }

                            public Builder(StemmingSearcher config) {
                                this.source(config.source());
                            }

                            private Builder override(Builder __superior) {
                                if (__superior.source != null) {
                                    this.source(__superior.source);
                                }
                                return this;
                            }

                            public Builder source(String __value) {
                                if (__value == null) {
                                    throw new IllegalArgumentException("Null value is not allowed.");
                                }
                                this.source = __value;
                                return this;
                            }

                            public StemmingSearcher build() {
                                return new StemmingSearcher(this);
                            }
                        }
                    }
                }

                public static final class Statistics
                extends InnerNode {
                    private final StatisticsSearcher StatisticsSearcher;

                    public Statistics(Builder builder) {
                        this(builder, true);
                    }

                    private Statistics(Builder builder, boolean throwIfUninitialized) {
                        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                            throw new IllegalArgumentException("The following builder parameters for qr-searchers.com.yahoo.prelude.statistics must be initialized: " + builder.__uninitialized);
                        }
                        this.StatisticsSearcher = new StatisticsSearcher(builder.StatisticsSearcher, throwIfUninitialized);
                    }

                    public StatisticsSearcher StatisticsSearcher() {
                        return this.StatisticsSearcher;
                    }

                    private ChangesRequiringRestart getChangesRequiringRestart(Statistics newConfig) {
                        ChangesRequiringRestart changes = new ChangesRequiringRestart("statistics");
                        return changes;
                    }

                    public static final class Builder
                    implements ConfigBuilder {
                        private Set<String> __uninitialized = new HashSet<String>();
                        public StatisticsSearcher.Builder StatisticsSearcher = new StatisticsSearcher.Builder();

                        public Builder() {
                        }

                        public Builder(Statistics config) {
                            this.StatisticsSearcher(new StatisticsSearcher.Builder(config.StatisticsSearcher()));
                        }

                        private Builder override(Builder __superior) {
                            this.StatisticsSearcher(this.StatisticsSearcher.override(__superior.StatisticsSearcher));
                            return this;
                        }

                        public Builder StatisticsSearcher(StatisticsSearcher.Builder __builder) {
                            this.StatisticsSearcher = __builder;
                            return this;
                        }

                        public Builder StatisticsSearcher(Consumer<StatisticsSearcher.Builder> __func) {
                            StatisticsSearcher.Builder __inner = new StatisticsSearcher.Builder();
                            __func.accept(__inner);
                            this.StatisticsSearcher = __inner;
                            return this;
                        }

                        public Statistics build() {
                            return new Statistics(this);
                        }
                    }

                    public static final class StatisticsSearcher
                    extends InnerNode {
                        private final IntegerNode latencybucketsize;

                        public StatisticsSearcher(Builder builder) {
                            this(builder, true);
                        }

                        private StatisticsSearcher(Builder builder, boolean throwIfUninitialized) {
                            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                                throw new IllegalArgumentException("The following builder parameters for qr-searchers.com.yahoo.prelude.statistics.StatisticsSearcher must be initialized: " + builder.__uninitialized);
                            }
                            this.latencybucketsize = builder.latencybucketsize == null ? new IntegerNode(30) : new IntegerNode(builder.latencybucketsize.intValue());
                        }

                        public int latencybucketsize() {
                            return this.latencybucketsize.value();
                        }

                        private ChangesRequiringRestart getChangesRequiringRestart(StatisticsSearcher newConfig) {
                            ChangesRequiringRestart changes = new ChangesRequiringRestart("StatisticsSearcher");
                            return changes;
                        }

                        public static final class Builder
                        implements ConfigBuilder {
                            private Set<String> __uninitialized = new HashSet<String>();
                            private Integer latencybucketsize = null;

                            public Builder() {
                            }

                            public Builder(StatisticsSearcher config) {
                                this.latencybucketsize(config.latencybucketsize());
                            }

                            private Builder override(Builder __superior) {
                                if (__superior.latencybucketsize != null) {
                                    this.latencybucketsize(__superior.latencybucketsize);
                                }
                                return this;
                            }

                            public Builder latencybucketsize(int __value) {
                                this.latencybucketsize = __value;
                                return this;
                            }

                            private Builder latencybucketsize(String __value) {
                                return this.latencybucketsize(Integer.valueOf(__value));
                            }

                            public StatisticsSearcher build() {
                                return new StatisticsSearcher(this);
                            }
                        }
                    }
                }
            }
        }
    }

    public static final class Customizedsearchers
    extends InnerNode {
        private final LeafNodeVector<String, StringNode> rawquery;
        private final LeafNodeVector<String, StringNode> transformedquery;
        private final LeafNodeVector<String, StringNode> blendedresult;
        private final LeafNodeVector<String, StringNode> unblendedresult;
        private final LeafNodeVector<String, StringNode> backend;
        private final InnerNodeVector<Argument> argument;

        public Customizedsearchers(Builder builder) {
            this(builder, true);
        }

        private Customizedsearchers(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for qr-searchers.customizedsearchers must be initialized: " + builder.__uninitialized);
            }
            this.rawquery = new LeafNodeVector(builder.rawquery, (LeafNode)new StringNode());
            this.transformedquery = new LeafNodeVector(builder.transformedquery, (LeafNode)new StringNode());
            this.blendedresult = new LeafNodeVector(builder.blendedresult, (LeafNode)new StringNode());
            this.unblendedresult = new LeafNodeVector(builder.unblendedresult, (LeafNode)new StringNode());
            this.backend = new LeafNodeVector(builder.backend, (LeafNode)new StringNode());
            this.argument = Argument.createVector(builder.argument);
        }

        public List<String> rawquery() {
            return this.rawquery.asList();
        }

        public String rawquery(int i) {
            return ((StringNode)this.rawquery.get(i)).value();
        }

        public List<String> transformedquery() {
            return this.transformedquery.asList();
        }

        public String transformedquery(int i) {
            return ((StringNode)this.transformedquery.get(i)).value();
        }

        public List<String> blendedresult() {
            return this.blendedresult.asList();
        }

        public String blendedresult(int i) {
            return ((StringNode)this.blendedresult.get(i)).value();
        }

        public List<String> unblendedresult() {
            return this.unblendedresult.asList();
        }

        public String unblendedresult(int i) {
            return ((StringNode)this.unblendedresult.get(i)).value();
        }

        public List<String> backend() {
            return this.backend.asList();
        }

        public String backend(int i) {
            return ((StringNode)this.backend.get(i)).value();
        }

        public List<Argument> argument() {
            return this.argument;
        }

        public Argument argument(int i) {
            return (Argument)((Object)this.argument.get(i));
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Customizedsearchers newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("customizedsearchers");
            return changes;
        }

        public static final class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>();
            public List<String> rawquery = new ArrayList<String>();
            public List<String> transformedquery = new ArrayList<String>();
            public List<String> blendedresult = new ArrayList<String>();
            public List<String> unblendedresult = new ArrayList<String>();
            public List<String> backend = new ArrayList<String>();
            public List<Argument.Builder> argument = new ArrayList<Argument.Builder>();

            public Builder() {
            }

            public Builder(Customizedsearchers config) {
                this.rawquery(config.rawquery());
                this.transformedquery(config.transformedquery());
                this.blendedresult(config.blendedresult());
                this.unblendedresult(config.unblendedresult());
                this.backend(config.backend());
                for (Argument a : config.argument()) {
                    this.argument(new Argument.Builder(a));
                }
            }

            private Builder override(Builder __superior) {
                if (!__superior.rawquery.isEmpty()) {
                    this.rawquery.addAll(__superior.rawquery);
                }
                if (!__superior.transformedquery.isEmpty()) {
                    this.transformedquery.addAll(__superior.transformedquery);
                }
                if (!__superior.blendedresult.isEmpty()) {
                    this.blendedresult.addAll(__superior.blendedresult);
                }
                if (!__superior.unblendedresult.isEmpty()) {
                    this.unblendedresult.addAll(__superior.unblendedresult);
                }
                if (!__superior.backend.isEmpty()) {
                    this.backend.addAll(__superior.backend);
                }
                if (!__superior.argument.isEmpty()) {
                    this.argument.addAll(__superior.argument);
                }
                return this;
            }

            public Builder rawquery(String __value) {
                this.rawquery.add(__value);
                return this;
            }

            public Builder rawquery(Collection<String> __values) {
                this.rawquery.addAll(__values);
                return this;
            }

            public Builder transformedquery(String __value) {
                this.transformedquery.add(__value);
                return this;
            }

            public Builder transformedquery(Collection<String> __values) {
                this.transformedquery.addAll(__values);
                return this;
            }

            public Builder blendedresult(String __value) {
                this.blendedresult.add(__value);
                return this;
            }

            public Builder blendedresult(Collection<String> __values) {
                this.blendedresult.addAll(__values);
                return this;
            }

            public Builder unblendedresult(String __value) {
                this.unblendedresult.add(__value);
                return this;
            }

            public Builder unblendedresult(Collection<String> __values) {
                this.unblendedresult.addAll(__values);
                return this;
            }

            public Builder backend(String __value) {
                this.backend.add(__value);
                return this;
            }

            public Builder backend(Collection<String> __values) {
                this.backend.addAll(__values);
                return this;
            }

            public Builder argument(Argument.Builder __builder) {
                this.argument.add(__builder);
                return this;
            }

            public Builder argument(Consumer<Argument.Builder> __func) {
                Argument.Builder __inner = new Argument.Builder();
                __func.accept(__inner);
                this.argument.add(__inner);
                return this;
            }

            public Builder argument(List<Argument.Builder> __builders) {
                this.argument = __builders;
                return this;
            }

            public Customizedsearchers build() {
                return new Customizedsearchers(this);
            }
        }

        public static final class Argument
        extends InnerNode {
            private final StringNode key;
            private final StringNode value;

            public Argument(Builder builder) {
                this(builder, true);
            }

            private Argument(Builder builder, boolean throwIfUninitialized) {
                if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                    throw new IllegalArgumentException("The following builder parameters for qr-searchers.customizedsearchers.argument[] must be initialized: " + builder.__uninitialized);
                }
                this.key = builder.key == null ? new StringNode() : new StringNode(builder.key);
                this.value = builder.value == null ? new StringNode() : new StringNode(builder.value);
            }

            public String key() {
                return this.key.value();
            }

            public String value() {
                return this.value.value();
            }

            private ChangesRequiringRestart getChangesRequiringRestart(Argument newConfig) {
                ChangesRequiringRestart changes = new ChangesRequiringRestart("argument");
                return changes;
            }

            private static InnerNodeVector<Argument> createVector(List<Builder> builders) {
                ArrayList<Argument> elems = new ArrayList<Argument>();
                for (Builder b : builders) {
                    elems.add(new Argument(b));
                }
                return new InnerNodeVector(elems);
            }

            public static final class Builder
            implements ConfigBuilder {
                private Set<String> __uninitialized = new HashSet<String>(Arrays.asList("key", "value"));
                private String key = null;
                private String value = null;

                public Builder() {
                }

                public Builder(Argument config) {
                    this.key(config.key());
                    this.value(config.value());
                }

                private Builder override(Builder __superior) {
                    if (__superior.key != null) {
                        this.key(__superior.key);
                    }
                    if (__superior.value != null) {
                        this.value(__superior.value);
                    }
                    return this;
                }

                public Builder key(String __value) {
                    if (__value == null) {
                        throw new IllegalArgumentException("Null value is not allowed.");
                    }
                    this.key = __value;
                    this.__uninitialized.remove("key");
                    return this;
                }

                public Builder value(String __value) {
                    if (__value == null) {
                        throw new IllegalArgumentException("Null value is not allowed.");
                    }
                    this.value = __value;
                    this.__uninitialized.remove("value");
                    return this;
                }

                public Argument build() {
                    return new Argument(this);
                }
            }
        }
    }

    public static final class External
    extends InnerNode {
        private final StringNode name;
        private final LeafNodeVector<String, StringNode> searcher;

        public External(Builder builder) {
            this(builder, true);
        }

        private External(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for qr-searchers.external[] must be initialized: " + builder.__uninitialized);
            }
            this.name = builder.name == null ? new StringNode() : new StringNode(builder.name);
            this.searcher = new LeafNodeVector(builder.searcher, (LeafNode)new StringNode());
        }

        public String name() {
            return this.name.value();
        }

        public List<String> searcher() {
            return this.searcher.asList();
        }

        public String searcher(int i) {
            return ((StringNode)this.searcher.get(i)).value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(External newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("external");
            return changes;
        }

        private static InnerNodeVector<External> createVector(List<Builder> builders) {
            ArrayList<External> elems = new ArrayList<External>();
            for (Builder b : builders) {
                elems.add(new External(b));
            }
            return new InnerNodeVector(elems);
        }

        public static final class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>(Arrays.asList("name"));
            private String name = null;
            public List<String> searcher = new ArrayList<String>();

            public Builder() {
            }

            public Builder(External config) {
                this.name(config.name());
                this.searcher(config.searcher());
            }

            private Builder override(Builder __superior) {
                if (__superior.name != null) {
                    this.name(__superior.name);
                }
                if (!__superior.searcher.isEmpty()) {
                    this.searcher.addAll(__superior.searcher);
                }
                return this;
            }

            public Builder name(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.name = __value;
                this.__uninitialized.remove("name");
                return this;
            }

            public Builder searcher(String __value) {
                this.searcher.add(__value);
                return this;
            }

            public Builder searcher(Collection<String> __values) {
                this.searcher.addAll(__values);
                return this;
            }

            public External build() {
                return new External(this);
            }
        }
    }

    public static final class Searchcluster
    extends InnerNode {
        private final StringNode name;
        private final LeafNodeVector<String, StringNode> searchdef;
        private final Rankprofiles rankprofiles;
        private final Indexingmode indexingmode;
        private final Storagecluster storagecluster;

        public Searchcluster(Builder builder) {
            this(builder, true);
        }

        private Searchcluster(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for qr-searchers.searchcluster[] must be initialized: " + builder.__uninitialized);
            }
            this.name = builder.name == null ? new StringNode() : new StringNode(builder.name);
            this.searchdef = new LeafNodeVector(builder.searchdef, (LeafNode)new StringNode());
            this.rankprofiles = new Rankprofiles(builder.rankprofiles, throwIfUninitialized);
            this.indexingmode = builder.indexingmode == null ? new Indexingmode(Indexingmode.REALTIME) : new Indexingmode(builder.indexingmode);
            this.storagecluster = new Storagecluster(builder.storagecluster, throwIfUninitialized);
        }

        public String name() {
            return this.name.value();
        }

        public List<String> searchdef() {
            return this.searchdef.asList();
        }

        public String searchdef(int i) {
            return ((StringNode)this.searchdef.get(i)).value();
        }

        public Rankprofiles rankprofiles() {
            return this.rankprofiles;
        }

        public Indexingmode.Enum indexingmode() {
            return (Indexingmode.Enum)((Object)this.indexingmode.value());
        }

        public Storagecluster storagecluster() {
            return this.storagecluster;
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Searchcluster newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("searchcluster");
            return changes;
        }

        private static InnerNodeVector<Searchcluster> createVector(List<Builder> builders) {
            ArrayList<Searchcluster> elems = new ArrayList<Searchcluster>();
            for (Builder b : builders) {
                elems.add(new Searchcluster(b));
            }
            return new InnerNodeVector(elems);
        }

        public static final class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>(Arrays.asList("name"));
            private String name = null;
            public List<String> searchdef = new ArrayList<String>();
            public Rankprofiles.Builder rankprofiles = new Rankprofiles.Builder();
            private Indexingmode.Enum indexingmode = null;
            public Storagecluster.Builder storagecluster = new Storagecluster.Builder();

            public Builder() {
            }

            public Builder(Searchcluster config) {
                this.name(config.name());
                this.searchdef(config.searchdef());
                this.rankprofiles(new Rankprofiles.Builder(config.rankprofiles()));
                this.indexingmode(config.indexingmode());
                this.storagecluster(new Storagecluster.Builder(config.storagecluster()));
            }

            private Builder override(Builder __superior) {
                if (__superior.name != null) {
                    this.name(__superior.name);
                }
                if (!__superior.searchdef.isEmpty()) {
                    this.searchdef.addAll(__superior.searchdef);
                }
                this.rankprofiles(this.rankprofiles.override(__superior.rankprofiles));
                if (__superior.indexingmode != null) {
                    this.indexingmode(__superior.indexingmode);
                }
                this.storagecluster(this.storagecluster.override(__superior.storagecluster));
                return this;
            }

            public Builder name(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.name = __value;
                this.__uninitialized.remove("name");
                return this;
            }

            public Builder searchdef(String __value) {
                this.searchdef.add(__value);
                return this;
            }

            public Builder searchdef(Collection<String> __values) {
                this.searchdef.addAll(__values);
                return this;
            }

            public Builder rankprofiles(Rankprofiles.Builder __builder) {
                this.rankprofiles = __builder;
                return this;
            }

            public Builder rankprofiles(Consumer<Rankprofiles.Builder> __func) {
                Rankprofiles.Builder __inner = new Rankprofiles.Builder();
                __func.accept(__inner);
                this.rankprofiles = __inner;
                return this;
            }

            public Builder indexingmode(Indexingmode.Enum __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.indexingmode = __value;
                return this;
            }

            private Builder indexingmode(String __value) {
                return this.indexingmode(Indexingmode.Enum.valueOf(__value));
            }

            public Builder storagecluster(Storagecluster.Builder __builder) {
                this.storagecluster = __builder;
                return this;
            }

            public Builder storagecluster(Consumer<Storagecluster.Builder> __func) {
                Storagecluster.Builder __inner = new Storagecluster.Builder();
                __func.accept(__inner);
                this.storagecluster = __inner;
                return this;
            }

            public Searchcluster build() {
                return new Searchcluster(this);
            }
        }

        public static final class Rankprofiles
        extends InnerNode {
            private final ReferenceNode configid;

            public Rankprofiles(Builder builder) {
                this(builder, true);
            }

            private Rankprofiles(Builder builder, boolean throwIfUninitialized) {
                if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                    throw new IllegalArgumentException("The following builder parameters for qr-searchers.searchcluster[].rankprofiles must be initialized: " + builder.__uninitialized);
                }
                this.configid = builder.configid == null ? new ReferenceNode("") : new ReferenceNode(builder.configid);
            }

            public String configid() {
                return this.configid.value();
            }

            private ChangesRequiringRestart getChangesRequiringRestart(Rankprofiles newConfig) {
                ChangesRequiringRestart changes = new ChangesRequiringRestart("rankprofiles");
                return changes;
            }

            public static final class Builder
            implements ConfigBuilder {
                private Set<String> __uninitialized = new HashSet<String>();
                private String configid = null;

                public Builder() {
                }

                public Builder(Rankprofiles config) {
                    this.configid(config.configid());
                }

                private Builder override(Builder __superior) {
                    if (__superior.configid != null) {
                        this.configid(__superior.configid);
                    }
                    return this;
                }

                public Builder configid(String __value) {
                    if (__value == null) {
                        throw new IllegalArgumentException("Null value is not allowed.");
                    }
                    this.configid = __value;
                    return this;
                }

                public Rankprofiles build() {
                    return new Rankprofiles(this);
                }
            }
        }

        public static final class Indexingmode
        extends EnumNode<Enum> {
            public static final Enum REALTIME = Enum.REALTIME;
            public static final Enum STREAMING = Enum.STREAMING;

            public Indexingmode() {
                this.value = null;
            }

            public Indexingmode(Enum enumValue) {
                super(enumValue != null);
                this.value = enumValue;
            }

            protected boolean doSetValue(String name) {
                try {
                    this.value = Enum.valueOf(name);
                    return true;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return false;
                }
            }

            public static enum Enum {
                REALTIME,
                STREAMING;

            }
        }

        public static final class Storagecluster
        extends InnerNode {
            private final StringNode routespec;

            public Storagecluster(Builder builder) {
                this(builder, true);
            }

            private Storagecluster(Builder builder, boolean throwIfUninitialized) {
                if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                    throw new IllegalArgumentException("The following builder parameters for qr-searchers.searchcluster[].storagecluster must be initialized: " + builder.__uninitialized);
                }
                this.routespec = builder.routespec == null ? new StringNode("") : new StringNode(builder.routespec);
            }

            public String routespec() {
                return this.routespec.value();
            }

            private ChangesRequiringRestart getChangesRequiringRestart(Storagecluster newConfig) {
                ChangesRequiringRestart changes = new ChangesRequiringRestart("storagecluster");
                return changes;
            }

            public static final class Builder
            implements ConfigBuilder {
                private Set<String> __uninitialized = new HashSet<String>();
                private String routespec = null;

                public Builder() {
                }

                public Builder(Storagecluster config) {
                    this.routespec(config.routespec());
                }

                private Builder override(Builder __superior) {
                    if (__superior.routespec != null) {
                        this.routespec(__superior.routespec);
                    }
                    return this;
                }

                public Builder routespec(String __value) {
                    if (__value == null) {
                        throw new IllegalArgumentException("Null value is not allowed.");
                    }
                    this.routespec = __value;
                    return this;
                }

                public Storagecluster build() {
                    return new Storagecluster(this);
                }
            }
        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

