/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jdisc.http;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.eclipse.jetty.http.HttpCookie;
import org.eclipse.jetty.server.Cookies;

public class Cookie {
    private final Set<Integer> ports = new HashSet<Integer>();
    private String name;
    private String value;
    private String domain;
    private String path;
    private SameSite sameSite;
    private long maxAgeSeconds = Integer.MIN_VALUE;
    private boolean secure;
    private boolean httpOnly;
    private boolean discard;

    public Cookie() {
    }

    public Cookie(Cookie cookie) {
        this.ports.addAll(cookie.ports);
        this.name = cookie.name;
        this.value = cookie.value;
        this.domain = cookie.domain;
        this.path = cookie.path;
        this.sameSite = cookie.sameSite;
        this.maxAgeSeconds = cookie.maxAgeSeconds;
        this.secure = cookie.secure;
        this.httpOnly = cookie.httpOnly;
        this.discard = cookie.discard;
    }

    public Cookie(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public Cookie setName(String name) {
        this.name = name;
        return this;
    }

    public String getValue() {
        return this.value;
    }

    public Cookie setValue(String value) {
        this.value = value;
        return this;
    }

    public String getDomain() {
        return this.domain;
    }

    public Cookie setDomain(String domain) {
        this.domain = domain;
        return this;
    }

    public String getPath() {
        return this.path;
    }

    public Cookie setPath(String path) {
        this.path = path;
        return this;
    }

    public SameSite getSameSite() {
        return this.sameSite;
    }

    public Cookie setSameSite(SameSite sameSite) {
        this.sameSite = sameSite;
        return this;
    }

    public int getMaxAge(TimeUnit unit) {
        return (int)unit.convert(this.maxAgeSeconds, TimeUnit.SECONDS);
    }

    public Cookie setMaxAge(int maxAge, TimeUnit unit) {
        this.maxAgeSeconds = maxAge >= 0 ? unit.toSeconds(maxAge) : Integer.MIN_VALUE;
        return this;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public Cookie setSecure(boolean secure) {
        this.secure = secure;
        return this;
    }

    public boolean isHttpOnly() {
        return this.httpOnly;
    }

    public Cookie setHttpOnly(boolean httpOnly) {
        this.httpOnly = httpOnly;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Cookie cookie = (Cookie)o;
        return this.maxAgeSeconds == cookie.maxAgeSeconds && this.secure == cookie.secure && this.httpOnly == cookie.httpOnly && this.discard == cookie.discard && this.sameSite == cookie.sameSite && Objects.equals(this.ports, cookie.ports) && Objects.equals(this.name, cookie.name) && Objects.equals(this.value, cookie.value) && Objects.equals(this.domain, cookie.domain) && Objects.equals(this.path, cookie.path);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.ports, this.name, this.value, this.domain, this.path, this.sameSite, this.maxAgeSeconds, this.secure, this.httpOnly, this.discard});
    }

    public String toString() {
        StringBuilder ret = new StringBuilder();
        ret.append(this.name).append("=").append(this.value);
        return ret.toString();
    }

    public static String toCookieHeader(Iterable<? extends Cookie> cookies) {
        return StreamSupport.stream(cookies.spliterator(), false).map(cookie -> {
            java.net.HttpCookie httpCookie = new java.net.HttpCookie(cookie.getName(), cookie.getValue());
            httpCookie.setDomain(cookie.getDomain());
            httpCookie.setHttpOnly(cookie.isHttpOnly());
            httpCookie.setMaxAge(cookie.getMaxAge(TimeUnit.SECONDS));
            httpCookie.setPath(cookie.getPath());
            httpCookie.setSecure(cookie.isSecure());
            httpCookie.setVersion(0);
            return httpCookie.toString();
        }).collect(Collectors.joining(";"));
    }

    public static List<Cookie> fromCookieHeader(String headerVal) {
        Cookies cookieCutter = new Cookies();
        cookieCutter.addCookieField(headerVal);
        return Arrays.stream(cookieCutter.getCookies()).map(servletCookie -> {
            Cookie cookie = new Cookie();
            cookie.setName(servletCookie.getName());
            cookie.setValue(servletCookie.getValue());
            cookie.setPath(servletCookie.getPath());
            cookie.setDomain(servletCookie.getDomain());
            cookie.setMaxAge(servletCookie.getMaxAge(), TimeUnit.SECONDS);
            cookie.setSecure(servletCookie.getSecure());
            cookie.setHttpOnly(servletCookie.isHttpOnly());
            return cookie;
        }).toList();
    }

    public static List<String> toSetCookieHeaders(Iterable<? extends Cookie> cookies) {
        return StreamSupport.stream(cookies.spliterator(), false).map(cookie -> new HttpCookie(cookie.getName(), cookie.getValue(), cookie.getDomain(), cookie.getPath(), (long)cookie.getMaxAge(TimeUnit.SECONDS), cookie.isHttpOnly(), cookie.isSecure(), null, 0, (HttpCookie.SameSite)Optional.ofNullable(cookie.getSameSite()).map(SameSite::jettySameSite).orElse(null)).getRFC6265SetCookie()).toList();
    }

    public static Cookie fromSetCookieHeader(String headerVal) {
        return java.net.HttpCookie.parse(headerVal).stream().map(httpCookie -> {
            Cookie cookie = new Cookie();
            cookie.setName(httpCookie.getName());
            cookie.setValue(httpCookie.getValue());
            cookie.setDomain(httpCookie.getDomain());
            cookie.setHttpOnly(httpCookie.isHttpOnly());
            cookie.setMaxAge((int)httpCookie.getMaxAge(), TimeUnit.SECONDS);
            cookie.setPath(httpCookie.getPath());
            cookie.setSecure(httpCookie.getSecure());
            return cookie;
        }).findFirst().get();
    }

    public static enum SameSite {
        NONE,
        STRICT,
        LAX;


        HttpCookie.SameSite jettySameSite() {
            return HttpCookie.SameSite.valueOf((String)this.name());
        }

        static SameSite fromJettySameSite(HttpCookie.SameSite jettySameSite) {
            return SameSite.valueOf(jettySameSite.name());
        }
    }
}

