/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.di;

import com.yahoo.concurrent.DaemonThreadFactory;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.subscription.ConfigSource;
import com.yahoo.config.subscription.ConfigSourceSet;
import com.yahoo.config.subscription.ConfigSubscriber;
import com.yahoo.container.di.CloudSubscriber;
import com.yahoo.container.di.config.Subscriber;
import com.yahoo.container.di.config.SubscriberFactory;
import com.yahoo.vespa.config.ConfigKey;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class CloudSubscriberFactory
implements SubscriberFactory {
    private final ConfigSource configSource;
    private final Map<CloudSubscriber, Integer> activeSubscribers = new WeakHashMap<CloudSubscriber, Integer>();
    private final ExecutorService executor;
    private Optional<Long> testGeneration = Optional.empty();

    public CloudSubscriberFactory(ConfigSource configSource) {
        this.configSource = configSource;
        this.executor = new ThreadPoolExecutor(1, Integer.MAX_VALUE, 1L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), (ThreadFactory)new DaemonThreadFactory("cloud-subscriber-factory"));
    }

    @Override
    public void close() {
        this.executor.shutdown();
        try {
            if (!this.executor.awaitTermination(10L, TimeUnit.SECONDS)) {
                this.executor.shutdownNow();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public Subscriber getSubscriber(Set<? extends ConfigKey<?>> configKeys, String name) {
        HashSet<ConfigKey<ConfigInstance>> subscriptionKeys = new HashSet<ConfigKey<ConfigInstance>>();
        Iterator<ConfigKey<?>> iterator = configKeys.iterator();
        while (iterator.hasNext()) {
            ConfigKey<?> key;
            ConfigKey<?> invariant = key = iterator.next();
            subscriptionKeys.add(invariant);
        }
        CloudSubscriber subscriber = new CloudSubscriber(this.executor, name, this.configSource, subscriptionKeys);
        this.testGeneration.ifPresent(arg_0 -> ((ConfigSubscriber)subscriber.getSubscriber()).reload(arg_0));
        this.activeSubscribers.put(subscriber, 0);
        return subscriber;
    }

    @Override
    public void reloadActiveSubscribers(long generation) {
        this.testGeneration = Optional.of(generation);
        ArrayList<CloudSubscriber> subscribers = new ArrayList<CloudSubscriber>(this.activeSubscribers.keySet());
        subscribers.forEach(s -> s.getSubscriber().reload(generation));
    }

    public static class Provider
    implements com.google.inject.Provider<SubscriberFactory> {
        public SubscriberFactory get() {
            return new CloudSubscriberFactory((ConfigSource)ConfigSourceSet.createDefault());
        }
    }
}

