/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container;

import com.yahoo.component.AbstractComponent;
import com.yahoo.component.provider.ComponentRegistry;
import com.yahoo.filedistribution.fileacquirer.FileAcquirer;
import com.yahoo.filedistribution.fileacquirer.FileAcquirerFactory;
import com.yahoo.jdisc.handler.RequestHandler;
import com.yahoo.jdisc.service.ClientProvider;
import com.yahoo.jdisc.service.ServerProvider;
import com.yahoo.vespa.config.ConfigTransformer;
import com.yahoo.vespa.config.UrlDownloader;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;

public class Container {
    private volatile boolean usingCustomFileAcquirer = false;
    private volatile boolean disabledUrlDownloader = false;
    private volatile ComponentRegistry<RequestHandler> requestHandlerRegistry;
    private volatile ComponentRegistry<ClientProvider> clientProviderRegistry;
    private volatile ComponentRegistry<ServerProvider> serverProviderRegistry;
    private volatile ComponentRegistry<AbstractComponent> componentRegistry;
    private volatile FileAcquirer fileAcquirer;
    private volatile UrlDownloader urlDownloader;
    private static final Logger logger = Logger.getLogger(Container.class.getName());
    private static Container instance = new Container();

    public static Container get() {
        return instance;
    }

    public void shutdown() {
        if (this.fileAcquirer != null) {
            this.fileAcquirer.shutdown();
        }
        if (this.urlDownloader != null) {
            this.urlDownloader.shutdown();
        }
    }

    public FileAcquirer getFileAcquirer() {
        return this.fileAcquirer;
    }

    public static void resetInstance() {
        instance = new Container();
    }

    public ComponentRegistry<RequestHandler> getRequestHandlerRegistry() {
        return this.requestHandlerRegistry;
    }

    public void setRequestHandlerRegistry(ComponentRegistry<RequestHandler> requestHandlerRegistry) {
        this.requestHandlerRegistry = requestHandlerRegistry;
    }

    public ComponentRegistry<ClientProvider> getClientProviderRegistry() {
        return this.clientProviderRegistry;
    }

    public void setClientProviderRegistry(ComponentRegistry<ClientProvider> clientProviderRegistry) {
        this.clientProviderRegistry = clientProviderRegistry;
    }

    public ComponentRegistry<ServerProvider> getServerProviderRegistry() {
        return this.serverProviderRegistry;
    }

    public void setServerProviderRegistry(ComponentRegistry<ServerProvider> serverProviderRegistry) {
        this.serverProviderRegistry = serverProviderRegistry;
    }

    public ComponentRegistry<AbstractComponent> getComponentRegistry() {
        return this.componentRegistry;
    }

    public void setComponentRegistry(ComponentRegistry<AbstractComponent> registry) {
        registry.freeze();
        this.componentRegistry = registry;
    }

    public void setupFileAcquirer() {
        if (this.usingCustomFileAcquirer) {
            return;
        }
        this.fileAcquirer = FileAcquirerFactory.create();
        Container.setPathAcquirer(this.fileAcquirer);
    }

    public void setCustomFileAcquirer(FileAcquirer fileAcquirer) {
        if (this.fileAcquirer != null) {
            throw new RuntimeException("Can't change file acquirer. Is " + this.fileAcquirer + " attempted to set to " + fileAcquirer);
        }
        this.usingCustomFileAcquirer = true;
        this.fileAcquirer = fileAcquirer;
        Container.setPathAcquirer(fileAcquirer);
    }

    private static void setPathAcquirer(FileAcquirer fileAcquirer) {
        ConfigTransformer.setPathAcquirer(fileReference -> {
            try {
                return fileAcquirer.waitFor(fileReference, 15L, TimeUnit.MINUTES).toPath();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
        });
    }

    public void setupUrlDownloader() {
        if (this.disabledUrlDownloader) {
            return;
        }
        this.urlDownloader = new UrlDownloader();
        ConfigTransformer.setUrlDownloader((UrlDownloader)this.urlDownloader);
    }

    public void disableUrlDownloader() {
        this.disabledUrlDownloader = true;
    }
}

