/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.jdisc.state;

import ai.vespa.metrics.set.InfrastructureMetricSet;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.yahoo.collections.Tuple2;
import com.yahoo.component.annotation.Inject;
import com.yahoo.component.provider.ComponentRegistry;
import com.yahoo.container.jdisc.state.CountMetric;
import com.yahoo.container.jdisc.state.GaugeMetric;
import com.yahoo.container.jdisc.state.HostLifeGatherer;
import com.yahoo.container.jdisc.state.JsonUtil;
import com.yahoo.container.jdisc.state.MetricDimensions;
import com.yahoo.container.jdisc.state.MetricSet;
import com.yahoo.container.jdisc.state.MetricSnapshot;
import com.yahoo.container.jdisc.state.MetricValue;
import com.yahoo.container.jdisc.state.MetricsPacketsHandlerConfig;
import com.yahoo.container.jdisc.state.PrometheusHelper;
import com.yahoo.container.jdisc.state.SnapshotProvider;
import com.yahoo.container.jdisc.state.StateHandler;
import com.yahoo.jdisc.Request;
import com.yahoo.jdisc.Response;
import com.yahoo.jdisc.Timer;
import com.yahoo.jdisc.handler.AbstractRequestHandler;
import com.yahoo.jdisc.handler.ContentChannel;
import com.yahoo.jdisc.handler.ResponseDispatch;
import com.yahoo.jdisc.handler.ResponseHandler;
import com.yahoo.json.Jackson;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public class MetricsPacketsHandler
extends AbstractRequestHandler {
    private static final ObjectMapper jsonMapper = Jackson.mapper();
    static final String APPLICATION_KEY = "application";
    static final String TIMESTAMP_KEY = "timestamp";
    static final String METRICS_KEY = "metrics";
    static final String DIMENSIONS_KEY = "dimensions";
    static final String PACKET_SEPARATOR = "\n\n";
    private final Timer timer;
    private final SnapshotProvider snapshotProvider;
    private final String applicationName;
    private final String hostDimension;
    private final Map<String, Set<String>> metricSets;

    @Inject
    public MetricsPacketsHandler(Timer timer, ComponentRegistry<SnapshotProvider> snapshotProviders, MetricsPacketsHandlerConfig config) {
        this.timer = timer;
        this.snapshotProvider = StateHandler.getSnapshotProviderOrThrow(snapshotProviders);
        this.applicationName = config.application();
        this.hostDimension = config.hostname();
        this.metricSets = this.getMetricSets();
    }

    public ContentChannel handleRequest(final Request request, ResponseHandler handler) {
        new ResponseDispatch(){

            protected Response newResponse() {
                Response response = new Response(200);
                response.headers().add("Content-Type", MetricsPacketsHandler.this.getContentType(request.getUri().getQuery()));
                return response;
            }

            protected Iterable<ByteBuffer> responseContent() {
                return Collections.singleton(ByteBuffer.wrap(MetricsPacketsHandler.this.buildMetricOutput(request.getUri().getQuery())));
            }
        }.dispatch(handler);
        return null;
    }

    private byte[] buildMetricOutput(String query) {
        try {
            Map<String, String> queryMap = this.parseQuery(query);
            String metricSetId = queryMap.get("metric-set");
            String format = queryMap.get("format");
            if ("array".equals(format)) {
                return this.getMetricsArray(metricSetId);
            }
            if ("prometheus".equals(format)) {
                return this.buildPrometheusOutput(metricSetId);
            }
            String output = this.getAllMetricsPackets(metricSetId) + "\n";
            return output.getBytes(StandardCharsets.UTF_8);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Bad JSON construction.", e);
        }
        catch (IOException e) {
            throw new RuntimeException("Unexcpected IOException.", e);
        }
    }

    private byte[] getMetricsArray(String metricSetId) throws JsonProcessingException {
        ObjectNode root = jsonMapper.createObjectNode();
        ArrayNode jsonArray = jsonMapper.createArrayNode();
        this.getPacketsForSnapshot(this.getSnapshot(), metricSetId, this.applicationName, this.timer.currentTimeMillis()).forEach(arg_0 -> ((ArrayNode)jsonArray).add(arg_0));
        root.set(METRICS_KEY, (JsonNode)jsonArray);
        return MetricsPacketsHandler.jsonToString((JsonNode)root).getBytes(StandardCharsets.UTF_8);
    }

    private byte[] buildPrometheusOutput(String metricSetId) throws IOException {
        List<JsonNode> metrics = this.getPacketsForSnapshot(this.getSnapshot(), metricSetId, this.applicationName, this.timer.currentTimeMillis());
        return PrometheusHelper.buildPrometheusOutput(metrics, this.timer.currentTimeMillis());
    }

    private static String jsonToString(JsonNode jsonObject) throws JsonProcessingException {
        return jsonMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)jsonObject);
    }

    private String getAllMetricsPackets(String metricSetId) throws JsonProcessingException {
        StringBuilder ret = new StringBuilder();
        List<JsonNode> metricsPackets = this.getPacketsForSnapshot(this.getSnapshot(), metricSetId, this.applicationName, this.timer.currentTimeMillis());
        String delimiter = "";
        for (JsonNode packet : metricsPackets) {
            ret.append(delimiter);
            ret.append(MetricsPacketsHandler.jsonToString(packet));
            delimiter = PACKET_SEPARATOR;
        }
        return ret.toString();
    }

    private MetricSnapshot getSnapshot() {
        return this.snapshotProvider.latestSnapshot();
    }

    private List<JsonNode> getPacketsForSnapshot(MetricSnapshot metricSnapshot, String application, long timestamp) {
        if (metricSnapshot == null) {
            return Collections.emptyList();
        }
        ArrayList<JsonNode> packets = new ArrayList<JsonNode>();
        for (Map.Entry<MetricDimensions, MetricSet> snapshotEntry : metricSnapshot) {
            MetricDimensions metricDimensions = snapshotEntry.getKey();
            MetricSet metricSet = snapshotEntry.getValue();
            ObjectNode packet = jsonMapper.createObjectNode();
            this.addMetaData(timestamp, application, packet);
            this.addDimensions(metricDimensions, packet);
            this.addMetrics(metricSet, packet);
            packets.add((JsonNode)packet);
        }
        return packets;
    }

    private List<JsonNode> getPacketsForSnapshot(MetricSnapshot metricSnapshot, String metricSetId, String application, long timestamp) {
        if (metricSnapshot == null) {
            return Collections.emptyList();
        }
        if (metricSetId == null) {
            return this.getPacketsForSnapshot(metricSnapshot, application, timestamp);
        }
        Set configuredMetrics = this.metricSets.getOrDefault(metricSetId, Collections.emptySet());
        ArrayList<JsonNode> packets = new ArrayList<JsonNode>();
        for (Map.Entry<MetricDimensions, MetricSet> snapshotEntry : metricSnapshot) {
            MetricDimensions metricDimensions = snapshotEntry.getKey();
            MetricSet metricSet = snapshotEntry.getValue();
            ObjectNode packet = jsonMapper.createObjectNode();
            this.addMetaData(timestamp, application, packet);
            this.addDimensions(metricDimensions, packet);
            Map<String, Number> metrics = this.getMetrics(metricSet);
            metrics.keySet().retainAll(configuredMetrics);
            if (metrics.isEmpty()) continue;
            this.addMetrics(metrics, packet);
            packets.add((JsonNode)packet);
        }
        packets.add(HostLifeGatherer.getHostLifePacket());
        return packets;
    }

    private void addMetaData(long timestamp, String application, ObjectNode packet) {
        packet.put(APPLICATION_KEY, application);
        packet.put(TIMESTAMP_KEY, TimeUnit.MILLISECONDS.toSeconds(timestamp));
    }

    private void addDimensions(MetricDimensions metricDimensions, ObjectNode packet) {
        if (metricDimensions == null && this.hostDimension.isEmpty()) {
            return;
        }
        ObjectNode jsonDim = jsonMapper.createObjectNode();
        packet.set(DIMENSIONS_KEY, (JsonNode)jsonDim);
        Iterable dimensionIterator = metricDimensions == null ? Set.of() : metricDimensions;
        for (Map.Entry dimensionEntry : dimensionIterator) {
            jsonDim.put((String)dimensionEntry.getKey(), (String)dimensionEntry.getValue());
        }
        if (!this.hostDimension.isEmpty() && !jsonDim.has("host")) {
            jsonDim.put("host", this.hostDimension);
        }
    }

    private void addMetrics(MetricSet metricSet, ObjectNode packet) {
        ObjectNode metrics = jsonMapper.createObjectNode();
        packet.set(METRICS_KEY, (JsonNode)metrics);
        for (Map.Entry<String, MetricValue> metric : metricSet) {
            String name = metric.getKey();
            MetricValue value = metric.getValue();
            if (value instanceof CountMetric) {
                metrics.put(name + ".count", ((CountMetric)value).getCount());
                continue;
            }
            if (value instanceof GaugeMetric) {
                GaugeMetric gauge = (GaugeMetric)value;
                metrics.put(name + ".average", JsonUtil.sanitizeDouble(gauge.getAverage())).put(name + ".last", JsonUtil.sanitizeDouble(gauge.getLast())).put(name + ".max", JsonUtil.sanitizeDouble(gauge.getMax())).put(name + ".min", JsonUtil.sanitizeDouble(gauge.getMin())).put(name + ".sum", JsonUtil.sanitizeDouble(gauge.getSum())).put(name + ".count", gauge.getCount());
                if (!gauge.getPercentiles().isPresent()) continue;
                for (Tuple2<String, Double> prefixAndValue : gauge.getPercentiles().get()) {
                    metrics.put(name + "." + (String)prefixAndValue.first + "percentile", ((Double)prefixAndValue.second).doubleValue());
                }
                continue;
            }
            throw new UnsupportedOperationException("Unknown metric class: " + value.getClass().getName());
        }
    }

    private Map<String, Number> getMetrics(MetricSet metricSet) {
        HashMap<String, Number> metrics = new HashMap<String, Number>();
        for (Map.Entry<String, MetricValue> metric : metricSet) {
            String name = metric.getKey();
            MetricValue value = metric.getValue();
            if (value instanceof CountMetric) {
                metrics.put(name + ".count", ((CountMetric)value).getCount());
                continue;
            }
            if (value instanceof GaugeMetric) {
                GaugeMetric gauge = (GaugeMetric)value;
                metrics.put(name + ".average", JsonUtil.sanitizeDouble(gauge.getAverage()));
                metrics.put(name + ".last", JsonUtil.sanitizeDouble(gauge.getLast()));
                metrics.put(name + ".max", JsonUtil.sanitizeDouble(gauge.getMax()));
                metrics.put(name + ".min", JsonUtil.sanitizeDouble(gauge.getMin()));
                metrics.put(name + ".sum", JsonUtil.sanitizeDouble(gauge.getSum()));
                metrics.put(name + ".count", gauge.getCount());
                if (!gauge.getPercentiles().isPresent()) continue;
                for (Tuple2<String, Double> prefixAndValue : gauge.getPercentiles().get()) {
                    metrics.put(name + "." + (String)prefixAndValue.first + "percentile", (Number)prefixAndValue.second);
                }
                continue;
            }
            throw new UnsupportedOperationException("Unknown metric class: " + value.getClass().getName());
        }
        return metrics;
    }

    private void addMetrics(Map<String, Number> metrics, ObjectNode packet) {
        ObjectNode metricsObject = jsonMapper.createObjectNode();
        packet.set(METRICS_KEY, (JsonNode)metricsObject);
        metrics.forEach((name, value) -> {
            if (value instanceof Double) {
                metricsObject.put(name, (Double)value);
            } else {
                metricsObject.put(name, (Long)value);
            }
        });
    }

    private String getContentType(String query) {
        if ("format=prometheus".equals(query)) {
            return "text/plain;charset=utf-8";
        }
        return "application/json";
    }

    private Map<String, String> parseQuery(String query) {
        if (query == null) {
            return Map.of();
        }
        return Arrays.stream(query.split("&")).map(s -> s.split("=")).collect(Collectors.toMap(s -> s[0], s -> ((String[])s).length < 2 ? "" : s[1]));
    }

    private Map<String, Set<String>> getMetricSets() {
        return Map.of(InfrastructureMetricSet.infrastructureMetricSet.getId(), InfrastructureMetricSet.infrastructureMetricSet.getMetrics().keySet());
    }
}

