/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.metrics.simple.jdisc;

import com.yahoo.container.jdisc.MetricConsumerFactory;
import com.yahoo.container.jdisc.state.MetricSnapshot;
import com.yahoo.container.jdisc.state.SnapshotProvider;
import com.yahoo.jdisc.application.MetricConsumer;
import com.yahoo.metrics.simple.Bucket;
import com.yahoo.metrics.simple.MetricReceiver;
import com.yahoo.metrics.simple.jdisc.SimpleMetricConsumer;
import com.yahoo.metrics.simple.jdisc.SnapshotConverter;
import java.io.PrintStream;
import java.util.logging.Logger;

public class JdiscMetricsFactory
implements MetricConsumerFactory,
SnapshotProvider {
    private static final Logger log = Logger.getLogger(JdiscMetricsFactory.class.getName());
    private final SimpleMetricConsumer metricInstance;
    private final MetricReceiver metricReceiver;

    public JdiscMetricsFactory(MetricReceiver receiver) {
        this.metricReceiver = receiver;
        this.metricInstance = new SimpleMetricConsumer(receiver);
    }

    @Override
    public MetricConsumer newInstance() {
        return this.metricInstance;
    }

    @Override
    public MetricSnapshot latestSnapshot() {
        Bucket curr = this.metricReceiver.getSnapshot();
        if (curr == null) {
            log.warning("no snapshot from instance of " + this.metricReceiver.getClass());
            return null;
        }
        SnapshotConverter converter = new SnapshotConverter(curr);
        return converter.convert();
    }

    @Override
    public void histogram(PrintStream output) {
        Bucket curr = this.metricReceiver.getSnapshot();
        if (curr == null) {
            log.warning("no snapshot from instance of " + this.metricReceiver.getClass());
        } else {
            SnapshotConverter converter = new SnapshotConverter(curr);
            converter.outputHistograms(output);
        }
    }
}

