/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.metrics.simple;

import com.yahoo.api.annotations.Beta;
import com.yahoo.collections.Tuple2;
import com.yahoo.jdisc.Metric;
import com.yahoo.metrics.simple.Value;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

@Beta
public final class Point
implements Metric.Context {
    private final Value[] location;
    private final String[] dimensions;
    private final int hashCode;
    private static final Point theEmptyPoint = new Point(new String[0], new Value[0]);

    public Point(Map<String, ?> properties) {
        this(Point.buildParameters(properties));
    }

    private Point(Tuple2<String[], Value[]> dimensionsAndLocation) {
        this((String[])dimensionsAndLocation.first, (Value[])dimensionsAndLocation.second);
    }

    Point(String[] dimensions, Value[] location) {
        this.dimensions = dimensions;
        this.location = location;
        this.hashCode = Arrays.hashCode(location) * 31 + Arrays.hashCode(dimensions);
    }

    public static Point emptyPoint() {
        return theEmptyPoint;
    }

    private static Tuple2<String[], Value[]> buildParameters(Map<String, ?> properties) {
        Object[] dimensions = properties.keySet().toArray(new String[0]);
        Arrays.sort(dimensions);
        Value[] location = new Value[dimensions.length];
        for (int i = 0; i < dimensions.length; ++i) {
            location[i] = Value.of(String.valueOf(properties.get(dimensions[i])));
        }
        return new Tuple2((Object)dimensions, (Object)location);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Point other = (Point)obj;
        return Arrays.equals(this.dimensions, other.dimensions) && Arrays.equals(this.location, other.location);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        int maxLen = 3;
        StringBuilder builder = new StringBuilder();
        builder.append("Point [location=").append(Arrays.asList(this.location).subList(0, Math.min(this.location.length, 3))).append(", dimensions=").append(Arrays.asList(this.dimensions).subList(0, Math.min(this.dimensions.length, 3))).append("]");
        return builder.toString();
    }

    public List<Value> location() {
        return List.of(this.location);
    }

    public List<String> dimensions() {
        return List.of(this.dimensions);
    }

    public int dimensionality() {
        return this.dimensions.length;
    }

    String[] getDimensions() {
        return this.dimensions;
    }

    Value[] getLocation() {
        return this.location;
    }
}

