/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jdisc.http.server.jetty;

import com.yahoo.jdisc.Metric;
import com.yahoo.jdisc.http.ConnectorConfig;
import com.yahoo.jdisc.http.server.jetty.ConnectionMetricAggregator;
import com.yahoo.jdisc.http.server.jetty.ConnectionThrottler;
import com.yahoo.jdisc.http.server.jetty.JettyConnectionLogger;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jetty.io.ConnectionStatistics;
import org.eclipse.jetty.server.AbstractConnector;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;

class JDiscServerConnector
extends ServerConnector {
    public static final String REQUEST_ATTRIBUTE = JDiscServerConnector.class.getName();
    private final Metric.Context metricCtx;
    private final ConnectionStatistics statistics;
    private final ConnectorConfig config;
    private final Metric metric;
    private final String connectorName;
    private final int listenPort;
    private final List<String> knownServerNames;

    JDiscServerConnector(ConnectorConfig config, Metric metric, Server server, JettyConnectionLogger connectionLogger, ConnectionMetricAggregator connectionMetricAggregator, ConnectionFactory ... factories) {
        super(server, factories);
        this.config = config;
        this.metric = metric;
        this.connectorName = config.name();
        this.listenPort = config.listenPort();
        this.metricCtx = metric.createContext(JDiscServerConnector.createConnectorDimensions(this.listenPort, this.connectorName, 0));
        this.knownServerNames = List.copyOf(config.serverName().known());
        this.statistics = new ConnectionStatistics();
        this.setAcceptedTcpNoDelay(config.tcpNoDelay());
        this.addBean(this.statistics);
        ConnectorConfig.Throttling throttlingConfig = config.throttling();
        if (throttlingConfig.enabled()) {
            new ConnectionThrottler((AbstractConnector)this, throttlingConfig).registerWithConnector();
        }
        this.addBean((Object)connectionLogger);
        this.addBean((Object)connectionMetricAggregator);
        this.setPort(config.listenPort());
        this.setName(config.name());
        this.setAcceptQueueSize(config.acceptQueueSize());
        this.setReuseAddress(config.reuseAddress());
        this.setIdleTimeout((long)(config.idleTimeout() * 1000.0));
    }

    public ConnectionStatistics getStatistics() {
        return this.statistics;
    }

    public Metric.Context getConnectorMetricContext() {
        return this.metricCtx;
    }

    public Metric.Context createRequestMetricContext(HttpServletRequest request, Map<String, String> extraDimensions) {
        String method = request.getMethod();
        String scheme = request.getScheme();
        boolean clientAuthenticated = request.getAttribute("jakarta.servlet.request.X509Certificate") != null;
        Map<String, Object> dimensions = JDiscServerConnector.createConnectorDimensions(this.listenPort, this.connectorName, extraDimensions.size() + 5);
        dimensions.put("httpMethod", method);
        dimensions.put("scheme", scheme);
        dimensions.put("clientAuthenticated", Boolean.toString(clientAuthenticated));
        dimensions.put("protocol", request.getProtocol());
        String serverName = this.knownServerNames.stream().filter(name -> name.equalsIgnoreCase(request.getServerName())).findFirst().orElse("unknown");
        dimensions.put("requestServerName", serverName);
        dimensions.putAll(extraDimensions);
        return this.metric.createContext(dimensions);
    }

    public static JDiscServerConnector fromRequest(ServletRequest request) {
        return (JDiscServerConnector)((Object)request.getAttribute(REQUEST_ATTRIBUTE));
    }

    ConnectorConfig connectorConfig() {
        return this.config;
    }

    int listenPort() {
        return this.listenPort;
    }

    private static Map<String, Object> createConnectorDimensions(int listenPort, String connectorName, int reservedSize) {
        HashMap<String, Object> props = new HashMap<String, Object>(reservedSize + 2);
        props.put("serverName", connectorName);
        props.put("serverPort", listenPort);
        return props;
    }
}

