/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.restapi;

import java.net.URI;
import java.net.URISyntaxException;

public class UriBuilder {
    private final URI uri;

    public UriBuilder(URI uri) {
        this.uri = uri;
    }

    public UriBuilder(String uri) {
        try {
            this.uri = new URI(uri);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid URI", e);
        }
    }

    public UriBuilder append(String pathElement) {
        return new UriBuilder(this.withoutParameters().withTrailingSlash() + pathElement);
    }

    public UriBuilder withoutParameters() {
        int parameterStart = this.uri.toString().indexOf("?");
        if (parameterStart < 0) {
            return new UriBuilder(this.uri.toString());
        }
        return new UriBuilder(this.uri.toString().substring(0, parameterStart));
    }

    public UriBuilder withPath(String path) {
        try {
            return new UriBuilder(new URI(this.uri.getScheme(), this.uri.getUserInfo(), this.uri.getHost(), this.uri.getPort(), path, this.uri.getQuery(), this.uri.getFragment()));
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Could not add path '" + path + "' to " + this);
        }
    }

    public UriBuilder withTrailingSlash() {
        if (this.toString().endsWith("/")) {
            return this;
        }
        return new UriBuilder(this.toString() + "/");
    }

    public URI toURI() {
        return this.uri;
    }

    public String toString() {
        return this.uri.toString();
    }
}

