/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jdisc.http;

import com.yahoo.jdisc.HeaderFields;
import com.yahoo.jdisc.Request;
import com.yahoo.jdisc.http.Cookie;
import com.yahoo.jdisc.service.CurrentContainer;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.security.Principal;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.util.MultiMap;
import org.eclipse.jetty.util.UrlEncoded;

public class HttpRequest
extends Request {
    private final long jvmRelativeCreatedAt = System.nanoTime();
    private final HeaderFields trailers = new HeaderFields();
    private final Map<String, List<String>> parameters = new HashMap<String, List<String>>();
    private volatile Principal principal;
    private final long connectedAt;
    private Method method;
    private Version version;
    private SocketAddress remoteAddress;
    private URI proxyServer;
    private Long connectionTimeout;

    protected HttpRequest(CurrentContainer container, URI uri, Method method, Version version, SocketAddress remoteAddress, Long connectedAtMillis, long creationTime) {
        super(container, uri, true, creationTime);
        try {
            this.method = method;
            this.version = version;
            this.remoteAddress = remoteAddress;
            this.parameters.putAll(HttpRequest.getUriQueryParameters(uri));
            this.connectedAt = connectedAtMillis != null ? connectedAtMillis.longValue() : this.creationTime(TimeUnit.MILLISECONDS);
        }
        catch (Throwable e) {
            this.release();
            throw e;
        }
    }

    private HttpRequest(Request parent, URI uri, Method method, Version version) {
        super(parent, uri);
        try {
            this.method = method;
            this.version = version;
            this.remoteAddress = null;
            this.parameters.putAll(HttpRequest.getUriQueryParameters(uri));
            this.connectedAt = this.creationTime(TimeUnit.MILLISECONDS);
        }
        catch (Throwable e) {
            this.release();
            throw e;
        }
    }

    private static Map<String, List<String>> getUriQueryParameters(URI uri) {
        if (uri.getRawQuery() == null) {
            return Map.of();
        }
        MultiMap params = new MultiMap();
        UrlEncoded.decodeUtf8To((String)uri.getRawQuery(), (MultiMap)params);
        return Map.copyOf(params);
    }

    public Method getMethod() {
        return this.method;
    }

    public void setMethod(Method method) {
        this.method = method;
    }

    public Version getVersion() {
        return this.version;
    }

    public String getRemoteHostAddress() {
        if (this.remoteAddress instanceof InetSocketAddress) {
            InetAddress remoteInetAddress = ((InetSocketAddress)this.remoteAddress).getAddress();
            if (remoteInetAddress == null) {
                return null;
            }
            return remoteInetAddress.getHostAddress();
        }
        throw new RuntimeException("Unknown SocketAddress class: " + this.remoteAddress.getClass().getName());
    }

    public String getRemoteHostName() {
        if (this.remoteAddress instanceof InetSocketAddress) {
            InetAddress remoteInetAddress = ((InetSocketAddress)this.remoteAddress).getAddress();
            if (remoteInetAddress == null) {
                return null;
            }
            return remoteInetAddress.getHostName();
        }
        throw new RuntimeException("Unknown SocketAddress class: " + this.remoteAddress.getClass().getName());
    }

    public int getRemotePort() {
        if (this.remoteAddress instanceof InetSocketAddress) {
            return ((InetSocketAddress)this.remoteAddress).getPort();
        }
        throw new RuntimeException("Unknown SocketAddress class: " + this.remoteAddress.getClass().getName());
    }

    public void setVersion(Version version) {
        this.version = version;
    }

    public SocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    public void setRemoteAddress(SocketAddress remoteAddress) {
        this.remoteAddress = remoteAddress;
    }

    public URI getProxyServer() {
        return this.proxyServer;
    }

    public void setProxyServer(URI proxyServer) {
        this.proxyServer = proxyServer;
    }

    public long getConnectedAt(TimeUnit unit) {
        return unit.convert(this.connectedAt, TimeUnit.MILLISECONDS);
    }

    public Long getConnectionTimeout(TimeUnit unit) {
        if (this.connectionTimeout == null) {
            return null;
        }
        return unit.convert(this.connectionTimeout, TimeUnit.MILLISECONDS);
    }

    public void setConnectionTimeout(long timeout, TimeUnit unit) {
        this.connectionTimeout = unit.toMillis(timeout);
    }

    public Map<String, List<String>> parameters() {
        return this.parameters;
    }

    public void copyHeaders(HeaderFields target) {
        target.addAll((Map)this.headers());
    }

    public List<Cookie> decodeCookieHeader() {
        List cookies = this.headers().get((Object)"Cookie");
        if (cookies == null) {
            return Collections.emptyList();
        }
        LinkedList<Cookie> ret = new LinkedList<Cookie>();
        for (String cookie : cookies) {
            ret.addAll(Cookie.fromCookieHeader(cookie));
        }
        return ret;
    }

    public void encodeCookieHeader(List<Cookie> cookies) {
        this.headers().put("Cookie", Cookie.toCookieHeader(cookies));
    }

    public HeaderFields trailers() {
        return this.trailers;
    }

    public boolean isChunked() {
        return this.version == Version.HTTP_1_1 && this.headers().containsIgnoreCase("Transfer-Encoding", "chunked");
    }

    public boolean hasChunkedResponse() {
        return this.version == Version.HTTP_1_1 && !this.headers().isTrue("X-JDisc-Disable-Chunking");
    }

    public boolean isKeepAlive() {
        if (this.headers().containsIgnoreCase("Connection", "keep-alive")) {
            return true;
        }
        if (this.headers().containsIgnoreCase("Connection", "close")) {
            return false;
        }
        return this.version == Version.HTTP_1_1;
    }

    public long relativeCreatedAtNanoTime() {
        return this.jvmRelativeCreatedAt;
    }

    public Principal getUserPrincipal() {
        return this.principal;
    }

    public void setUserPrincipal(Principal principal) {
        this.principal = principal;
    }

    public static HttpRequest newServerRequest(CurrentContainer container, URI uri) {
        return HttpRequest.newServerRequest(container, uri, Method.GET);
    }

    public static HttpRequest newServerRequest(CurrentContainer container, URI uri, Method method) {
        return HttpRequest.newServerRequest(container, uri, method, Version.HTTP_1_1);
    }

    public static HttpRequest newServerRequest(CurrentContainer container, URI uri, Method method, Version version) {
        return HttpRequest.newServerRequest(container, uri, method, version, null);
    }

    public static HttpRequest newServerRequest(CurrentContainer container, URI uri, Method method, Version version, SocketAddress remoteAddress) {
        return new HttpRequest(container, uri, method, version, remoteAddress, null, -1L);
    }

    public static HttpRequest newServerRequest(CurrentContainer container, URI uri, Method method, Version version, SocketAddress remoteAddress, long connectedAtMillis, long creationTime) {
        return new HttpRequest(container, uri, method, version, remoteAddress, connectedAtMillis, creationTime);
    }

    public static HttpRequest newClientRequest(Request parent, URI uri) {
        return HttpRequest.newClientRequest(parent, uri, Method.GET);
    }

    public static HttpRequest newClientRequest(Request parent, URI uri, Method method) {
        return HttpRequest.newClientRequest(parent, uri, method, Version.HTTP_1_1);
    }

    public static HttpRequest newClientRequest(Request parent, URI uri, Method method, Version version) {
        return new HttpRequest(parent, uri, method, version);
    }

    public static enum Method {
        OPTIONS,
        GET,
        HEAD,
        POST,
        PUT,
        PATCH,
        DELETE,
        TRACE,
        CONNECT;

    }

    public static enum Version {
        HTTP_1_0("HTTP/1.0"),
        HTTP_1_1("HTTP/1.1"),
        HTTP_2_0("HTTP/2.0");

        private final String str;

        private Version(String str) {
            this.str = str;
        }

        public String toString() {
            return this.str;
        }

        public static Version fromString(String str) {
            for (Version version : Version.values()) {
                if (!version.str.equals(str)) continue;
                return version;
            }
            throw new IllegalArgumentException(str);
        }
    }
}

