/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.jdisc.state;

import com.yahoo.collections.Tuple2;
import com.yahoo.container.jdisc.state.MetricValue;
import java.util.List;
import java.util.Optional;

public final class GaugeMetric
extends MetricValue {
    private double last;
    private double max;
    private double min;
    private double sum;
    private long count;
    private final Optional<List<Tuple2<String, Double>>> percentiles;

    private GaugeMetric(double last, double max, double min, double sum, long count, Optional<List<Tuple2<String, Double>>> percentiles) {
        this.last = last;
        this.max = max;
        this.min = min;
        this.sum = sum;
        this.count = count;
        this.percentiles = percentiles;
    }

    @Override
    void add(Number val) {
        double dval;
        this.last = dval = val.doubleValue();
        if (dval > this.max) {
            this.max = dval;
        }
        if (dval < this.min) {
            this.min = dval;
        }
        this.sum += dval;
        ++this.count;
    }

    @Override
    void add(MetricValue val) {
        GaugeMetric rhs = (GaugeMetric)val;
        this.last = rhs.last;
        if (rhs.max > this.max) {
            this.max = rhs.max;
        }
        if (rhs.min < this.min) {
            this.min = rhs.min;
        }
        this.sum += rhs.sum;
        this.count += rhs.count;
    }

    public double getAverage() {
        return this.count != 0L ? this.sum / (double)this.count : this.last;
    }

    public double getLast() {
        return this.last;
    }

    public double getMax() {
        return this.count == 0L ? this.last : this.max;
    }

    public double getMin() {
        return this.count == 0L ? this.last : this.min;
    }

    public double getSum() {
        return this.sum;
    }

    public long getCount() {
        return this.count;
    }

    public Optional<List<Tuple2<String, Double>>> getPercentiles() {
        return this.percentiles;
    }

    public GaugeMetric newWithPreservedLastValue() {
        return new GaugeMetric(this.last, Double.MIN_VALUE, Double.MAX_VALUE, 0.0, 0L, Optional.empty());
    }

    public static GaugeMetric newSingleValue(Number val) {
        double dval = val.doubleValue();
        return new GaugeMetric(dval, dval, dval, dval, 1L, Optional.empty());
    }

    public static GaugeMetric newInstance(double last, double max, double min, double sum, long count) {
        return new GaugeMetric(last, max, min, sum, count, Optional.empty());
    }

    public static GaugeMetric newInstance(double last, double max, double min, double sum, long count, Optional<List<Tuple2<String, Double>>> percentiles) {
        return new GaugeMetric(last, max, min, sum, count, percentiles);
    }
}

