/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.di.componentgraph.core;

import com.google.inject.Key;
import com.yahoo.component.ComponentId;
import com.yahoo.config.ConfigInstance;
import com.yahoo.container.di.componentgraph.core.Keys;
import com.yahoo.container.di.componentgraph.core.Node;
import com.yahoo.vespa.config.ConfigKey;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public final class GuiceNode
extends Node {
    private static final ComponentId guiceNamespace = ComponentId.fromString((String)"Guice");
    private final Object myInstance;
    private final Annotation annotation;

    public GuiceNode(Object myInstance, Annotation annotation) {
        super(GuiceNode.componentId(myInstance));
        this.myInstance = myInstance;
        this.annotation = annotation;
    }

    @Override
    public Set<ConfigKey<ConfigInstance>> configKeys() {
        return Collections.emptySet();
    }

    @Override
    public Key<?> instanceKey() {
        return Keys.createKey(this.myInstance.getClass(), this.annotation);
    }

    @Override
    public Class<?> instanceType() {
        return this.myInstance.getClass();
    }

    @Override
    public Class<?> componentType() {
        return this.instanceType();
    }

    @Override
    public List<Node> usedComponents() {
        return Collections.emptyList();
    }

    @Override
    protected Object newInstance() {
        return this.myInstance;
    }

    @Override
    public void inject(Node component) {
        throw new UnsupportedOperationException("Illegal to inject components to a GuiceNode!");
    }

    @Override
    public String label() {
        return String.format("{{%s|Guice}|%s}", this.instanceType().getSimpleName(), Node.packageName(this.instanceType()));
    }

    private static ComponentId componentId(Object instance) {
        return Node.syntheticComponentId(instance.getClass().getName(), instance, guiceNamespace);
    }
}

