/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jdisc.http.filter;

import com.yahoo.container.jdisc.RequestView;
import com.yahoo.jdisc.HeaderFields;
import com.yahoo.jdisc.http.Cookie;
import com.yahoo.jdisc.http.HttpRequest;
import com.yahoo.jdisc.http.filter.JDiscCookieWrapper;
import java.net.InetSocketAddress;
import java.net.URI;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;

public class DiscFilterRequest {
    protected static final String HTTPS_PREFIX = "https";
    protected static final int DEFAULT_HTTP_PORT = 80;
    protected static final int DEFAULT_HTTPS_PORT = 443;
    private final HttpRequest parent;
    protected final Map<String, List<String>> untreatedParams;
    private final HeaderFields untreatedHeaders;
    private List<Cookie> untreatedCookies = null;
    private String remoteUser = null;
    private String[] roles = null;
    private boolean overrideIsUserInRole = false;
    protected static ThreadLocalSimpleDateFormat[] formats = new ThreadLocalSimpleDateFormat[]{new ThreadLocalSimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US), new ThreadLocalSimpleDateFormat("EEEEEE, dd-MMM-yy HH:mm:ss zzz", Locale.US), new ThreadLocalSimpleDateFormat("EEE MMMM d HH:mm:ss yyyy", Locale.US)};

    public DiscFilterRequest(HttpRequest parent) {
        this.parent = parent;
        this.untreatedHeaders = new HeaderFields();
        parent.copyHeaders(this.untreatedHeaders);
        this.untreatedParams = new HashMap<String, List<String>>(parent.parameters());
    }

    public String getMethod() {
        return this.parent.getMethod().name();
    }

    public HttpRequest.Version getVersion() {
        return this.parent.getVersion();
    }

    public URI getUri() {
        return this.parent.getUri();
    }

    public String getRemoteAddr() {
        return this.parent.getRemoteHostAddress();
    }

    public void setRemoteAddr(String remoteIpAddress) {
        InetSocketAddress remoteAddress = new InetSocketAddress(remoteIpAddress, this.getRemotePort());
        this.parent.setRemoteAddress(remoteAddress);
    }

    public String getLocalAddr() {
        InetSocketAddress localAddress = this.localAddress();
        if (localAddress.getAddress() == null) {
            return null;
        }
        return localAddress.getAddress().getHostAddress();
    }

    private InetSocketAddress localAddress() {
        int port = this.parent.getUri().getPort();
        if (port < 0) {
            port = 0;
        }
        return new InetSocketAddress(this.parent.getUri().getHost(), port);
    }

    public Enumeration<String> getAttributeNames() {
        return Collections.enumeration(this.parent.context().keySet());
    }

    public Object getAttribute(String name) {
        return this.parent.context().get(name);
    }

    public void setAttribute(String name, Object value) {
        this.parent.context().put(name, value);
    }

    public boolean containsAttribute(String name) {
        return this.parent.context().containsKey(name);
    }

    public void removeAttribute(String name) {
        this.parent.context().remove(name);
    }

    public String getParameter(String name) {
        if (this.parent.parameters().containsKey(name)) {
            return this.parent.parameters().get(name).get(0);
        }
        return null;
    }

    public Enumeration<String> getParameterNames() {
        return Collections.enumeration(this.parent.parameters().keySet());
    }

    public List<String> getParameterNamesAsList() {
        return new ArrayList<String>(this.parent.parameters().keySet());
    }

    public Enumeration<String> getParameterValues(String name) {
        return Collections.enumeration((Collection)this.parent.parameters().get(name));
    }

    public List<String> getParameterValuesAsList(String name) {
        return this.parent.parameters().get(name);
    }

    public Map<String, List<String>> getParameterMap() {
        return this.parent.parameters();
    }

    public String getRemoteHost() {
        return this.parent.getRemoteHostName();
    }

    public int getLocalPort() {
        return this.localAddress().getPort();
    }

    public int getRemotePort() {
        return this.parent.getRemotePort();
    }

    public Map<String, List<String>> getUntreatedParams() {
        return Collections.unmodifiableMap(this.untreatedParams);
    }

    public HeaderFields getUntreatedHeaders() {
        return this.untreatedHeaders;
    }

    public List<Cookie> getUntreatedCookies() {
        if (this.untreatedCookies == null) {
            this.untreatedCookies = this.parent.decodeCookieHeader();
        }
        return Collections.unmodifiableList(this.untreatedCookies);
    }

    public void addHeader(String name, String value) {
        this.parent.headers().add(name, value);
    }

    public long getDateHeader(String name) {
        String value = this.getHeader(name);
        if (value == null) {
            return -1L;
        }
        Date date = null;
        for (int i = 0; date == null && i < formats.length; ++i) {
            try {
                date = formats[i].parse(value);
                continue;
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        if (date == null) {
            return -1L;
        }
        return date.getTime();
    }

    public String getHeader(String name) {
        List values = this.parent.headers().get((Object)name);
        if (values == null || values.isEmpty()) {
            return null;
        }
        return (String)values.get(values.size() - 1);
    }

    public Enumeration<String> getHeaderNames() {
        return Collections.enumeration(this.parent.headers().keySet());
    }

    public List<String> getHeaderNamesAsList() {
        return new ArrayList<String>(this.parent.headers().keySet());
    }

    public Enumeration<String> getHeaders(String name) {
        return Collections.enumeration(this.getHeadersAsList(name));
    }

    public List<String> getHeadersAsList(String name) {
        List values = this.parent.headers().get((Object)name);
        if (values == null) {
            return Collections.emptyList();
        }
        return this.parent.headers().get((Object)name);
    }

    public void removeHeaders(String name) {
        this.parent.headers().remove((Object)name);
    }

    public void setHeaders(String name, String value) {
        this.parent.headers().put(name, value);
    }

    public void setHeaders(String name, List<String> values) {
        this.parent.headers().put(name, values);
    }

    public int getIntHeader(String name) {
        String value = this.getHeader(name);
        if (value == null) {
            return -1;
        }
        return Integer.parseInt(value);
    }

    public RequestView asRequestView() {
        return new RequestView(){

            @Override
            public HttpRequest.Method method() {
                return HttpRequest.Method.valueOf(DiscFilterRequest.this.getMethod());
            }

            @Override
            public URI uri() {
                return DiscFilterRequest.this.getUri();
            }
        };
    }

    public List<Cookie> getCookies() {
        return this.parent.decodeCookieHeader();
    }

    public void setCookies(List<Cookie> cookies) {
        this.parent.encodeCookieHeader(cookies);
    }

    public long getConnectedAt(TimeUnit unit) {
        return this.parent.getConnectedAt(unit);
    }

    public String getProtocol() {
        return this.getVersion().name();
    }

    public String getQueryString() {
        return this.getUri().getRawQuery();
    }

    public String getRemoteUser() {
        return this.remoteUser;
    }

    public String getRequestURI() {
        return this.getUri().getRawPath();
    }

    public String getRequestedSessionId() {
        return null;
    }

    public String getScheme() {
        return this.getUri().getScheme();
    }

    public String getServerName() {
        return this.getUri().getHost();
    }

    public int getServerPort() {
        int port = this.getUri().getPort();
        if (port == -1) {
            port = this.isSecure() ? 443 : 80;
        }
        return port;
    }

    public Principal getUserPrincipal() {
        return this.parent.getUserPrincipal();
    }

    public boolean isSecure() {
        return this.getScheme().equalsIgnoreCase(HTTPS_PREFIX);
    }

    public boolean isUserInRole(String role) {
        if (this.overrideIsUserInRole) {
            if (this.roles != null) {
                for (String role1 : this.roles) {
                    String userRole;
                    if (role1 == null || role1.trim().length() <= 0 || !(userRole = role1.trim()).equals(role)) continue;
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public void setOverrideIsUserInRole(boolean overrideIsUserInRole) {
        this.overrideIsUserInRole = overrideIsUserInRole;
    }

    public void setRemoteHost(String remoteAddr) {
    }

    public void setRemoteUser(String remoteUser) {
        this.remoteUser = remoteUser;
    }

    public void setUserPrincipal(Principal principal) {
        this.parent.setUserPrincipal(principal);
    }

    public List<X509Certificate> getClientCertificateChain() {
        return Optional.ofNullable(this.parent.context().get("jdisc.request.X509Certificate")).map(X509Certificate[].class::cast).map(Arrays::asList).orElse(Collections.emptyList());
    }

    public void setUserRoles(String[] roles) {
        this.roles = roles;
    }

    public String getContentType() {
        return this.getHeader("Content-Type");
    }

    public String getCharacterEncoding() {
        return this.getCharsetFromContentType(this.getContentType());
    }

    public void setCharacterEncoding(String encoding) {
        String charEncoding = this.setCharsetFromContentType(this.getContentType(), encoding);
        if (charEncoding != null && !charEncoding.isEmpty()) {
            this.removeHeaders("Content-Type");
            this.setHeaders("Content-Type", charEncoding);
        }
    }

    public void addCookie(JDiscCookieWrapper cookie) {
        if (cookie != null) {
            ArrayList<Cookie> cookies = new ArrayList<Cookie>();
            List<Cookie> c = this.getCookies();
            if (c != null && !c.isEmpty()) {
                cookies.addAll(c);
            }
            cookies.add(cookie.getCookie());
            this.setCookies(cookies);
        }
    }

    public void clearCookies() {
        this.parent.headers().remove((Object)"Cookie");
    }

    public JDiscCookieWrapper[] getWrappedCookies() {
        List<Cookie> cookies = this.getCookies();
        if (cookies == null) {
            return null;
        }
        ArrayList<JDiscCookieWrapper> cookieWrapper = new ArrayList<JDiscCookieWrapper>(cookies.size());
        for (Cookie cookie : cookies) {
            cookieWrapper.add(JDiscCookieWrapper.wrap(cookie));
        }
        return cookieWrapper.toArray(new JDiscCookieWrapper[cookieWrapper.size()]);
    }

    private String setCharsetFromContentType(String contentType, String charset) {
        Object newContentType = "";
        if (contentType == null) {
            return null;
        }
        int start = contentType.indexOf("charset=");
        if (start < 0) {
            newContentType = contentType + ";charset=" + charset;
            return newContentType;
        }
        String encoding = contentType.substring(start + 8);
        int end = encoding.indexOf(59);
        if (end >= 0) {
            newContentType = contentType.substring(0, start);
            newContentType = (String)newContentType + "charset=" + charset;
            newContentType = (String)newContentType + encoding.substring(end, encoding.length());
        } else {
            newContentType = contentType.substring(0, start);
            newContentType = (String)newContentType + "charset=" + charset;
        }
        return ((String)newContentType).trim();
    }

    private String getCharsetFromContentType(String contentType) {
        if (contentType == null) {
            return null;
        }
        int start = contentType.indexOf("charset=");
        if (start < 0) {
            return null;
        }
        String encoding = contentType.substring(start + 8);
        int end = encoding.indexOf(59);
        if (end >= 0) {
            encoding = encoding.substring(0, end);
        }
        if ((encoding = encoding.trim()).length() > 2 && encoding.startsWith("\"") && encoding.endsWith("\"")) {
            encoding = encoding.substring(1, encoding.length() - 1);
        }
        return encoding.trim();
    }

    public static boolean isMultipart(DiscFilterRequest request) {
        if (request == null) {
            return false;
        }
        String contentType = request.getContentType();
        if (contentType == null) {
            return false;
        }
        String[] parts = Pattern.compile(";").split(contentType);
        if (parts.length == 0) {
            return false;
        }
        for (String part : parts) {
            if (!"multipart/form-data".equals(part)) continue;
            return true;
        }
        return false;
    }

    protected static final class ThreadLocalSimpleDateFormat
    extends ThreadLocal<SimpleDateFormat> {
        private final String format;
        private final Locale locale;

        public ThreadLocalSimpleDateFormat(String format, Locale locale) {
            this.format = format;
            this.locale = locale;
        }

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat(this.format, this.locale);
        }

        public Date parse(String value) throws ParseException {
            return ((SimpleDateFormat)this.get()).parse(value);
        }
    }
}

