/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.processing.response;

import com.yahoo.processing.impl.ProcessingFuture;
import com.yahoo.processing.response.Data;
import com.yahoo.processing.response.DataList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public interface IncomingData<DATATYPE extends Data> {
    public DataList<DATATYPE> getOwner();

    public CompletableFuture<DataList<DATATYPE>> completedFuture();

    public boolean isComplete();

    public void addLast(DATATYPE var1);

    public void add(DATATYPE var1);

    public void addLast(List<DATATYPE> var1);

    public void add(List<DATATYPE> var1);

    public void markComplete();

    public List<DATATYPE> drain();

    public void addNewDataListener(Runnable var1, Executor var2);

    public static final class NullIncomingData<DATATYPE extends Data>
    implements IncomingData<DATATYPE> {
        private final DataList<DATATYPE> owner;
        private final ImmediateFuture<DATATYPE> completionFuture;

        public NullIncomingData(DataList<DATATYPE> owner) {
            this.owner = owner;
            this.completionFuture = new ImmediateFuture<DATATYPE>(owner);
        }

        @Override
        public CompletableFuture<DataList<DATATYPE>> completedFuture() {
            return this.completionFuture;
        }

        @Override
        public DataList<DATATYPE> getOwner() {
            return this.owner;
        }

        @Override
        public boolean isComplete() {
            return true;
        }

        @Override
        public void addLast(DATATYPE data) {
            throw new IllegalStateException(this.owner + " does not support adding data asynchronously");
        }

        @Override
        public void add(DATATYPE data) {
            throw new IllegalStateException(this.owner + " does not support adding data asynchronously");
        }

        @Override
        public void addLast(List<DATATYPE> data) {
            throw new IllegalStateException(this.owner + " does not support adding data asynchronously");
        }

        @Override
        public void add(List<DATATYPE> data) {
            throw new IllegalStateException(this.owner + " does not support adding data asynchronously");
        }

        @Override
        public void markComplete() {
        }

        @Override
        public List<DATATYPE> drain() {
            return Collections.emptyList();
        }

        @Override
        public void addNewDataListener(Runnable listener, Executor executor) {
        }

        public String toString() {
            return "(no incoming)";
        }

        public static class ImmediateFuture<DATATYPE extends Data>
        extends ProcessingFuture<DataList<DATATYPE>> {
            private final DataList<DATATYPE> owner;

            public ImmediateFuture(DataList<DATATYPE> owner) {
                this.owner = owner;
                this.complete(owner);
            }

            @Override
            public boolean cancel(boolean b) {
                return false;
            }

            @Override
            public boolean isCancelled() {
                return false;
            }

            @Override
            public boolean isDone() {
                return true;
            }

            @Override
            public DataList<DATATYPE> get() {
                return this.owner;
            }

            @Override
            public DataList<DATATYPE> get(long l, TimeUnit timeUnit) {
                return this.owner;
            }
        }
    }
}

