/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.logging;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.yahoo.container.logging.ConnectionLogEntry;
import com.yahoo.container.logging.FormatUtil;
import com.yahoo.container.logging.LogWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

class JsonConnectionLogWriter
implements LogWriter<ConnectionLogEntry> {
    private final JsonFactory jsonFactory = new JsonFactory((ObjectCodec)new ObjectMapper());

    JsonConnectionLogWriter() {
    }

    @Override
    public void write(ConnectionLogEntry record, OutputStream outputStream) throws IOException {
        try (JsonGenerator generator = this.createJsonGenerator(outputStream);){
            generator.writeStartObject();
            generator.writeStringField("id", record.id());
            generator.writeStringField("timestamp", record.timestamp().toString());
            this.writeOptionalSeconds(generator, "duration", JsonConnectionLogWriter.unwrap(record.durationSeconds()));
            this.writeOptionalString(generator, "peerAddress", JsonConnectionLogWriter.unwrap(record.peerAddress()));
            this.writeOptionalInteger(generator, "peerPort", JsonConnectionLogWriter.unwrap(record.peerPort()));
            this.writeOptionalString(generator, "localAddress", JsonConnectionLogWriter.unwrap(record.localAddress()));
            this.writeOptionalInteger(generator, "localPort", JsonConnectionLogWriter.unwrap(record.localPort()));
            String proxyProtocolVersion = JsonConnectionLogWriter.unwrap(record.proxyProtocolVersion());
            String proxyProtocolRemoteAddress = JsonConnectionLogWriter.unwrap(record.remoteAddress());
            Integer proxyProtocolRemotePort = JsonConnectionLogWriter.unwrap(record.remotePort());
            if (JsonConnectionLogWriter.isAnyValuePresent(proxyProtocolVersion, proxyProtocolRemoteAddress, proxyProtocolRemotePort)) {
                generator.writeObjectFieldStart("proxyProtocol");
                this.writeOptionalString(generator, "version", proxyProtocolVersion);
                this.writeOptionalString(generator, "remoteAddress", proxyProtocolRemoteAddress);
                this.writeOptionalInteger(generator, "remotePort", proxyProtocolRemotePort);
                generator.writeEndObject();
            }
            String httpVersion = JsonConnectionLogWriter.unwrap(record.httpProtocol());
            Long httpBytesReceived = JsonConnectionLogWriter.unwrap(record.httpBytesReceived());
            Long httpBytesSent = JsonConnectionLogWriter.unwrap(record.httpBytesSent());
            Long httpRequests = JsonConnectionLogWriter.unwrap(record.requests());
            Long httpResponses = JsonConnectionLogWriter.unwrap(record.responses());
            if (JsonConnectionLogWriter.isAnyValuePresent(httpVersion, httpBytesReceived, httpBytesSent, httpRequests, httpResponses)) {
                generator.writeObjectFieldStart("http");
                this.writeOptionalString(generator, "version", httpVersion);
                this.writeOptionalLong(generator, "bytesReceived", httpBytesReceived);
                this.writeOptionalLong(generator, "responses", httpResponses);
                this.writeOptionalLong(generator, "bytesSent", httpBytesSent);
                this.writeOptionalLong(generator, "requests", httpRequests);
                generator.writeEndObject();
            }
            String sslProtocol = JsonConnectionLogWriter.unwrap(record.sslProtocol());
            String sslSessionId = JsonConnectionLogWriter.unwrap(record.sslSessionId());
            String sslCipherSuite = JsonConnectionLogWriter.unwrap(record.sslCipherSuite());
            String sslPeerSubject = JsonConnectionLogWriter.unwrap(record.sslPeerSubject());
            Instant sslPeerNotBefore = JsonConnectionLogWriter.unwrap(record.sslPeerNotBefore());
            Instant sslPeerNotAfter = JsonConnectionLogWriter.unwrap(record.sslPeerNotAfter());
            String sslSniServerName = JsonConnectionLogWriter.unwrap(record.sslSniServerName());
            String sslPeerIssuerSubject = JsonConnectionLogWriter.unwrap(record.sslPeerIssuerSubject());
            String sslPeerFingerprint = JsonConnectionLogWriter.unwrap(record.sslPeerFingerprint());
            Long sslBytesReceived = JsonConnectionLogWriter.unwrap(record.sslBytesReceived());
            Long sslBytesSent = JsonConnectionLogWriter.unwrap(record.sslBytesSent());
            ConnectionLogEntry.SslHandshakeFailure sslHandshakeFailure = JsonConnectionLogWriter.unwrap(record.sslHandshakeFailure());
            List<String> sslSubjectAlternativeNames = record.sslSubjectAlternativeNames();
            if (JsonConnectionLogWriter.isAnyValuePresent(sslProtocol, sslSessionId, sslCipherSuite, sslPeerSubject, sslPeerNotBefore, sslPeerNotAfter, sslSniServerName, sslHandshakeFailure, sslPeerIssuerSubject, sslPeerFingerprint, sslBytesReceived, sslBytesSent)) {
                generator.writeObjectFieldStart("ssl");
                this.writeOptionalString(generator, "protocol", sslProtocol);
                this.writeOptionalString(generator, "sessionId", sslSessionId);
                this.writeOptionalString(generator, "cipherSuite", sslCipherSuite);
                this.writeOptionalString(generator, "peerSubject", sslPeerSubject);
                this.writeOptionalString(generator, "peerIssuerSubject", sslPeerIssuerSubject);
                this.writeOptionalTimestamp(generator, "peerNotBefore", sslPeerNotBefore);
                this.writeOptionalTimestamp(generator, "peerNotAfter", sslPeerNotAfter);
                this.writeOptionalString(generator, "peerFingerprint", sslPeerFingerprint);
                this.writeOptionalString(generator, "sniServerName", sslSniServerName);
                this.writeOptionalLong(generator, "bytesReceived", sslBytesReceived);
                this.writeOptionalLong(generator, "bytesSent", sslBytesSent);
                if (sslHandshakeFailure != null) {
                    generator.writeObjectFieldStart("handshake-failure");
                    generator.writeArrayFieldStart("exception");
                    for (ConnectionLogEntry.SslHandshakeFailure.ExceptionEntry entry : sslHandshakeFailure.exceptionChain()) {
                        generator.writeStartObject();
                        generator.writeStringField("cause", entry.name());
                        generator.writeStringField("message", entry.message());
                        generator.writeEndObject();
                    }
                    generator.writeEndArray();
                    generator.writeStringField("type", sslHandshakeFailure.type());
                    generator.writeEndObject();
                }
                if (!sslSubjectAlternativeNames.isEmpty()) {
                    generator.writeArrayFieldStart("san");
                    for (String sanEntry : sslSubjectAlternativeNames) {
                        generator.writeString(sanEntry);
                    }
                    generator.writeEndArray();
                }
                generator.writeEndObject();
            }
        }
    }

    private void writeOptionalString(JsonGenerator generator, String name, String value) throws IOException {
        if (value != null) {
            generator.writeStringField(name, value);
        }
    }

    private void writeOptionalInteger(JsonGenerator generator, String name, Integer value) throws IOException {
        if (value != null) {
            generator.writeNumberField(name, value.intValue());
        }
    }

    private void writeOptionalLong(JsonGenerator generator, String name, Long value) throws IOException {
        if (value != null) {
            generator.writeNumberField(name, value.longValue());
        }
    }

    private void writeOptionalTimestamp(JsonGenerator generator, String name, Instant value) throws IOException {
        if (value != null) {
            generator.writeStringField(name, value.toString());
        }
    }

    private void writeOptionalSeconds(JsonGenerator generator, String name, Double value) throws IOException {
        if (value != null) {
            FormatUtil.writeSecondsField(generator, name, value);
        }
    }

    private static boolean isAnyValuePresent(Object ... values) {
        return Arrays.stream(values).anyMatch(Objects::nonNull);
    }

    private static <T> T unwrap(Optional<T> maybeValue) {
        return maybeValue.orElse(null);
    }

    private JsonGenerator createJsonGenerator(OutputStream outputStream) throws IOException {
        return this.jsonFactory.createGenerator(outputStream, JsonEncoding.UTF8).configure(JsonGenerator.Feature.AUTO_CLOSE_TARGET, false).configure(JsonGenerator.Feature.FLUSH_PASSED_TO_STREAM, false);
    }
}

