/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jdisc.http.filter.chain;

import com.yahoo.jdisc.AbstractResource;
import com.yahoo.jdisc.Request;
import com.yahoo.jdisc.Response;
import com.yahoo.jdisc.SharedResource;
import com.yahoo.jdisc.application.ResourcePool;
import com.yahoo.jdisc.http.filter.ResponseFilter;
import com.yahoo.jdisc.http.filter.chain.EmptyResponseFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class ResponseFilterChain
extends AbstractResource
implements ResponseFilter {
    private final List<ResponseFilter> filters = new ArrayList<ResponseFilter>();
    private final ResourcePool filterReferences = new ResourcePool();

    private ResponseFilterChain(Iterable<? extends ResponseFilter> filters) {
        for (ResponseFilter responseFilter : filters) {
            this.filters.add(responseFilter);
            this.filterReferences.retain((SharedResource)responseFilter);
        }
    }

    @Override
    public void filter(Response response, Request request) {
        for (ResponseFilter filter : this.filters) {
            filter.filter(response, request);
        }
    }

    protected void destroy() {
        this.filterReferences.release();
    }

    public static ResponseFilter newInstance(ResponseFilter ... filters) {
        return ResponseFilterChain.newInstance(Arrays.asList(filters));
    }

    public static ResponseFilter newInstance(List<? extends ResponseFilter> filters) {
        if (filters.size() == 0) {
            return EmptyResponseFilter.INSTANCE;
        }
        if (filters.size() == 1) {
            return filters.get(0);
        }
        return new ResponseFilterChain(filters);
    }
}

