/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.jdisc.state;

import com.yahoo.container.jdisc.state.CountMetric;
import com.yahoo.container.jdisc.state.GaugeMetric;
import com.yahoo.container.jdisc.state.JsonUtil;
import com.yahoo.container.jdisc.state.MetricDimensions;
import com.yahoo.container.jdisc.state.MetricSet;
import com.yahoo.container.jdisc.state.MetricSnapshot;
import com.yahoo.container.jdisc.state.MetricValue;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;

public class PrometheusHelper {
    private static final String HELP_LINE = "# HELP %s \n# TYPE %s untyped\n";
    private static final String METRIC_LINE = "%s{%s} %s %d\n";

    protected static byte[] buildPrometheusOutput(MetricSnapshot metricSnapshot, String application, long timestamp) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        for (Map.Entry<MetricDimensions, MetricSet> snapshotEntry : metricSnapshot) {
            MetricDimensions metricDimensions = snapshotEntry.getKey();
            MetricSet metricSet = snapshotEntry.getValue();
            StringBuilder dimensionBuilder = new StringBuilder();
            for (Map.Entry dimension : metricDimensions) {
                dimensionBuilder.append(PrometheusHelper.sanitize((String)dimension.getKey())).append("=\"").append((String)dimension.getValue()).append("\",");
            }
            dimensionBuilder.append("vespa_service=\"").append(application).append("\",");
            String dimensions = dimensionBuilder.toString();
            for (Map.Entry<String, MetricValue> metric : metricSet) {
                String metricName = metric.getKey();
                MetricValue metricValue = metric.getValue();
                if (metricValue instanceof CountMetric) {
                    String sanitizedMetricName = PrometheusHelper.getSanitizedMetricName(metricName, "count");
                    long value = ((CountMetric)metricValue).getCount();
                    outputStream.write(PrometheusHelper.getMetricLines(sanitizedMetricName, dimensions, value, timestamp));
                    continue;
                }
                if (!(metricValue instanceof GaugeMetric)) continue;
                GaugeMetric gauge = (GaugeMetric)metricValue;
                PrometheusHelper.writeGaugeMetrics(outputStream, metricName, gauge, dimensions, timestamp);
            }
        }
        return outputStream.toByteArray();
    }

    private static void writeGaugeMetrics(OutputStream outputStream, String metricName, GaugeMetric gaugeMetric, String dimensions, long timestamp) throws IOException {
        String sanitizedMetricName = PrometheusHelper.getSanitizedMetricName(metricName, "last");
        double value = JsonUtil.sanitizeDouble(gaugeMetric.getLast());
        outputStream.write(PrometheusHelper.getMetricLines(sanitizedMetricName, dimensions, value, timestamp));
    }

    private static byte[] getMetricLines(String metricName, String dimensions, Number value, long timestamp) {
        return (String.format(HELP_LINE, metricName, metricName) + String.format(METRIC_LINE, metricName, dimensions, value, timestamp)).getBytes();
    }

    private static String getSanitizedMetricName(String metricName, String suffix) {
        return PrometheusHelper.sanitize(metricName) + "_" + suffix;
    }

    private static String sanitize(String name) {
        return name.replaceAll("([-.])", "_");
    }
}

