/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jdisc.http.server.jetty;

import com.google.common.base.Objects;
import com.yahoo.container.logging.AccessLogEntry;
import com.yahoo.container.logging.RequestLogEntry;
import com.yahoo.jdisc.http.HttpRequest;
import com.yahoo.jdisc.http.ServerConfig;
import com.yahoo.jdisc.http.server.jetty.JDiscHttpServlet;
import com.yahoo.jdisc.http.server.jetty.RequestUtils;
import jakarta.servlet.http.HttpServletRequest;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jetty.http2.HTTP2Stream;
import org.eclipse.jetty.http2.server.HttpTransportOverHTTP2;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.HttpTransport;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.component.AbstractLifeCycle;

class AccessLogRequestLog
extends AbstractLifeCycle
implements RequestLog {
    private static final Logger logger = Logger.getLogger(AccessLogRequestLog.class.getName());
    private static final List<String> LOGGED_REQUEST_HEADERS = List.of("Vespa-Client-Version");
    private final com.yahoo.container.logging.RequestLog requestLog;
    private final List<String> remoteAddressHeaders;
    private final List<String> remotePortHeaders;

    AccessLogRequestLog(com.yahoo.container.logging.RequestLog requestLog, ServerConfig.AccessLog config) {
        this.requestLog = requestLog;
        this.remoteAddressHeaders = config.remoteAddressHeaders();
        this.remotePortHeaders = config.remotePortHeaders();
    }

    public void log(Request request, Response response) {
        try {
            AccessLogEntry accessLogEntry;
            int remotePort;
            RequestLogEntry.Builder builder = new RequestLogEntry.Builder();
            String peerAddress = request.getRemoteAddr();
            int peerPort = request.getRemotePort();
            long startTime = request.getTimeStamp();
            long endTime = System.currentTimeMillis();
            builder.peerAddress(peerAddress).peerPort(peerPort).localPort(AccessLogRequestLog.getLocalPort(request)).timestamp(Instant.ofEpochMilli(startTime)).duration(Duration.ofMillis(Math.max(0L, endTime - startTime))).responseSize(response.getHttpChannel().getBytesWritten()).requestSize(request.getHttpInput().getContentReceived()).statusCode(response.getCommittedMetaData().getStatus());
            AccessLogRequestLog.addNonNullValue(builder, request.getMethod(), RequestLogEntry.Builder::httpMethod);
            AccessLogRequestLog.addNonNullValue(builder, request.getRequestURI(), RequestLogEntry.Builder::rawPath);
            AccessLogRequestLog.addNonNullValue(builder, request.getProtocol(), RequestLogEntry.Builder::httpVersion);
            AccessLogRequestLog.addNonNullValue(builder, request.getScheme(), RequestLogEntry.Builder::scheme);
            AccessLogRequestLog.addNonNullValue(builder, request.getHeader("User-Agent"), RequestLogEntry.Builder::userAgent);
            AccessLogRequestLog.addNonNullValue(builder, AccessLogRequestLog.getServerName(request), RequestLogEntry.Builder::hostString);
            AccessLogRequestLog.addNonNullValue(builder, request.getHeader("Referer"), RequestLogEntry.Builder::referer);
            AccessLogRequestLog.addNonNullValue(builder, request.getQueryString(), RequestLogEntry.Builder::rawQuery);
            HttpRequest jdiscRequest = (HttpRequest)((Object)request.getAttribute(HttpRequest.class.getName()));
            if (jdiscRequest != null) {
                AccessLogRequestLog.addNonNullValue(builder, jdiscRequest.getUserPrincipal(), RequestLogEntry.Builder::userPrincipal);
            }
            String requestFilterId = (String)request.getAttribute("jdisc.request.chain");
            AccessLogRequestLog.addNonNullValue(builder, requestFilterId, (b, chain) -> b.addExtraAttribute("request-chain", (String)chain));
            String responseFilterId = (String)request.getAttribute("jdisc.response.chain");
            AccessLogRequestLog.addNonNullValue(builder, responseFilterId, (b, chain) -> b.addExtraAttribute("response-chain", (String)chain));
            UUID connectionId = (UUID)request.getAttribute("jdisc.request.connection.id");
            AccessLogRequestLog.addNonNullValue(builder, connectionId, (b, uuid) -> b.connectionId(uuid.toString()));
            String remoteAddress = this.getRemoteAddress((HttpServletRequest)request);
            if (!Objects.equal((Object)remoteAddress, (Object)peerAddress)) {
                builder.remoteAddress(remoteAddress);
            }
            if ((remotePort = this.getRemotePort((HttpServletRequest)request)) != peerPort) {
                builder.remotePort(remotePort);
            }
            LOGGED_REQUEST_HEADERS.forEach(header -> {
                String value = request.getHeader(header);
                if (value != null) {
                    builder.addExtraAttribute((String)header, value);
                }
            });
            X509Certificate[] clientCert = (X509Certificate[])request.getAttribute("jakarta.servlet.request.X509Certificate");
            if (clientCert != null && clientCert.length > 0) {
                builder.sslPrincipal(clientCert[0].getSubjectX500Principal());
            }
            if ((accessLogEntry = (AccessLogEntry)request.getAttribute(JDiscHttpServlet.ATTRIBUTE_NAME_ACCESS_LOG_ENTRY)) != null) {
                Map<String, List<String>> extraAttributes = accessLogEntry.getKeyValues();
                if (extraAttributes != null) {
                    extraAttributes.forEach(builder::addExtraAttributes);
                }
                AccessLogRequestLog.addNonNullValue(builder, accessLogEntry.getHitCounts(), RequestLogEntry.Builder::hitCounts);
                AccessLogRequestLog.addNonNullValue(builder, accessLogEntry.getTrace(), RequestLogEntry.Builder::traceNode);
            }
            AccessLogRequestLog.http2StreamId(request).ifPresent(streamId -> builder.addExtraAttribute("http2-stream-id", Integer.toString(streamId)));
            this.requestLog.log(builder.build());
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to log access log entry: " + e.getMessage(), e);
        }
    }

    private static String getServerName(Request request) {
        try {
            return request.getServerName();
        }
        catch (IllegalArgumentException e) {
            logger.log(Level.FINE, e, () -> "Fallback to 'Host' header");
            return request.getHeader("Host");
        }
    }

    private String getRemoteAddress(HttpServletRequest request) {
        for (String header : this.remoteAddressHeaders) {
            String value = request.getHeader(header);
            if (value == null) continue;
            return value;
        }
        return request.getRemoteAddr();
    }

    private int getRemotePort(HttpServletRequest request) {
        for (String header : this.remotePortHeaders) {
            OptionalInt maybePort;
            String value = request.getHeader(header);
            if (value == null || !(maybePort = AccessLogRequestLog.parsePort(value)).isPresent()) continue;
            return maybePort.getAsInt();
        }
        return request.getRemotePort();
    }

    private static int getLocalPort(Request request) {
        int connectorLocalPort = RequestUtils.getConnectorLocalPort(request);
        if (connectorLocalPort <= 0) {
            return request.getLocalPort();
        }
        return connectorLocalPort;
    }

    private static OptionalInt parsePort(String port) {
        try {
            return OptionalInt.of(Integer.parseInt(port));
        }
        catch (IllegalArgumentException e) {
            return OptionalInt.empty();
        }
    }

    private static OptionalInt http2StreamId(Request request) {
        HttpChannel httpChannel = request.getHttpChannel();
        if (httpChannel == null) {
            return OptionalInt.empty();
        }
        HttpTransport transport = httpChannel.getHttpTransport();
        if (!(transport instanceof HttpTransportOverHTTP2)) {
            return OptionalInt.empty();
        }
        HTTP2Stream stream = (HTTP2Stream)((HttpTransportOverHTTP2)transport).getStream();
        return OptionalInt.of(stream.getId());
    }

    private static <T> void addNonNullValue(RequestLogEntry.Builder builder, T value, BiConsumer<RequestLogEntry.Builder, T> setter) {
        if (value != null) {
            setter.accept(builder, (RequestLogEntry.Builder)value);
        }
    }
}

