/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.core.documentapi;

import com.yahoo.document.config.DocumentmanagerConfig;
import com.yahoo.document.select.parser.ParseException;
import com.yahoo.documentapi.AsyncParameters;
import com.yahoo.documentapi.AsyncSession;
import com.yahoo.documentapi.DocumentAccess;
import com.yahoo.documentapi.DocumentAccessParams;
import com.yahoo.documentapi.SubscriptionParameters;
import com.yahoo.documentapi.SubscriptionSession;
import com.yahoo.documentapi.SyncParameters;
import com.yahoo.documentapi.SyncSession;
import com.yahoo.documentapi.VisitorDestinationParameters;
import com.yahoo.documentapi.VisitorDestinationSession;
import com.yahoo.documentapi.VisitorParameters;
import com.yahoo.documentapi.VisitorSession;
import com.yahoo.documentapi.messagebus.MessageBusDocumentAccess;
import com.yahoo.documentapi.messagebus.MessageBusParams;
import com.yahoo.documentapi.messagebus.protocol.DocumentProtocolPoliciesConfig;
import com.yahoo.messagebus.MessagebusConfig;
import com.yahoo.vespa.config.content.DistributionConfig;
import com.yahoo.yolean.concurrent.Memoized;
import java.util.logging.Level;
import java.util.logging.Logger;

public class VespaDocumentAccess
extends DocumentAccess {
    private static final Logger log = Logger.getLogger(VespaDocumentAccess.class.getName());
    private final MessageBusParams parameters;
    private final Memoized<DocumentAccess, RuntimeException> delegate;

    VespaDocumentAccess(DocumentmanagerConfig documentmanagerConfig, String slobroksConfigId, MessagebusConfig messagebusConfig, DocumentProtocolPoliciesConfig policiesConfig, DistributionConfig distributionConfig) {
        super(new DocumentAccessParams().setDocumentmanagerConfig(documentmanagerConfig));
        this.parameters = new MessageBusParams().setDocumentProtocolPoliciesConfig(policiesConfig, distributionConfig);
        this.parameters.setDocumentmanagerConfig(documentmanagerConfig);
        this.parameters.getRPCNetworkParams().setSlobrokConfigId(slobroksConfigId);
        this.parameters.getMessageBusParams().setMessageBusConfig(messagebusConfig);
        this.delegate = new Memoized(() -> new MessageBusDocumentAccess(this.parameters), DocumentAccess::shutdown);
    }

    public DocumentAccess delegate() {
        return (DocumentAccess)this.delegate.get();
    }

    public void shutdown() {
        log.log(Level.WARNING, "This injected document access should only be shut down by the container", new IllegalStateException());
    }

    void protectedShutdown() {
        this.delegate.close();
    }

    public SyncSession createSyncSession(SyncParameters parameters) {
        return this.delegate().createSyncSession(parameters);
    }

    public AsyncSession createAsyncSession(AsyncParameters parameters) {
        return this.delegate().createAsyncSession(parameters);
    }

    public VisitorSession createVisitorSession(VisitorParameters parameters) throws ParseException {
        return this.delegate().createVisitorSession(parameters);
    }

    public VisitorDestinationSession createVisitorDestinationSession(VisitorDestinationParameters parameters) {
        return this.delegate().createVisitorDestinationSession(parameters);
    }

    public SubscriptionSession createSubscription(SubscriptionParameters parameters) {
        return this.delegate().createSubscription(parameters);
    }

    public SubscriptionSession openSubscription(SubscriptionParameters parameters) {
        return this.delegate().openSubscription(parameters);
    }
}

