/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jdisc.http.server.jetty;

import com.yahoo.jdisc.Metric;
import com.yahoo.jdisc.http.server.jetty.MetricDefinitions;
import com.yahoo.jdisc.http.server.jetty.SslHandshakeFailure;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLHandshakeException;
import org.eclipse.jetty.io.ssl.SslHandshakeListener;

class SslHandshakeFailedListener
implements SslHandshakeListener {
    private static final Logger log = Logger.getLogger(SslHandshakeFailedListener.class.getName());
    private final Metric metric;
    private final String connectorName;
    private final int listenPort;

    SslHandshakeFailedListener(Metric metric, String connectorName, int listenPort) {
        this.metric = metric;
        this.connectorName = connectorName;
        this.listenPort = listenPort;
    }

    public void handshakeFailed(SslHandshakeListener.Event event, Throwable throwable) {
        log.log(Level.FINE, throwable, () -> "Ssl handshake failed: " + throwable.getMessage());
        String metricName = SslHandshakeFailure.fromSslHandshakeException((SSLHandshakeException)throwable).map(SslHandshakeFailure::metricName).orElse(MetricDefinitions.SSL_HANDSHAKE_FAILURE_UNKNOWN);
        this.metric.add(metricName, (Number)1L, this.metric.createContext(this.createDimensions(event)));
    }

    private Map<String, Object> createDimensions(SslHandshakeListener.Event event) {
        HashMap<String, Object> dimensions = new HashMap<String, Object>();
        dimensions.put("serverName", this.connectorName);
        dimensions.put("serverPort", this.listenPort);
        Optional.ofNullable(event.getSSLEngine().getPeerHost()).ifPresent(clientIp -> dimensions.put("clientIp", clientIp));
        return Map.copyOf(dimensions);
    }
}

