/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jdisc.http.server.jetty;

import com.yahoo.concurrent.DaemonThreadFactory;
import com.yahoo.jdisc.Metric;
import com.yahoo.jdisc.http.server.jetty.HttpResponseStatisticsCollector;
import com.yahoo.jdisc.http.server.jetty.JDiscServerConnector;
import java.time.Instant;
import java.util.HashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.io.ConnectionStatistics;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.AbstractHandlerContainer;
import org.eclipse.jetty.server.handler.StatisticsHandler;
import org.eclipse.jetty.util.thread.QueuedThreadPool;

class ServerMetricReporter {
    private final ScheduledExecutorService executor = Executors.newScheduledThreadPool(1, (ThreadFactory)new DaemonThreadFactory("jdisc-jetty-metric-reporter-"));
    private final Metric metric;
    private final Server jetty;

    ServerMetricReporter(Metric metric, Server jetty) {
        this.metric = metric;
        this.jetty = jetty;
    }

    void start() {
        this.executor.scheduleAtFixedRate(new ReporterTask(), 0L, 2L, TimeUnit.SECONDS);
    }

    void shutdown() {
        try {
            this.executor.shutdownNow();
            this.executor.awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private class ReporterTask
    implements Runnable {
        private final Instant timeStarted = Instant.now();

        private ReporterTask() {
        }

        @Override
        public void run() {
            StatisticsHandler statisticsHandler;
            HttpResponseStatisticsCollector statisticsCollector = (HttpResponseStatisticsCollector)((AbstractHandlerContainer)ServerMetricReporter.this.jetty.getHandler()).getChildHandlerByClass(HttpResponseStatisticsCollector.class);
            if (statisticsCollector != null) {
                this.setServerMetrics(statisticsCollector);
            }
            if ((statisticsHandler = (StatisticsHandler)((AbstractHandlerContainer)ServerMetricReporter.this.jetty.getHandler()).getChildHandlerByClass(StatisticsHandler.class)) != null) {
                statisticsHandler.statsReset();
            }
            for (Connector connector : ServerMetricReporter.this.jetty.getConnectors()) {
                this.setConnectorMetrics((JDiscServerConnector)connector);
            }
            this.setJettyThreadpoolMetrics();
        }

        private void setServerMetrics(HttpResponseStatisticsCollector statisticsCollector) {
            long timeSinceStarted = System.currentTimeMillis() - this.timeStarted.toEpochMilli();
            ServerMetricReporter.this.metric.set("serverStartedMillis", (Number)timeSinceStarted, null);
            this.addResponseMetrics(statisticsCollector);
        }

        private void addResponseMetrics(HttpResponseStatisticsCollector statisticsCollector) {
            for (HttpResponseStatisticsCollector.StatisticsEntry metricEntry : statisticsCollector.takeStatistics()) {
                HashMap<String, String> dimensions = new HashMap<String, String>();
                dimensions.put("httpMethod", metricEntry.method);
                dimensions.put("scheme", metricEntry.scheme);
                dimensions.put("requestType", metricEntry.requestType);
                dimensions.put("protocol", metricEntry.protocol);
                ServerMetricReporter.this.metric.add(metricEntry.name, (Number)metricEntry.value, ServerMetricReporter.this.metric.createContext(dimensions));
            }
        }

        private void setJettyThreadpoolMetrics() {
            QueuedThreadPool threadpool = (QueuedThreadPool)ServerMetricReporter.this.jetty.getThreadPool();
            ServerMetricReporter.this.metric.set("jdisc.http.jetty.threadpool.thread.max", (Number)threadpool.getMaxThreads(), null);
            ServerMetricReporter.this.metric.set("jdisc.http.jetty.threadpool.thread.min", (Number)threadpool.getMinThreads(), null);
            ServerMetricReporter.this.metric.set("jdisc.http.jetty.threadpool.thread.reserved", (Number)threadpool.getReservedThreads(), null);
            ServerMetricReporter.this.metric.set("jdisc.http.jetty.threadpool.thread.busy", (Number)threadpool.getBusyThreads(), null);
            ServerMetricReporter.this.metric.set("jdisc.http.jetty.threadpool.thread.idle", (Number)threadpool.getIdleThreads(), null);
            ServerMetricReporter.this.metric.set("jdisc.http.jetty.threadpool.thread.total", (Number)threadpool.getThreads(), null);
            ServerMetricReporter.this.metric.set("jdisc.http.jetty.threadpool.queue.size", (Number)threadpool.getQueueSize(), null);
        }

        private void setConnectorMetrics(JDiscServerConnector connector) {
            ConnectionStatistics statistics = connector.getStatistics();
            ServerMetricReporter.this.metric.set("serverNumConnections", (Number)statistics.getConnectionsTotal(), connector.getConnectorMetricContext());
            ServerMetricReporter.this.metric.set("serverNumOpenConnections", (Number)statistics.getConnections(), connector.getConnectorMetricContext());
            ServerMetricReporter.this.metric.set("serverConnectionsOpenMax", (Number)statistics.getConnectionsMax(), connector.getConnectorMetricContext());
            ServerMetricReporter.this.metric.set("serverConnectionDurationMax", (Number)statistics.getConnectionDurationMax(), connector.getConnectorMetricContext());
            ServerMetricReporter.this.metric.set("serverConnectionDurationMean", (Number)statistics.getConnectionDurationMean(), connector.getConnectorMetricContext());
            ServerMetricReporter.this.metric.set("serverConnectionDurationStdDev", (Number)statistics.getConnectionDurationStdDev(), connector.getConnectorMetricContext());
        }
    }
}

