/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.logging;

import com.yahoo.container.core.AccessLogConfig;
import com.yahoo.container.logging.LogFileHandler;
import com.yahoo.container.logging.LogWriter;
import com.yahoo.container.logging.RequestLogEntry;

class AccessLogHandler {
    private final LogFileHandler<RequestLogEntry> logFileHandler;

    AccessLogHandler(AccessLogConfig.FileHandler config, LogWriter<RequestLogEntry> logWriter) {
        this.logFileHandler = new LogFileHandler<RequestLogEntry>(this.toCompression(config), config.bufferSize(), config.pattern(), config.rotation(), config.symlink(), config.queueSize(), "request-logger", logWriter);
    }

    public void log(RequestLogEntry entry) {
        this.logFileHandler.publish(entry);
    }

    private LogFileHandler.Compression toCompression(AccessLogConfig.FileHandler config) {
        if (!config.compressOnRotation()) {
            return LogFileHandler.Compression.NONE;
        }
        switch (config.compressionFormat()) {
            case ZSTD: {
                return LogFileHandler.Compression.ZSTD;
            }
            case GZIP: {
                return LogFileHandler.Compression.GZIP;
            }
        }
        throw new IllegalArgumentException(config.compressionFormat().toString());
    }

    void shutdown() {
        this.logFileHandler.close();
        this.logFileHandler.shutdown();
    }
}

