/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.core.documentapi;

import com.yahoo.document.config.DocumentmanagerConfig;
import com.yahoo.document.select.parser.ParseException;
import com.yahoo.documentapi.AsyncParameters;
import com.yahoo.documentapi.AsyncSession;
import com.yahoo.documentapi.DocumentAccess;
import com.yahoo.documentapi.DocumentAccessParams;
import com.yahoo.documentapi.SubscriptionParameters;
import com.yahoo.documentapi.SubscriptionSession;
import com.yahoo.documentapi.SyncParameters;
import com.yahoo.documentapi.SyncSession;
import com.yahoo.documentapi.VisitorDestinationParameters;
import com.yahoo.documentapi.VisitorDestinationSession;
import com.yahoo.documentapi.VisitorParameters;
import com.yahoo.documentapi.VisitorSession;
import com.yahoo.documentapi.messagebus.MessageBusDocumentAccess;
import com.yahoo.documentapi.messagebus.MessageBusParams;
import com.yahoo.documentapi.messagebus.loadtypes.LoadTypeSet;
import com.yahoo.documentapi.messagebus.protocol.DocumentProtocolPoliciesConfig;
import com.yahoo.messagebus.MessagebusConfig;
import com.yahoo.vespa.config.content.DistributionConfig;
import com.yahoo.vespa.config.content.LoadTypeConfig;
import java.util.concurrent.atomic.AtomicReference;

public class VespaDocumentAccess
extends DocumentAccess {
    private final MessageBusParams parameters;
    private final AtomicReference<DocumentAccess> delegate = new AtomicReference();
    private boolean shutDown = false;

    VespaDocumentAccess(DocumentmanagerConfig documentmanagerConfig, LoadTypeConfig loadTypeConfig, String slobroksConfigId, MessagebusConfig messagebusConfig, DocumentProtocolPoliciesConfig policiesConfig, DistributionConfig distributionConfig) {
        super(new DocumentAccessParams().setDocumentmanagerConfig(documentmanagerConfig));
        this.parameters = new MessageBusParams(new LoadTypeSet(loadTypeConfig)).setDocumentProtocolPoliciesConfig(policiesConfig, distributionConfig);
        this.parameters.setDocumentmanagerConfig(documentmanagerConfig);
        this.parameters.getRPCNetworkParams().setSlobrokConfigId(slobroksConfigId);
        this.parameters.getMessageBusParams().setMessageBusConfig(messagebusConfig);
    }

    public DocumentAccess delegate() {
        DocumentAccess access = this.delegate.getAcquire();
        return access != null ? access : this.delegate.updateAndGet(value -> {
            if (value != null) {
                return value;
            }
            if (this.shutDown) {
                throw new IllegalStateException("This document access has been shut down");
            }
            return new MessageBusDocumentAccess(this.parameters);
        });
    }

    public void shutdown() {
        this.delegate.updateAndGet(access -> {
            super.shutdown();
            this.shutDown = true;
            if (access != null) {
                access.shutdown();
            }
            return null;
        });
    }

    public SyncSession createSyncSession(SyncParameters parameters) {
        return this.delegate().createSyncSession(parameters);
    }

    public AsyncSession createAsyncSession(AsyncParameters parameters) {
        return this.delegate().createAsyncSession(parameters);
    }

    public VisitorSession createVisitorSession(VisitorParameters parameters) throws ParseException {
        return this.delegate().createVisitorSession(parameters);
    }

    public VisitorDestinationSession createVisitorDestinationSession(VisitorDestinationParameters parameters) {
        return this.delegate().createVisitorDestinationSession(parameters);
    }

    public SubscriptionSession createSubscription(SubscriptionParameters parameters) {
        return this.delegate().createSubscription(parameters);
    }

    public SubscriptionSession openSubscription(SubscriptionParameters parameters) {
        return this.delegate().openSubscription(parameters);
    }
}

