/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.di;

import com.yahoo.component.ComponentSpecification;
import com.yahoo.config.FileReference;
import com.yahoo.container.bundle.BundleInstantiationSpecification;
import com.yahoo.container.bundle.MockBundle;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import org.osgi.framework.Bundle;

public interface Osgi {
    default public void installPlatformBundles(Collection<String> bundlePaths) {
        System.out.println("installPlatformBundles " + bundlePaths);
    }

    default public Set<Bundle> useApplicationBundles(Collection<FileReference> bundles) {
        System.out.println("useBundles " + bundles.stream().map(Object::toString).collect(Collectors.joining(", ")));
        return Collections.emptySet();
    }

    default public Class<?> resolveClass(BundleInstantiationSpecification spec) {
        System.out.println("resolving class " + spec.classId);
        try {
            return Class.forName(spec.classId.getName());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    default public Bundle getBundle(ComponentSpecification spec) {
        System.out.println("resolving bundle " + spec);
        return new MockBundle();
    }
}

