/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jdisc.http.ssl.impl;

import java.util.Arrays;
import java.util.List;
import javax.net.ssl.SSLContext;
import org.eclipse.jetty.util.ssl.SslContextFactory;

class SslContextFactoryUtils {
    SslContextFactoryUtils() {
    }

    static void setEnabledCipherSuites(SslContextFactory factory, SSLContext sslContext, List<String> enabledCiphers) {
        String[] supportedCiphers = sslContext.getSupportedSSLParameters().getCipherSuites();
        factory.setIncludeCipherSuites((String[])enabledCiphers.toArray(String[]::new));
        factory.setExcludeCipherSuites(SslContextFactoryUtils.createExclusionList(enabledCiphers, supportedCiphers));
    }

    static void setEnabledProtocols(SslContextFactory factory, SSLContext sslContext, List<String> enabledProtocols) {
        String[] supportedProtocols = sslContext.getSupportedSSLParameters().getProtocols();
        factory.setIncludeProtocols((String[])enabledProtocols.toArray(String[]::new));
        factory.setExcludeProtocols(SslContextFactoryUtils.createExclusionList(enabledProtocols, supportedProtocols));
    }

    private static String[] createExclusionList(List<String> enabledValues, String[] supportedValues) {
        return (String[])Arrays.stream(supportedValues).filter(supportedValue -> !enabledValues.contains(supportedValue)).toArray(String[]::new);
    }
}

