/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jdisc.http.server.jetty;

import com.yahoo.jdisc.Response;
import com.yahoo.jdisc.handler.BindingNotFoundException;
import com.yahoo.jdisc.handler.CompletionHandler;
import com.yahoo.jdisc.handler.ContentChannel;
import com.yahoo.jdisc.handler.ResponseHandler;
import com.yahoo.jdisc.http.HttpResponse;
import com.yahoo.jdisc.http.server.jetty.CompletionHandlerUtils;
import com.yahoo.jdisc.http.server.jetty.ErrorResponseContentCreator;
import com.yahoo.jdisc.http.server.jetty.Janitor;
import com.yahoo.jdisc.http.server.jetty.RequestException;
import com.yahoo.jdisc.http.server.jetty.RequestMetricReporter;
import com.yahoo.jdisc.http.server.jetty.ServletOutputStreamWriter;
import com.yahoo.jdisc.service.BindingSetNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.MimeTypes;

public class ServletResponseController {
    private static Logger log = Logger.getLogger(ServletResponseController.class.getName());
    private final Object monitor = new Object();
    private final HttpServletRequest servletRequest;
    private final HttpServletResponse servletResponse;
    private final boolean developerMode;
    private final ErrorResponseContentCreator errorResponseContentCreator = new ErrorResponseContentCreator();
    private final ServletOutputStreamWriter servletOutputStreamWriter;
    private boolean responseCommitted = false;
    public final ResponseHandler responseHandler = new ResponseHandler(){

        public ContentChannel handleResponse(Response response) {
            ServletResponseController.this.setResponse(response);
            return ServletResponseController.this.responseContentChannel;
        }
    };
    public final ContentChannel responseContentChannel = new ContentChannel(){

        public void write(ByteBuffer buf, CompletionHandler handler) {
            ServletResponseController.this.commitResponse();
            ServletResponseController.this.servletOutputStreamWriter.writeBuffer(buf, this.handlerOrNoopHandler(handler));
        }

        public void close(CompletionHandler handler) {
            ServletResponseController.this.commitResponse();
            ServletResponseController.this.servletOutputStreamWriter.close(this.handlerOrNoopHandler(handler));
        }

        private CompletionHandler handlerOrNoopHandler(CompletionHandler handler) {
            return handler != null ? handler : CompletionHandlerUtils.NOOP_COMPLETION_HANDLER;
        }
    };

    public ServletResponseController(HttpServletRequest servletRequest, HttpServletResponse servletResponse, Janitor janitor, RequestMetricReporter metricReporter, boolean developerMode) throws IOException {
        this.servletRequest = servletRequest;
        this.servletResponse = servletResponse;
        this.developerMode = developerMode;
        this.servletOutputStreamWriter = new ServletOutputStreamWriter(servletResponse.getOutputStream(), janitor, metricReporter);
    }

    private static int getStatusCode(Throwable t) {
        if (t instanceof BindingNotFoundException) {
            return 404;
        }
        if (t instanceof BindingSetNotFoundException) {
            return 404;
        }
        if (t instanceof RequestException) {
            return ((RequestException)t).getResponseStatus();
        }
        if (t instanceof TimeoutException) {
            return 503;
        }
        return 500;
    }

    private static String getReasonPhrase(Throwable t, boolean developerMode) {
        if (developerMode) {
            StringWriter out = new StringWriter();
            t.printStackTrace(new PrintWriter(out));
            return out.toString();
        }
        if (t.getMessage() != null) {
            return t.getMessage();
        }
        return t.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trySendError(Throwable t) {
        boolean responseWasCommitted;
        try {
            Object object = this.monitor;
            synchronized (object) {
                String reasonPhrase = ServletResponseController.getReasonPhrase(t, this.developerMode);
                int statusCode = ServletResponseController.getStatusCode(t);
                responseWasCommitted = this.responseCommitted;
                if (!this.responseCommitted) {
                    this.responseCommitted = true;
                    this.sendErrorAsync(statusCode, reasonPhrase);
                }
            }
        }
        catch (Throwable e) {
            this.servletOutputStreamWriter.fail(t);
            return;
        }
        if (responseWasCommitted) {
            RuntimeException exceptionWithStackTrace = new RuntimeException(t);
            log.log(Level.FINE, "Response already committed, can't change response code", exceptionWithStackTrace);
            this.servletOutputStreamWriter.close();
        }
    }

    private void sendErrorAsync(int statusCode, String reasonPhrase) {
        this.servletResponse.setHeader("Expires", null);
        this.servletResponse.setHeader("Last-Modified", null);
        this.servletResponse.setHeader("Cache-Control", null);
        this.servletResponse.setHeader("Content-Type", null);
        this.servletResponse.setHeader("Content-Length", null);
        ServletResponseController.setStatus(this.servletResponse, statusCode, Optional.of(reasonPhrase));
        if (statusCode != 204 && statusCode != 304 && statusCode != 206 && statusCode >= 200) {
            this.servletResponse.setHeader("Cache-Control", "must-revalidate,no-cache,no-store");
            this.servletResponse.setContentType(MimeTypes.Type.TEXT_HTML_8859_1.toString());
            byte[] errorContent = this.errorResponseContentCreator.createErrorContent(this.servletRequest.getRequestURI(), statusCode, Optional.ofNullable(reasonPhrase));
            this.servletResponse.setContentLength(errorContent.length);
            this.servletOutputStreamWriter.sendErrorContentAndCloseAsync(ByteBuffer.wrap(errorContent));
        } else {
            this.servletResponse.setContentLength(0);
            this.servletOutputStreamWriter.close();
        }
    }

    public CompletableFuture<Void> finishedFuture() {
        return this.servletOutputStreamWriter.finishedFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setResponse(Response jdiscResponse) {
        Object object = this.monitor;
        synchronized (object) {
            this.servletRequest.setAttribute("requestType", (Object)jdiscResponse.getRequestType());
            if (this.responseCommitted) {
                log.log(Level.FINE, jdiscResponse.getError(), () -> "Response already committed, can't change response code. From: " + this.servletResponse.getStatus() + ", To: " + jdiscResponse.getStatus());
                this.servletOutputStreamWriter.close();
                return;
            }
            ServletResponseController.setStatus_holdingLock(jdiscResponse, this.servletResponse);
            ServletResponseController.setHeaders_holdingLock(jdiscResponse, this.servletResponse);
        }
    }

    private static void setHeaders_holdingLock(Response jdiscResponse, HttpServletResponse servletResponse) {
        for (Map.Entry entry : jdiscResponse.headers().entries()) {
            servletResponse.addHeader((String)entry.getKey(), (String)entry.getValue());
        }
        if (servletResponse.getContentType() == null) {
            servletResponse.setContentType("text/plain;charset=utf-8");
        }
    }

    private static void setStatus_holdingLock(Response jdiscResponse, HttpServletResponse servletResponse) {
        if (jdiscResponse instanceof HttpResponse) {
            ServletResponseController.setStatus(servletResponse, jdiscResponse.getStatus(), Optional.ofNullable(((HttpResponse)jdiscResponse).getMessage()));
        } else {
            ServletResponseController.setStatus(servletResponse, jdiscResponse.getStatus(), ServletResponseController.getErrorMessage(jdiscResponse));
        }
    }

    private static void setStatus(HttpServletResponse response, int statusCode, Optional<String> reasonPhrase) {
        if (reasonPhrase.isPresent()) {
            response.setStatus(statusCode, reasonPhrase.get());
        } else {
            response.setStatus(statusCode);
        }
    }

    private static Optional<String> getErrorMessage(Response jdiscResponse) {
        return Optional.ofNullable(jdiscResponse.getError()).flatMap(error -> Optional.ofNullable(error.getMessage()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commitResponse() {
        Object object = this.monitor;
        synchronized (object) {
            this.responseCommitted = true;
        }
    }
}

