/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jdisc.http.filter;

import com.yahoo.jdisc.http.filter.DiscFilterRequest;
import com.yahoo.jdisc.http.servlet.ServletRequest;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;

class ServletFilterRequest
extends DiscFilterRequest {
    private final ServletRequest parent;

    public ServletFilterRequest(ServletRequest parent) {
        super(parent);
        this.parent = parent;
    }

    ServletRequest getServletRequest() {
        return this.parent;
    }

    @Override
    public void setUri(URI uri) {
        this.parent.setUri(uri);
    }

    @Override
    public String getMethod() {
        return this.parent.getRequest().getMethod();
    }

    @Override
    public void setRemoteAddr(String remoteIpAddress) {
        throw new UnsupportedOperationException("Setting remote address is not supported for " + this.getClass().getName());
    }

    @Override
    public Enumeration<String> getAttributeNames() {
        HashSet<String> names = new HashSet<String>(Collections.list(super.getAttributeNames()));
        names.addAll(Collections.list(this.parent.getRequest().getAttributeNames()));
        return Collections.enumeration(names);
    }

    @Override
    public Object getAttribute(String name) {
        Object jdiscAttribute = super.getAttribute(name);
        return jdiscAttribute != null ? jdiscAttribute : this.parent.getRequest().getAttribute(name);
    }

    @Override
    public void setAttribute(String name, Object value) {
        super.setAttribute(name, value);
        this.parent.getRequest().setAttribute(name, value);
    }

    @Override
    public boolean containsAttribute(String name) {
        return super.containsAttribute(name) || this.parent.getRequest().getAttribute(name) != null;
    }

    @Override
    public void removeAttribute(String name) {
        super.removeAttribute(name);
        this.parent.getRequest().removeAttribute(name);
    }

    @Override
    public String getParameter(String name) {
        return this.parent.getParameter(name);
    }

    @Override
    public Enumeration<String> getParameterNames() {
        return this.parent.getParameterNames();
    }

    @Override
    public void addHeader(String name, String value) {
        this.parent.addHeader(name, value);
    }

    @Override
    public String getHeader(String name) {
        return this.parent.getHeader(name);
    }

    @Override
    public Enumeration<String> getHeaderNames() {
        return this.parent.getHeaderNames();
    }

    @Override
    public List<String> getHeaderNamesAsList() {
        return Collections.list(this.getHeaderNames());
    }

    @Override
    public Enumeration<String> getHeaders(String name) {
        return this.parent.getHeaders(name);
    }

    @Override
    public List<String> getHeadersAsList(String name) {
        return Collections.list(this.getHeaders(name));
    }

    @Override
    public void setHeaders(String name, String value) {
        this.parent.setHeaders(name, value);
    }

    @Override
    public void setHeaders(String name, List<String> values) {
        this.parent.setHeaders(name, values);
    }

    @Override
    public Principal getUserPrincipal() {
        return this.parent.getUserPrincipal();
    }

    @Override
    public void setUserPrincipal(Principal principal) {
        this.parent.setUserPrincipal(principal);
    }

    @Override
    public List<X509Certificate> getClientCertificateChain() {
        return Optional.ofNullable(this.parent.getRequest().getAttribute("javax.servlet.request.X509Certificate")).map(X509Certificate[].class::cast).map(Arrays::asList).orElse(Collections.emptyList());
    }

    @Override
    public void removeHeaders(String name) {
        this.parent.removeHeaders(name);
    }

    @Override
    public void clearCookies() {
        this.parent.removeHeaders("Cookie");
    }

    @Override
    public void setCharacterEncoding(String encoding) {
        super.setCharacterEncoding(encoding);
        try {
            this.parent.setCharacterEncoding(encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Encoding not supported: " + encoding, e);
        }
    }
}

