/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.metrics.simple.jdisc;

import com.yahoo.collections.Tuple2;
import com.yahoo.container.jdisc.state.CountMetric;
import com.yahoo.container.jdisc.state.GaugeMetric;
import com.yahoo.container.jdisc.state.MetricDimensions;
import com.yahoo.container.jdisc.state.MetricSet;
import com.yahoo.container.jdisc.state.MetricSnapshot;
import com.yahoo.container.jdisc.state.MetricValue;
import com.yahoo.container.jdisc.state.StateMetricContext;
import com.yahoo.metrics.simple.Bucket;
import com.yahoo.metrics.simple.Identifier;
import com.yahoo.metrics.simple.Point;
import com.yahoo.metrics.simple.UntypedMetric;
import com.yahoo.metrics.simple.Value;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.HdrHistogram.DoubleHistogram;

class SnapshotConverter {
    private static Logger log = Logger.getLogger(SnapshotConverter.class.getName());
    final Bucket snapshot;
    final Map<Point, Map<String, MetricValue>> perPointData = new HashMap<Point, Map<String, MetricValue>>();
    private static final char[] DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public SnapshotConverter(Bucket snapshot) {
        this.snapshot = snapshot;
    }

    static MetricDimensions convert(Point p) {
        if (p == null) {
            return StateMetricContext.newInstance(null);
        }
        List<String> dimensions = p.dimensions();
        List<Value> location = p.location();
        HashMap<String, Object> pointWrapper = new HashMap<String, Object>(dimensions.size());
        for (int i = 0; i < dimensions.size(); ++i) {
            pointWrapper.put(dimensions.get(i), SnapshotConverter.valueAsString(location.get(i)));
        }
        return StateMetricContext.newInstance(pointWrapper);
    }

    private static Object valueAsString(Value value) {
        switch (value.getType()) {
            case STRING: {
                return value.stringValue();
            }
            case LONG: {
                return value.longValue();
            }
            case DOUBLE: {
                return value.doubleValue();
            }
        }
        throw new IllegalStateException("simplemetrics impl is out of sync with itself, please file a ticket.");
    }

    static MetricValue convert(UntypedMetric val) {
        if (val.isCounter()) {
            return CountMetric.newInstance(val.getCount());
        }
        if (val.getHistogram() == null) {
            return GaugeMetric.newInstance(val.getLast(), val.getMax(), val.getMin(), val.getSum(), val.getCount());
        }
        return GaugeMetric.newInstance(val.getLast(), val.getMax(), val.getMin(), val.getSum(), val.getCount(), Optional.of(SnapshotConverter.buildPercentileList(val.getHistogram())));
    }

    private static List<Tuple2<String, Double>> buildPercentileList(DoubleHistogram histogram) {
        ArrayList<Tuple2<String, Double>> prefixAndValues = new ArrayList<Tuple2<String, Double>>(2);
        prefixAndValues.add(new Tuple2((Object)"95", (Object)histogram.getValueAtPercentile(95.0)));
        prefixAndValues.add(new Tuple2((Object)"99", (Object)histogram.getValueAtPercentile(99.0)));
        return prefixAndValues;
    }

    MetricSnapshot convert() {
        for (Map.Entry<Identifier, UntypedMetric> entry : this.snapshot.entrySet()) {
            Identifier ident = entry.getKey();
            this.getMap(ident.getLocation()).put(ident.getName(), SnapshotConverter.convert(entry.getValue()));
        }
        HashMap<MetricDimensions, MetricSet> data = new HashMap<MetricDimensions, MetricSet>();
        for (Map.Entry<Point, Map<String, MetricValue>> entry : this.perPointData.entrySet()) {
            MetricDimensions key = SnapshotConverter.convert(entry.getKey());
            MetricSet newval = new MetricSet(entry.getValue());
            MetricSet old = (MetricSet)data.get(key);
            if (old != null) {
                log.warning("losing MetricSet when converting for: " + entry.getKey());
                continue;
            }
            data.put(key, newval);
        }
        return new MetricSnapshot(this.snapshot.getFromMillis(), this.snapshot.getToMillis(), TimeUnit.MILLISECONDS, data);
    }

    private Map<String, MetricValue> getMap(Point point) {
        if (point == null) {
            point = Point.emptyPoint();
        }
        if (!this.perPointData.containsKey(point)) {
            this.perPointData.put(point, new HashMap());
        }
        return this.perPointData.get(point);
    }

    void outputHistograms(PrintStream output) {
        boolean gotHistogram = false;
        for (Map.Entry<Identifier, UntypedMetric> entry : this.snapshot.entrySet()) {
            if (entry.getValue().getHistogram() == null) continue;
            gotHistogram = true;
            DoubleHistogram histogram = entry.getValue().getHistogram();
            Identifier id = entry.getKey();
            String metricIdentifier = this.getIdentifierString(id);
            output.println("# start of metric " + metricIdentifier);
            histogram.outputPercentileDistribution(output, 4, Double.valueOf(1.0), true);
            output.println("# end of metric " + metricIdentifier);
        }
        if (!gotHistogram) {
            output.println("# No histograms currently available.");
        }
    }

    private String getIdentifierString(Identifier id) {
        StringBuilder buffer = new StringBuilder();
        Point location = id.getLocation();
        buffer.append(id.getName());
        if (location != null) {
            buffer.append(", dimensions: { ");
            Iterator<String> dimensions = location.dimensions().iterator();
            Iterator<Value> values = location.location().iterator();
            boolean firstDimension = true;
            while (dimensions.hasNext() && values.hasNext()) {
                if (firstDimension) {
                    firstDimension = false;
                } else {
                    buffer.append(", ");
                }
                this.serializeSingleDimension(buffer, dimensions.next(), values.next());
            }
            buffer.append(" }");
        }
        return buffer.toString();
    }

    private void serializeSingleDimension(StringBuilder buffer, String dimensionName, Value dimensionValue) {
        buffer.append('\"');
        this.escape(dimensionName, buffer);
        buffer.append("\": ");
        switch (dimensionValue.getType()) {
            case LONG: {
                buffer.append(Long.toString(dimensionValue.longValue()));
                break;
            }
            case DOUBLE: {
                buffer.append(Double.toString(dimensionValue.doubleValue()));
                break;
            }
            case STRING: {
                buffer.append('\"');
                this.escape(dimensionValue.stringValue(), buffer);
                buffer.append('\"');
                break;
            }
            default: {
                buffer.append("\"Unknown type for this dimension, this is a bug.\"");
            }
        }
    }

    private void escape(String in, StringBuilder target) {
        block9: for (char c : in.toCharArray()) {
            switch (c) {
                case '\"': {
                    target.append("\\\"");
                    continue block9;
                }
                case '\\': {
                    target.append("\\\\");
                    continue block9;
                }
                case '\b': {
                    target.append("\\b");
                    continue block9;
                }
                case '\f': {
                    target.append("\\f");
                    continue block9;
                }
                case '\n': {
                    target.append("\\n");
                    continue block9;
                }
                case '\r': {
                    target.append("\\r");
                    continue block9;
                }
                case '\t': {
                    target.append("\\t");
                    continue block9;
                }
                default: {
                    if (c < ' ') {
                        target.append("\\u").append(SnapshotConverter.fourDigitHexString(c));
                        continue block9;
                    }
                    target.append(c);
                }
            }
        }
    }

    private static char[] fourDigitHexString(char c) {
        char[] hex = new char[4];
        int in = c & 0xFFFF;
        for (int i = 3; i >= 0; --i) {
            hex[i] = DIGITS[in & 0xF];
            in >>>= 4;
        }
        return hex;
    }
}

