/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.metrics.simple;

public abstract class Value {
    private static final String UNSUPPORTED_VALUE_TYPE = "Unsupported value type.";

    public long longValue() throws UnsupportedOperationException {
        throw new UnsupportedOperationException(UNSUPPORTED_VALUE_TYPE);
    }

    public double doubleValue() throws UnsupportedOperationException {
        throw new UnsupportedOperationException(UNSUPPORTED_VALUE_TYPE);
    }

    public String stringValue() throws UnsupportedOperationException {
        throw new UnsupportedOperationException(UNSUPPORTED_VALUE_TYPE);
    }

    public abstract Discriminator getType();

    public static Value of(long value) {
        return new LongValue(value);
    }

    public static Value of(double value) {
        return new DoubleValue(value);
    }

    public static Value of(String value) {
        return new StringValue(value);
    }

    private static class StringValue
    extends Value {
        private final String value;

        StringValue(String value) {
            this.value = value;
        }

        @Override
        public String stringValue() {
            return this.value;
        }

        @Override
        public Discriminator getType() {
            return Discriminator.STRING;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            StringValue other = (StringValue)obj;
            return !(this.value == null ? other.value != null : !this.value.equals(other.value));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("StringValue [value=").append(this.value).append("]");
            return builder.toString();
        }
    }

    private static class DoubleValue
    extends Value {
        private final double value;

        DoubleValue(double value) {
            this.value = value;
        }

        @Override
        public double doubleValue() {
            return this.value;
        }

        @Override
        public Discriminator getType() {
            return Discriminator.DOUBLE;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            long temp = Double.doubleToLongBits(this.value);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DoubleValue other = (DoubleValue)obj;
            return Double.doubleToLongBits(this.value) == Double.doubleToLongBits(other.value);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("DoubleValue [value=").append(this.value).append("]");
            return builder.toString();
        }
    }

    private static class LongValue
    extends Value {
        private final long value;

        LongValue(long value) {
            this.value = value;
        }

        @Override
        public long longValue() {
            return this.value;
        }

        @Override
        public Discriminator getType() {
            return Discriminator.LONG;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (int)(this.value ^ this.value >>> 32);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            LongValue other = (LongValue)obj;
            return this.value == other.value;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("LongValue [value=").append(this.value).append("]");
            return builder.toString();
        }
    }

    public static enum Discriminator {
        LONG,
        DOUBLE,
        STRING;

    }
}

