/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.restapi;

import com.yahoo.container.jdisc.HttpRequest;
import com.yahoo.container.jdisc.HttpResponse;
import com.yahoo.container.jdisc.LoggingRequestHandler;
import com.yahoo.container.jdisc.RequestHandlerSpec;
import com.yahoo.jdisc.Metric;
import com.yahoo.restapi.RestApi;
import java.util.concurrent.Executor;

public abstract class RestApiRequestHandler<T extends RestApiRequestHandler<T>>
extends LoggingRequestHandler {
    private final RestApi restApi;

    protected RestApiRequestHandler(LoggingRequestHandler.Context context, RestApiProvider<T> provider) {
        super(context);
        this.restApi = provider.createRestApi(this);
    }

    protected RestApiRequestHandler(Executor executor, Metric metric, RestApiProvider<T> provider) {
        super(executor, metric);
        this.restApi = provider.createRestApi(this);
    }

    protected RestApiRequestHandler(LoggingRequestHandler.Context context, RestApi restApi) {
        super(context);
        this.restApi = restApi;
    }

    protected RestApiRequestHandler(Executor executor, Metric metric, RestApi restApi) {
        super(executor, metric);
        this.restApi = restApi;
    }

    @Override
    public final HttpResponse handle(HttpRequest request) {
        return this.restApi.handleRequest(request);
    }

    @Override
    public RequestHandlerSpec requestHandlerSpec() {
        return this.restApi.requestHandlerSpec();
    }

    public RestApi restApi() {
        return this.restApi;
    }

    @FunctionalInterface
    public static interface RestApiProvider<T> {
        public RestApi createRestApi(T var1);
    }
}

