/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jdisc.http.server.jetty;

import com.google.inject.Inject;
import com.yahoo.component.AbstractComponent;
import com.yahoo.concurrent.DaemonThreadFactory;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;

public class Janitor
extends AbstractComponent {
    private static final Logger log = Logger.getLogger(Janitor.class.getName());
    private final ExecutorService executor;

    @Inject
    public Janitor() {
        int threadPoolSize = Math.max(2, Runtime.getRuntime().availableProcessors() / 4);
        log.info("Creating janitor executor with " + threadPoolSize + " threads");
        this.executor = Executors.newFixedThreadPool(threadPoolSize, (ThreadFactory)new DaemonThreadFactory("jdisc-janitor-"));
    }

    public void scheduleTask(Runnable task) {
        this.executor.execute(task);
    }

    public void deconstruct() {
        try {
            this.executor.shutdown();
            if (!this.executor.awaitTermination(10L, TimeUnit.SECONDS)) {
                log.warning("Failed to shutdown janitor in time");
            }
        }
        catch (InterruptedException e) {
            log.warning("Interrupted while shutting down janitor");
            Thread.currentThread().interrupt();
        }
    }
}

