/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jdisc.http.server.jetty;

import com.yahoo.jdisc.http.server.jetty.JDiscServerConnector;
import org.eclipse.jetty.http2.server.HTTP2ServerConnection;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.server.HttpConnection;
import org.eclipse.jetty.server.Request;

public class RequestUtils {
    private RequestUtils() {
    }

    public static Connection getConnection(Request request) {
        return request.getHttpChannel().getConnection();
    }

    public static JDiscServerConnector getConnector(Request request) {
        return (JDiscServerConnector)request.getHttpChannel().getConnector();
    }

    static boolean isHttpServerConnection(Connection connection) {
        return connection instanceof HttpConnection || connection instanceof HTTP2ServerConnection;
    }

    public static int getConnectorLocalPort(Request request) {
        JDiscServerConnector connector = RequestUtils.getConnector(request);
        int actualLocalPort = connector.getLocalPort();
        int localPortIfConnectorUnopened = -1;
        int localPortIfConnectorClosed = -2;
        if (actualLocalPort == localPortIfConnectorUnopened || actualLocalPort == localPortIfConnectorClosed) {
            int localPortEphemeralPort;
            int configuredLocalPort = connector.listenPort();
            if (configuredLocalPort == (localPortEphemeralPort = 0)) {
                throw new IllegalStateException("Unable to determine connector's listen port");
            }
            return configuredLocalPort;
        }
        return actualLocalPort;
    }
}

