/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.metrics.simple;

import com.yahoo.collections.LazyMap;
import com.yahoo.collections.LazySet;
import com.yahoo.metrics.simple.Identifier;
import com.yahoo.metrics.simple.Measurement;
import com.yahoo.metrics.simple.Point;
import com.yahoo.metrics.simple.Sample;
import com.yahoo.metrics.simple.UntypedMetric;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Bucket {
    private static final Logger log = Logger.getLogger(Bucket.class.getName());
    private final Map<Identifier, UntypedMetric> values = LazyMap.newHashMap();
    boolean gotTimeStamps;
    long fromMillis;
    long toMillis;

    public Bucket() {
        this.gotTimeStamps = false;
        this.fromMillis = 0L;
        this.toMillis = 0L;
    }

    public Bucket(long fromMillis, long toMillis) {
        this.gotTimeStamps = true;
        this.fromMillis = fromMillis;
        this.toMillis = toMillis;
    }

    public Set<Map.Entry<Identifier, UntypedMetric>> entrySet() {
        return this.values.entrySet();
    }

    void put(Sample x) {
        UntypedMetric value = this.get(x);
        Measurement m = x.getMeasurement();
        switch (x.getMetricType()) {
            case GAUGE: {
                value.put(m.getMagnitude());
                break;
            }
            case COUNTER: {
                value.add(m.getMagnitude());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported metric type: " + x.getMetricType());
            }
        }
    }

    void put(Identifier id, UntypedMetric value) {
        this.values.put(id, value);
    }

    boolean hasIdentifier(Identifier id) {
        return this.values.containsKey(id);
    }

    void merge(Bucket other, boolean otherIsNewer) {
        LazySet malformedMetrics = LazySet.newHashSet();
        for (Map.Entry<Identifier, UntypedMetric> entry : other.values.entrySet()) {
            String metricName = entry.getKey().getName();
            try {
                if (malformedMetrics.contains((Object)metricName)) continue;
                this.get(entry.getKey(), entry.getValue()).merge(entry.getValue(), otherIsNewer);
            }
            catch (IllegalArgumentException e) {
                log.log(Level.WARNING, "Problems merging metric " + metricName + ", possibly ignoring data.");
                malformedMetrics.add((Object)metricName);
            }
        }
    }

    void merge(Bucket other) {
        boolean otherIsNewer = this.resolveTimeStamps(other);
        this.merge(other, otherIsNewer);
    }

    private boolean resolveTimeStamps(Bucket other) {
        boolean otherIsNewer;
        boolean bl = otherIsNewer = other.fromMillis > this.fromMillis;
        if (!this.gotTimeStamps) {
            this.fromMillis = other.fromMillis;
            this.toMillis = other.toMillis;
            this.gotTimeStamps = other.gotTimeStamps;
        } else if (other.gotTimeStamps) {
            this.fromMillis = Math.min(this.fromMillis, other.fromMillis);
            this.toMillis = Math.max(this.toMillis, other.toMillis);
        }
        return otherIsNewer;
    }

    private UntypedMetric get(Sample sample) {
        Identifier dim = sample.getIdentifier();
        UntypedMetric v = this.values.get(dim);
        if (v == null) {
            v = new UntypedMetric(sample.getHistogramDefinition(dim.getName()));
            this.values.put(dim, v);
        }
        return v;
    }

    private UntypedMetric get(Identifier dim, UntypedMetric other) {
        UntypedMetric v = this.values.get(dim);
        if (v == null) {
            v = new UntypedMetric(other.getMetricDefinition());
            this.values.put(dim, v);
        }
        return v;
    }

    public Collection<String> getAllMetricNames() {
        HashSet<String> names = new HashSet<String>();
        for (Identifier id : this.values.keySet()) {
            names.add(id.getName());
        }
        return names;
    }

    public Collection<Map.Entry<Point, UntypedMetric>> getValuesForMetric(String metricName) {
        ArrayList<Map.Entry<Point, UntypedMetric>> singleMetric = new ArrayList<Map.Entry<Point, UntypedMetric>>();
        for (Map.Entry<Identifier, UntypedMetric> entry : this.values.entrySet()) {
            if (!metricName.equals(entry.getKey().getName())) continue;
            singleMetric.add(this.locationValuePair(entry));
        }
        return singleMetric;
    }

    public Map<Point, UntypedMetric> getMapForMetric(String metricName) {
        HashMap<Point, UntypedMetric> result = new HashMap<Point, UntypedMetric>();
        for (Map.Entry<Identifier, UntypedMetric> entry : this.values.entrySet()) {
            if (!metricName.equals(entry.getKey().getName())) continue;
            result.put(entry.getKey().getLocation(), entry.getValue());
        }
        return result;
    }

    public Map<String, List<Map.Entry<Point, UntypedMetric>>> getValuesByMetricName() {
        HashMap<String, List<Map.Entry<Point, UntypedMetric>>> result = new HashMap<String, List<Map.Entry<Point, UntypedMetric>>>();
        for (Map.Entry<Identifier, UntypedMetric> entry : this.values.entrySet()) {
            List<AbstractMap.SimpleImmutableEntry<Point, UntypedMetric>> singleMetric;
            if (result.containsKey(entry.getKey().getName())) {
                singleMetric = (List)result.get(entry.getKey().getName());
            } else {
                singleMetric = new ArrayList();
                result.put(entry.getKey().getName(), singleMetric);
            }
            singleMetric.add(this.locationValuePair(entry));
        }
        return result;
    }

    private AbstractMap.SimpleImmutableEntry<Point, UntypedMetric> locationValuePair(Map.Entry<Identifier, UntypedMetric> entry) {
        return new AbstractMap.SimpleImmutableEntry<Point, UntypedMetric>(entry.getKey().getLocation(), entry.getValue());
    }

    public String toString() {
        return "Bucket [values=" + (this.values != null ? this.toString(this.values.entrySet(), 3) : null) + "]";
    }

    private String toString(Collection<?> collection, int maxLen) {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        Iterator<?> iterator = collection.iterator();
        for (int i = 0; iterator.hasNext() && i < maxLen; ++i) {
            if (i > 0) {
                builder.append(", ");
            }
            builder.append(iterator.next());
        }
        builder.append("]");
        return builder.toString();
    }

    public long getFromMillis() {
        return this.fromMillis;
    }

    public long getToMillis() {
        return this.toMillis;
    }
}

