/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.di.componentgraph.core;

import com.yahoo.container.di.componentgraph.core.ComponentNode;
import java.util.Arrays;

class Exceptions {
    Exceptions() {
    }

    static <E extends Throwable> E removeStackTrace(E exception) {
        if (Exceptions.preserveStackTrace()) {
            return exception;
        }
        exception.setStackTrace(new StackTraceElement[0]);
        return exception;
    }

    static boolean preserveStackTrace() {
        String preserve = System.getProperty("jdisc.container.preserveStackTrace");
        return preserve != null && !preserve.isEmpty();
    }

    static Throwable cutStackTraceAtConstructor(Throwable throwable, StackTraceElement marker) {
        if (throwable != null && !Exceptions.preserveStackTrace()) {
            int upTo;
            StackTraceElement[] stackTrace = throwable.getStackTrace();
            for (upTo = stackTrace.length - 1; upTo >= 0 && !stackTrace[upTo].getClassName().equals(ComponentNode.class.getName()); --upTo) {
            }
            while (upTo >= 0 && !stackTrace[upTo].getMethodName().equals("<init>")) {
                --upTo;
            }
            if (upTo < 0) {
                throwable.setStackTrace(new StackTraceElement[0]);
            } else {
                throwable.setStackTrace(Arrays.copyOfRange(stackTrace, 0, upTo));
            }
            Exceptions.cutStackTraceAtConstructor(throwable.getCause(), marker);
        }
        return throwable;
    }
}

