/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jdisc.http.server.jetty;

import com.yahoo.jdisc.http.ConnectorConfig;
import com.yahoo.jdisc.http.server.jetty.RequestUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.util.URIUtil;

class SecuredRedirectHandler
extends HandlerWrapper {
    private static final String HEALTH_CHECK_PATH = "/status.html";
    private final Map<Integer, Integer> redirectMap;

    SecuredRedirectHandler(List<ConnectorConfig> connectorConfigs) {
        this.redirectMap = SecuredRedirectHandler.createRedirectMap(connectorConfigs);
    }

    public void handle(String target, Request request, HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws IOException, ServletException {
        int localPort = RequestUtils.getConnectorLocalPort(request);
        if (!this.redirectMap.containsKey(localPort)) {
            this._handler.handle(target, request, servletRequest, servletResponse);
            return;
        }
        servletResponse.setContentLength(0);
        if (!servletRequest.getRequestURI().equals(HEALTH_CHECK_PATH)) {
            servletResponse.sendRedirect(URIUtil.newURI((String)"https", (String)request.getServerName(), (int)this.redirectMap.get(localPort), (String)request.getRequestURI(), (String)request.getQueryString()));
        }
        request.setHandled(true);
    }

    private static Map<Integer, Integer> createRedirectMap(List<ConnectorConfig> connectorConfigs) {
        HashMap<Integer, Integer> redirectMap = new HashMap<Integer, Integer>();
        for (ConnectorConfig connectorConfig : connectorConfigs) {
            if (!connectorConfig.secureRedirect().enabled()) continue;
            redirectMap.put(connectorConfig.listenPort(), connectorConfig.secureRedirect().port());
        }
        return redirectMap;
    }
}

