/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.metrics.simple;

import com.yahoo.metrics.simple.Point;

public class Identifier {
    private final String name;
    private final Point location;

    public Identifier(String name, Point location) {
        this.name = name == null ? "" : name;
        this.location = location == null ? Point.emptyPoint() : location;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.location.hashCode();
        result = 31 * result + this.name.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Identifier other = (Identifier)obj;
        if (!this.location.equals(other.location)) {
            return false;
        }
        return this.name.equals(other.name);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Identifier [name=").append(this.name).append(", location=").append(this.location).append("]");
        return builder.toString();
    }

    public String getName() {
        return this.name;
    }

    public Point getLocation() {
        return this.location;
    }
}

