/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jdisc.http.server.jetty;

import com.yahoo.jdisc.Request;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.LongAdder;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.AsyncContextEvent;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpChannelState;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.util.FutureCallback;
import org.eclipse.jetty.util.component.Graceful;

public class HttpResponseStatisticsCollector
extends HandlerWrapper
implements Graceful {
    static final String requestTypeAttribute = "requestType";
    private final AtomicReference<FutureCallback> shutdown = new AtomicReference();
    private final List<String> monitoringHandlerPaths;
    private final List<String> searchHandlerPaths;
    private static final String[] HTTP_RESPONSE_GROUPS = new String[]{"http.status.1xx", "http.status.2xx", "http.status.3xx", "http.status.4xx", "http.status.5xx", "http.status.401", "http.status.403"};
    private final AtomicLong inFlight = new AtomicLong();
    private final LongAdder[][][][][] statistics;
    private final AsyncListener completionWatcher = new AsyncListener(){

        public void onTimeout(AsyncEvent event) {
        }

        public void onStartAsync(AsyncEvent event) {
            event.getAsyncContext().addListener((AsyncListener)this);
        }

        public void onError(AsyncEvent event) {
        }

        public void onComplete(AsyncEvent event) throws IOException {
            HttpChannelState state = ((AsyncContextEvent)event).getHttpChannelState();
            Request request = state.getBaseRequest();
            HttpResponseStatisticsCollector.this.observeEndOfRequest(request, null);
        }
    };

    public HttpResponseStatisticsCollector(List<String> monitoringHandlerPaths, List<String> searchHandlerPaths) {
        this.monitoringHandlerPaths = monitoringHandlerPaths;
        this.searchHandlerPaths = searchHandlerPaths;
        this.statistics = new LongAdder[HttpProtocol.values().length][HttpScheme.values().length][HttpMethod.values().length][][];
        for (int protocol = 0; protocol < HttpProtocol.values().length; ++protocol) {
            for (int scheme = 0; scheme < HttpScheme.values().length; ++scheme) {
                for (int method = 0; method < HttpMethod.values().length; ++method) {
                    this.statistics[protocol][scheme][method] = new LongAdder[HTTP_RESPONSE_GROUPS.length][];
                    for (int group = 0; group < HTTP_RESPONSE_GROUPS.length; ++group) {
                        this.statistics[protocol][scheme][method][group] = new LongAdder[Request.RequestType.values().length];
                        for (int requestType = 0; requestType < Request.RequestType.values().length; ++requestType) {
                            this.statistics[protocol][scheme][method][group][requestType] = new LongAdder();
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(String path, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.inFlight.incrementAndGet();
        try {
            Handler handler = this.getHandler();
            if (handler != null && this.shutdown.get() == null && this.isStarted()) {
                handler.handle(path, baseRequest, request, response);
            } else if (!baseRequest.isHandled()) {
                baseRequest.setHandled(true);
                response.sendError(503);
            }
        }
        finally {
            HttpChannelState state = baseRequest.getHttpChannelState();
            if (state.isSuspended()) {
                if (state.isInitial()) {
                    state.addListener(this.completionWatcher);
                }
            } else if (state.isInitial()) {
                this.observeEndOfRequest(baseRequest, response);
            }
        }
    }

    private void observeEndOfRequest(Request request, HttpServletResponse flushableResponse) throws IOException {
        int group = this.groupIndex(request);
        if (group >= 0) {
            HttpProtocol protocol = this.getProtocol(request);
            HttpScheme scheme = this.getScheme(request);
            HttpMethod method = this.getMethod(request);
            Request.RequestType requestType = this.getRequestType(request);
            this.statistics[protocol.ordinal()][scheme.ordinal()][method.ordinal()][group][requestType.ordinal()].increment();
            if (group == 5 || group == 6) {
                this.statistics[protocol.ordinal()][scheme.ordinal()][method.ordinal()][3][requestType.ordinal()].increment();
            }
        }
        long live = this.inFlight.decrementAndGet();
        FutureCallback shutdownCb = this.shutdown.get();
        if (shutdownCb != null) {
            if (flushableResponse != null) {
                flushableResponse.flushBuffer();
            }
            if (live == 0L) {
                shutdownCb.succeeded();
            }
        }
    }

    private int groupIndex(Request request) {
        int index = request.getResponse().getStatus();
        if (index == 401) {
            return 5;
        }
        if (index == 403) {
            return 6;
        }
        if ((index = index / 100 - 1) < 0 || index >= this.statistics[0][0].length) {
            return -1;
        }
        return index;
    }

    private HttpScheme getScheme(Request request) {
        switch (request.getScheme()) {
            case "http": {
                return HttpScheme.HTTP;
            }
            case "https": {
                return HttpScheme.HTTPS;
            }
        }
        return HttpScheme.OTHER;
    }

    private HttpMethod getMethod(Request request) {
        switch (request.getMethod()) {
            case "GET": {
                return HttpMethod.GET;
            }
            case "PATCH": {
                return HttpMethod.PATCH;
            }
            case "POST": {
                return HttpMethod.POST;
            }
            case "PUT": {
                return HttpMethod.PUT;
            }
            case "DELETE": {
                return HttpMethod.DELETE;
            }
            case "OPTIONS": {
                return HttpMethod.OPTIONS;
            }
            case "HEAD": {
                return HttpMethod.HEAD;
            }
        }
        return HttpMethod.OTHER;
    }

    private HttpProtocol getProtocol(Request request) {
        switch (request.getProtocol()) {
            case "HTTP/1": 
            case "HTTP/1.0": 
            case "HTTP/1.1": {
                return HttpProtocol.HTTP1;
            }
            case "HTTP/2": 
            case "HTTP/2.0": {
                return HttpProtocol.HTTP2;
            }
        }
        return HttpProtocol.OTHER;
    }

    private Request.RequestType getRequestType(Request request) {
        Request.RequestType requestType = (Request.RequestType)request.getAttribute(requestTypeAttribute);
        if (requestType != null) {
            return requestType;
        }
        String path = request.getRequestURI();
        for (String monitoringHandlerPath : this.monitoringHandlerPaths) {
            if (!path.startsWith(monitoringHandlerPath)) continue;
            return Request.RequestType.MONITORING;
        }
        for (String searchHandlerPath : this.searchHandlerPaths) {
            if (!path.startsWith(searchHandlerPath)) continue;
            return Request.RequestType.READ;
        }
        if ("GET".equals(request.getMethod())) {
            return Request.RequestType.READ;
        }
        return Request.RequestType.WRITE;
    }

    public List<StatisticsEntry> takeStatistics() {
        ArrayList<StatisticsEntry> ret = new ArrayList<StatisticsEntry>();
        for (HttpProtocol protocol : HttpProtocol.values()) {
            int protocolIndex = protocol.ordinal();
            for (HttpScheme scheme : HttpScheme.values()) {
                int schemeIndex = scheme.ordinal();
                for (HttpMethod method : HttpMethod.values()) {
                    int methodIndex = method.ordinal();
                    for (int group = 0; group < HTTP_RESPONSE_GROUPS.length; ++group) {
                        for (Request.RequestType type : Request.RequestType.values()) {
                            long value = this.statistics[protocolIndex][schemeIndex][methodIndex][group][type.ordinal()].sumThenReset();
                            if (value <= 0L) continue;
                            ret.add(new StatisticsEntry(protocol.name().toLowerCase(), scheme.name().toLowerCase(), method.name(), HTTP_RESPONSE_GROUPS[group], type.name().toLowerCase(), value));
                        }
                    }
                }
            }
        }
        return ret;
    }

    protected void doStart() throws Exception {
        this.shutdown.set(null);
        super.doStart();
    }

    protected void doStop() throws Exception {
        super.doStop();
        FutureCallback shutdownCb = this.shutdown.get();
        if (!shutdownCb.isDone()) {
            shutdownCb.failed((Throwable)new TimeoutException());
        }
    }

    public Future<Void> shutdown() {
        FutureCallback shutdownCb = new FutureCallback(false);
        this.shutdown.compareAndSet(null, shutdownCb);
        shutdownCb = this.shutdown.get();
        if (this.inFlight.get() == 0L) {
            shutdownCb.succeeded();
        }
        return shutdownCb;
    }

    public boolean isShutdown() {
        FutureCallback futureCallback = this.shutdown.get();
        return futureCallback != null && futureCallback.isDone();
    }

    public static class StatisticsEntry {
        public final String protocol;
        public final String scheme;
        public final String method;
        public final String name;
        public final String requestType;
        public final long value;

        public StatisticsEntry(String protocol, String scheme, String method, String name, String requestType, long value) {
            this.protocol = protocol;
            this.scheme = scheme;
            this.method = method;
            this.name = name;
            this.requestType = requestType;
            this.value = value;
        }

        public String toString() {
            return "protocol: " + this.protocol + ", scheme: " + this.scheme + ", method: " + this.method + ", name: " + this.name + ", requestType: " + this.requestType + ", value: " + this.value;
        }
    }

    public static enum HttpProtocol {
        HTTP1,
        HTTP2,
        OTHER;

    }

    public static enum HttpScheme {
        HTTP,
        HTTPS,
        OTHER;

    }

    public static enum HttpMethod {
        GET,
        PATCH,
        POST,
        PUT,
        DELETE,
        OPTIONS,
        HEAD,
        OTHER;

    }
}

