/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jdisc.http.filter;

import com.yahoo.jdisc.http.HttpRequest;
import com.yahoo.jdisc.http.filter.DiscFilterRequest;
import java.net.URI;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Optional;

public class JdiscFilterRequest
extends DiscFilterRequest {
    private final HttpRequest parent;

    public JdiscFilterRequest(HttpRequest parent) {
        super(parent);
        this.parent = parent;
    }

    @Override
    public HttpRequest getParentRequest() {
        return this.parent;
    }

    @Override
    public void setUri(URI uri) {
        this.parent.setUri(uri);
    }

    @Override
    public String getMethod() {
        return this.parent.getMethod().name();
    }

    @Override
    public String getParameter(String name) {
        if (this.parent.parameters().containsKey(name)) {
            return this.parent.parameters().get(name).get(0);
        }
        return null;
    }

    @Override
    public Enumeration<String> getParameterNames() {
        return Collections.enumeration(this.parent.parameters().keySet());
    }

    @Override
    public void addHeader(String name, String value) {
        this.parent.headers().add(name, value);
    }

    @Override
    public String getHeader(String name) {
        List values = this.parent.headers().get((Object)name);
        if (values == null || values.isEmpty()) {
            return null;
        }
        return (String)values.get(values.size() - 1);
    }

    @Override
    public Enumeration<String> getHeaderNames() {
        return Collections.enumeration(this.parent.headers().keySet());
    }

    @Override
    public List<String> getHeaderNamesAsList() {
        return new ArrayList<String>(this.parent.headers().keySet());
    }

    @Override
    public Enumeration<String> getHeaders(String name) {
        return Collections.enumeration(this.getHeadersAsList(name));
    }

    @Override
    public List<String> getHeadersAsList(String name) {
        List values = this.parent.headers().get((Object)name);
        if (values == null) {
            return Collections.emptyList();
        }
        return this.parent.headers().get((Object)name);
    }

    @Override
    public void removeHeaders(String name) {
        this.parent.headers().remove((Object)name);
    }

    @Override
    public void setHeaders(String name, String value) {
        this.parent.headers().put(name, value);
    }

    @Override
    public void setHeaders(String name, List<String> values) {
        this.parent.headers().put(name, values);
    }

    @Override
    public Principal getUserPrincipal() {
        return this.parent.getUserPrincipal();
    }

    @Override
    public void setUserPrincipal(Principal principal) {
        this.parent.setUserPrincipal(principal);
    }

    @Override
    public List<X509Certificate> getClientCertificateChain() {
        return Optional.ofNullable(this.parent.context().get("jdisc.request.X509Certificate")).map(X509Certificate[].class::cast).map(Arrays::asList).orElse(Collections.emptyList());
    }

    @Override
    public void clearCookies() {
        this.parent.headers().remove((Object)"Cookie");
    }
}

