/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jdisc.http.servlet;

import com.yahoo.jdisc.HeaderFields;
import com.yahoo.jdisc.http.Cookie;
import com.yahoo.jdisc.http.servlet.ServletOrJdiscHttpResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class ServletResponse
extends HttpServletResponseWrapper
implements ServletOrJdiscHttpResponse {
    private final HttpServletResponse response;
    private final Map<String, Object> context = new HashMap<String, Object>();

    public ServletResponse(HttpServletResponse response) {
        super(response);
        this.response = response;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    @Override
    public int getStatus() {
        return this.response.getStatus();
    }

    @Override
    public Map<String, Object> context() {
        return this.context;
    }

    @Override
    public void copyHeaders(HeaderFields target) {
        this.response.getHeaderNames().forEach(header -> target.add(header, new ArrayList(this.response.getHeaders(header))));
    }

    @Override
    public List<Cookie> decodeSetCookieHeader() {
        Collection cookies = this.getHeaders("Set-Cookie");
        if (cookies == null) {
            return Collections.emptyList();
        }
        LinkedList<Cookie> ret = new LinkedList<Cookie>();
        for (String cookie : cookies) {
            ret.add(Cookie.fromSetCookieHeader(cookie));
        }
        return ret;
    }
}

