/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jdisc.http.server.jetty.testutils;

import com.google.inject.AbstractModule;
import com.google.inject.Module;
import com.google.inject.util.Modules;
import com.yahoo.container.logging.ConnectionLog;
import com.yahoo.container.logging.RequestLog;
import com.yahoo.jdisc.application.ContainerBuilder;
import com.yahoo.jdisc.handler.RequestHandler;
import com.yahoo.jdisc.http.ConnectorConfig;
import com.yahoo.jdisc.http.ServerConfig;
import com.yahoo.jdisc.http.ServletPathsConfig;
import com.yahoo.jdisc.http.server.jetty.FilterBindings;
import com.yahoo.jdisc.http.server.jetty.JettyHttpServer;
import com.yahoo.jdisc.http.server.jetty.VoidConnectionLog;
import com.yahoo.jdisc.http.server.jetty.VoidRequestLog;
import com.yahoo.jdisc.http.server.jetty.testutils.ConnectorFactoryRegistryModule;
import com.yahoo.jdisc.http.server.jetty.testutils.ServletModule;
import com.yahoo.jdisc.service.ServerProvider;
import com.yahoo.security.SslContextBuilder;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.net.ssl.SSLContext;

public class TestDriver
implements AutoCloseable {
    private final com.yahoo.jdisc.test.TestDriver jdiscCoreTestDriver;
    private final JettyHttpServer server;
    private final SSLContext sslContext;

    private TestDriver(Builder builder) {
        ServerConfig serverConfig = builder.serverConfig != null ? builder.serverConfig : new ServerConfig(new ServerConfig.Builder());
        ConnectorConfig connectorConfig = builder.connectorConfig != null ? builder.connectorConfig : new ConnectorConfig(new ConnectorConfig.Builder());
        Module baseModule = TestDriver.createBaseModule(serverConfig, connectorConfig);
        Module combinedModule = builder.extraGuiceModules.isEmpty() ? baseModule : Modules.override((Module[])new Module[]{baseModule}).with(builder.extraGuiceModules);
        com.yahoo.jdisc.test.TestDriver jdiscCoreTestDriver = com.yahoo.jdisc.test.TestDriver.newSimpleApplicationInstance((Module[])new Module[]{combinedModule});
        ContainerBuilder containerBuilder = jdiscCoreTestDriver.newContainerBuilder();
        JettyHttpServer server = (JettyHttpServer)((Object)containerBuilder.getInstance(JettyHttpServer.class));
        containerBuilder.serverProviders().install((ServerProvider)server);
        builder.handlers.forEach((binding, handler) -> containerBuilder.serverBindings().bind(binding, handler));
        jdiscCoreTestDriver.activateContainer(containerBuilder);
        server.start();
        this.jdiscCoreTestDriver = jdiscCoreTestDriver;
        this.server = server;
        this.sslContext = TestDriver.newSslContext(containerBuilder);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public SSLContext sslContext() {
        return this.sslContext;
    }

    public JettyHttpServer server() {
        return this.server;
    }

    @Override
    public void close() {
        this.shutdown();
    }

    public boolean shutdown() {
        this.server.close();
        this.server.release();
        return this.jdiscCoreTestDriver.close();
    }

    private static SSLContext newSslContext(ContainerBuilder builder) {
        ConnectorConfig.Ssl sslConfig = ((ConnectorConfig)((Object)builder.getInstance(ConnectorConfig.class))).ssl();
        if (!sslConfig.enabled()) {
            return null;
        }
        return new SslContextBuilder().withKeyStore(Paths.get(sslConfig.privateKeyFile(), new String[0]), Paths.get(sslConfig.certificateFile(), new String[0])).withTrustStore(Paths.get(sslConfig.caCertificateFile(), new String[0])).build();
    }

    private static Module createBaseModule(final ServerConfig serverConfig, final ConnectorConfig connectorConfig) {
        return Modules.combine((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(ServletPathsConfig.class).toInstance((Object)new ServletPathsConfig(new ServletPathsConfig.Builder()));
                this.bind(ServerConfig.class).toInstance((Object)serverConfig);
                this.bind(ConnectorConfig.class).toInstance((Object)connectorConfig);
                this.bind(FilterBindings.class).toInstance((Object)new FilterBindings.Builder().build());
                this.bind(ConnectionLog.class).toInstance((Object)new VoidConnectionLog());
                this.bind(RequestLog.class).toInstance((Object)new VoidRequestLog());
            }
        }, new ConnectorFactoryRegistryModule(connectorConfig), new ServletModule()});
    }

    public static class Builder {
        private final SortedMap<String, RequestHandler> handlers = new TreeMap<String, RequestHandler>();
        private final List<Module> extraGuiceModules = new ArrayList<Module>();
        private ServerConfig serverConfig;
        private ConnectorConfig connectorConfig;

        private Builder() {
        }

        public Builder withRequestHandler(String binding, RequestHandler handler) {
            this.handlers.put(binding, handler);
            return this;
        }

        public Builder withRequestHandler(RequestHandler handler) {
            return this.withRequestHandler("http://*/*", handler);
        }

        public Builder withServerConfig(ServerConfig config) {
            this.serverConfig = config;
            return this;
        }

        public Builder withConnectorConfig(ConnectorConfig config) {
            this.connectorConfig = config;
            return this;
        }

        public Builder withGuiceModule(Module module) {
            this.extraGuiceModules.add(module);
            return this;
        }

        public TestDriver build() {
            return new TestDriver(this);
        }
    }
}

