/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.bundle;

import com.yahoo.component.ComponentId;
import com.yahoo.component.ComponentSpecification;

public final class BundleInstantiationSpecification {
    public final ComponentId id;
    public final ComponentSpecification classId;
    public final ComponentSpecification bundle;
    private static final String defaultInternalBundle = "container-search-and-docproc";

    public BundleInstantiationSpecification(ComponentSpecification id, ComponentSpecification classId, ComponentSpecification bundle) {
        this.id = id.toId();
        this.classId = classId != null ? classId : id.withoutNamespace();
        this.bundle = bundle != null ? bundle : this.classId;
    }

    public BundleInstantiationSpecification(ComponentId id, ComponentSpecification classId, ComponentSpecification bundle) {
        this(id.toSpecification(), classId, bundle);
        assert (classId != null);
    }

    private static BundleInstantiationSpecification getInternalSpecificationFromString(String idSpec, String classSpec) {
        return new BundleInstantiationSpecification(new ComponentSpecification(idSpec), classSpec == null || classSpec.isEmpty() ? null : new ComponentSpecification(classSpec), new ComponentSpecification(defaultInternalBundle));
    }

    public static BundleInstantiationSpecification getInternalSearcherSpecification(ComponentSpecification idSpec, ComponentSpecification classSpec) {
        return new BundleInstantiationSpecification(idSpec, classSpec, new ComponentSpecification(defaultInternalBundle));
    }

    public static BundleInstantiationSpecification getInternalHandlerSpecificationFromStrings(String idSpec, String classSpec) {
        return BundleInstantiationSpecification.getInternalSpecificationFromString(idSpec, classSpec);
    }

    public static BundleInstantiationSpecification getInternalProcessingSpecificationFromStrings(String idSpec, String classSpec) {
        return BundleInstantiationSpecification.getInternalSpecificationFromString(idSpec, classSpec);
    }

    public static BundleInstantiationSpecification getInternalSearcherSpecificationFromStrings(String idSpec, String classSpec) {
        return BundleInstantiationSpecification.getInternalSpecificationFromString(idSpec, classSpec);
    }

    public static BundleInstantiationSpecification getFromStrings(String idSpec, String classSpec, String bundleSpec) {
        return new BundleInstantiationSpecification(new ComponentSpecification(idSpec), classSpec == null || classSpec.isEmpty() ? null : new ComponentSpecification(classSpec), bundleSpec == null || bundleSpec.isEmpty() ? null : new ComponentSpecification(bundleSpec));
    }

    public BundleInstantiationSpecification inBundle(String bundleName) {
        return new BundleInstantiationSpecification(this.id, this.classId, new ComponentSpecification(bundleName));
    }

    public String getClassName() {
        return this.classId.getName();
    }

    public BundleInstantiationSpecification nestInNamespace(ComponentId namespace) {
        return new BundleInstantiationSpecification(this.id.nestInNamespace(namespace), this.classId, this.bundle);
    }
}

