/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.restapi;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.yahoo.container.jdisc.HttpRequest;
import com.yahoo.container.jdisc.HttpResponse;
import com.yahoo.container.jdisc.LoggingRequestHandler;
import com.yahoo.jdisc.Metric;
import com.yahoo.jdisc.http.server.jetty.testutils.TestDriver;
import com.yahoo.jdisc.test.MockMetric;
import com.yahoo.restapi.RestApi;
import com.yahoo.restapi.RestApiRequestHandler;
import com.yahoo.yolean.Exceptions;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.OptionalInt;
import java.util.concurrent.Executors;

public class RestApiTestDriver
implements AutoCloseable {
    private final RestApiRequestHandler<?> handler;
    private final TestDriver testDriver;

    private RestApiTestDriver(Builder builder) {
        this.handler = builder.handler;
        this.testDriver = builder.jdiscHttpServer ? TestDriver.newBuilder().withRequestHandler(builder.handler).build() : null;
    }

    public static Builder newBuilder(RestApiRequestHandler<?> handler) {
        return new Builder(handler);
    }

    public static Builder newBuilder(RestApiRequestHandlerFactory factory) {
        return new Builder(factory);
    }

    public static LoggingRequestHandler.Context createHandlerTestContext() {
        return new LoggingRequestHandler.Context(Executors.newSingleThreadExecutor(), (Metric)new MockMetric());
    }

    public OptionalInt listenPort() {
        return this.testDriver != null ? OptionalInt.of(this.testDriver.server().getListenPort()) : OptionalInt.empty();
    }

    public RestApiRequestHandler<?> handler() {
        return this.handler;
    }

    public RestApi restApi() {
        return this.handler.restApi();
    }

    public ObjectMapper jacksonJsonMapper() {
        return this.handler.restApi().jacksonJsonMapper();
    }

    public HttpResponse executeRequest(HttpRequest request) {
        return this.handler.handle(request);
    }

    public InputStream requestContentOf(Object jacksonEntity) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Exceptions.uncheck(() -> this.handler.restApi().jacksonJsonMapper().writeValue((OutputStream)out, jacksonEntity));
        return new ByteArrayInputStream(out.toByteArray());
    }

    public <T> T parseJacksonResponseContent(HttpResponse response, TypeReference<T> type) {
        return (T)Exceptions.uncheck(() -> this.handler.restApi().jacksonJsonMapper().readValue(RestApiTestDriver.responseData(response), type));
    }

    public <T> T parseJacksonResponseContent(HttpResponse response, Class<T> type) {
        return (T)Exceptions.uncheck(() -> this.handler.restApi().jacksonJsonMapper().readValue(RestApiTestDriver.responseData(response), type));
    }

    private static byte[] responseData(HttpResponse response) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Exceptions.uncheck(() -> response.render(out));
        return out.toByteArray();
    }

    @Override
    public void close() throws Exception {
        if (this.testDriver != null) {
            this.testDriver.close();
        }
    }

    public static class Builder {
        private final RestApiRequestHandler<?> handler;
        private boolean jdiscHttpServer = false;

        private Builder(RestApiRequestHandler<?> handler) {
            this.handler = handler;
        }

        private Builder(RestApiRequestHandlerFactory factory) {
            this(factory.create(RestApiTestDriver.createHandlerTestContext()));
        }

        public Builder withJdiscHttpServer() {
            this.jdiscHttpServer = true;
            return this;
        }

        public RestApiTestDriver build() {
            return new RestApiTestDriver(this);
        }
    }

    @FunctionalInterface
    public static interface RestApiRequestHandlerFactory {
        public RestApiRequestHandler<?> create(LoggingRequestHandler.Context var1);
    }
}

