/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.processing.handler;

import com.google.common.collect.ImmutableList;
import com.yahoo.container.jdisc.AsyncHttpResponse;
import com.yahoo.container.jdisc.HttpRequest;
import com.yahoo.container.jdisc.VespaHeaders;
import com.yahoo.jdisc.handler.CompletionHandler;
import com.yahoo.jdisc.handler.ContentChannel;
import com.yahoo.processing.Request;
import com.yahoo.processing.Response;
import com.yahoo.processing.execution.Execution;
import com.yahoo.processing.handler.ResponseHeaders;
import com.yahoo.processing.handler.ResponseStatus;
import com.yahoo.processing.rendering.AsynchronousRenderer;
import com.yahoo.processing.rendering.Renderer;
import com.yahoo.processing.request.ErrorMessage;
import com.yahoo.processing.response.Data;
import com.yahoo.processing.response.DataList;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;

public class ProcessingResponse
extends AsyncHttpResponse {
    private final Request processingRequest;
    private final Response processingResponse;
    private final Execution execution;
    private final Renderer renderer;
    private boolean explicitStatusSet = false;

    public ProcessingResponse(int status, Request processingRequest, Response processingResponse, Renderer renderer, Executor renderingExecutor, Execution execution) {
        super(status);
        this.processingRequest = processingRequest;
        this.processingResponse = processingResponse;
        this.execution = execution;
        this.renderer = renderer;
    }

    @Override
    public void render(OutputStream stream, ContentChannel channel, CompletionHandler completionHandler) throws IOException {
        if (this.renderer instanceof AsynchronousRenderer) {
            AsynchronousRenderer asyncRenderer = (AsynchronousRenderer)this.renderer;
            asyncRenderer.setNetworkWiring(channel, completionHandler);
        }
        this.renderer.render(stream, this.processingResponse, this.execution, this.processingRequest);
    }

    @Override
    public String getContentType() {
        return this.renderer.getMimeType();
    }

    @Override
    public String getCharacterEncoding() {
        return this.renderer.getEncoding();
    }

    @Override
    public void complete() {
        this.addHeadersAndStatusFrom(this.processingResponse.data());
        if (!this.explicitStatusSet) {
            List<ErrorMessage> errors = this.flattenErrors(this.processingResponse);
            boolean isSuccess = !this.processingResponse.data().asList().isEmpty() || errors.isEmpty();
            this.setStatus(this.getHttpResponseStatus(isSuccess, this.processingRequest, errors.size() == 0 ? null : errors.get(0), errors));
        }
    }

    private void addHeadersAndStatusFrom(DataList<Data> dataList) {
        for (Data data : dataList.asList()) {
            if (data instanceof ResponseHeaders) {
                this.headers().addAll(((ResponseHeaders)data).headers());
                continue;
            }
            if (!this.explicitStatusSet && data instanceof ResponseStatus) {
                this.setStatus(((ResponseStatus)data).code());
                this.explicitStatusSet = true;
                continue;
            }
            if (!(data instanceof DataList)) continue;
            this.addHeadersAndStatusFrom((DataList)data);
        }
    }

    private List<ErrorMessage> flattenErrors(Response processingResponse) {
        Set<ErrorMessage> errors = this.flattenErrors(null, processingResponse.data());
        if (errors == null) {
            return Collections.emptyList();
        }
        return ImmutableList.copyOf(errors);
    }

    private Set<ErrorMessage> flattenErrors(Set<ErrorMessage> errors, Data data) {
        if (data.request() == null) {
            return Collections.EMPTY_SET;
        }
        errors = this.addTo(errors, data.request().errors());
        if (data instanceof DataList) {
            for (Data item : ((DataList)data).asList()) {
                errors = this.flattenErrors(errors, item);
            }
        }
        return errors;
    }

    private Set<ErrorMessage> addTo(Set<ErrorMessage> allErrors, List<ErrorMessage> errors) {
        if (errors.isEmpty()) {
            return allErrors;
        }
        if (allErrors == null) {
            allErrors = new LinkedHashSet<ErrorMessage>();
        }
        allErrors.addAll(errors);
        return allErrors;
    }

    private int getHttpResponseStatus(boolean isSuccess, Request request, ErrorMessage mainError, List<ErrorMessage> errors) {
        if (this.isBenchmarking(request)) {
            return VespaHeaders.getEagerErrorStatus(mainError, errors.iterator());
        }
        return VespaHeaders.getStatus(isSuccess, mainError, errors.iterator());
    }

    private boolean isBenchmarking(Request request) {
        HttpRequest httpRequest = (HttpRequest)request.properties().get(Request.JDISC_REQUEST);
        if (httpRequest == null) {
            return false;
        }
        return VespaHeaders.benchmarkOutput(httpRequest);
    }

    @Override
    public Iterable<Execution.Trace.LogValue> getLogValues() {
        return this.execution.trace()::logValueIterator;
    }
}

