/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.processing;

import com.google.common.util.concurrent.AbstractFuture;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.yahoo.component.provider.ListenableFreezableClass;
import com.yahoo.concurrent.SystemTimer;
import com.yahoo.processing.Request;
import com.yahoo.processing.execution.ResponseReceiver;
import com.yahoo.processing.request.CompoundName;
import com.yahoo.processing.request.ErrorMessage;
import com.yahoo.processing.response.ArrayDataList;
import com.yahoo.processing.response.Data;
import com.yahoo.processing.response.DataList;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class Response
extends ListenableFreezableClass {
    private static final CompoundName freezeListenerKey = new CompoundName("processing.freezeListener");
    private final DataList<?> data;

    public Response(Request request) {
        this(ArrayDataList.create(request));
    }

    public Response(DataList<?> data) {
        this.data = data;
        Runnable freezeListener = null;
        Request request = data.request();
        if (request != null) {
            freezeListener = (Runnable)request.properties().get(freezeListenerKey);
        }
        if (freezeListener != null) {
            if (freezeListener instanceof ResponseReceiver) {
                ((ResponseReceiver)((Object)freezeListener)).setResponse(this);
            }
            data.addFreezeListener(freezeListener, MoreExecutors.directExecutor());
        }
    }

    public Response(Request request, ErrorMessage errorMessage) {
        this(ArrayDataList.create(request));
        request.errors().add(errorMessage);
    }

    public void mergeWith(Response other) {
    }

    public DataList data() {
        return this.data;
    }

    public static <D extends Data> ListenableFuture<DataList<D>> recursiveComplete(DataList<D> rootDataList) {
        ArrayList<ListenableFuture<DataList<D>>> futures = new ArrayList<ListenableFuture<DataList<D>>>();
        Response.collectCompletionFutures(rootDataList, futures);
        return new CompleteAllOnGetFuture<D>(futures);
    }

    private static <D extends Data> void collectCompletionFutures(DataList<D> dataList, List<ListenableFuture<DataList<D>>> futures) {
        futures.add(dataList.complete());
        for (Data data : dataList.asList()) {
            if (!(data instanceof DataList)) continue;
            Response.collectCompletionFutures((DataList)data, futures);
        }
    }

    private static class CompleteAllOnGetFuture<D extends Data>
    extends AbstractFuture<DataList<D>> {
        private final List<ListenableFuture<DataList<D>>> futures;

        public CompleteAllOnGetFuture(List<ListenableFuture<DataList<D>>> futures) {
            this.futures = new ArrayList<ListenableFuture<DataList<D>>>(futures);
        }

        public DataList<D> get() throws InterruptedException, ExecutionException {
            DataList result = null;
            for (ListenableFuture<DataList<D>> future : this.futures) {
                if (result == null) {
                    result = (DataList)future.get();
                    continue;
                }
                future.get();
            }
            this.set(result);
            return result;
        }

        public DataList<D> get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            DataList result = null;
            long timeLeft = unit.toMillis(timeout);
            long currentCallStart = SystemTimer.INSTANCE.milliTime();
            for (ListenableFuture<DataList<D>> future : this.futures) {
                if (result == null) {
                    result = (DataList)future.get(timeLeft, TimeUnit.MILLISECONDS);
                } else {
                    future.get(timeLeft, TimeUnit.MILLISECONDS);
                }
                long currentCallEnd = SystemTimer.INSTANCE.milliTime();
                if ((timeLeft -= currentCallEnd - currentCallStart) <= 0L) break;
                currentCallStart = currentCallEnd;
            }
            this.set(result);
            return result;
        }
    }
}

