/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.metrics.simple;

import com.google.common.annotations.Beta;
import com.yahoo.metrics.simple.Identifier;
import com.yahoo.metrics.simple.Measurement;
import com.yahoo.metrics.simple.MetricReceiver;
import com.yahoo.metrics.simple.Point;
import com.yahoo.metrics.simple.PointBuilder;
import com.yahoo.metrics.simple.Sample;
import com.yahoo.metrics.simple.UntypedMetric;

@Beta
public class Gauge {
    private final Point defaultPosition;
    private final String name;
    private final MetricReceiver receiver;

    Gauge(String name, Point defaultPosition, MetricReceiver receiver) {
        this.name = name;
        this.defaultPosition = defaultPosition;
        this.receiver = receiver;
    }

    public void sample(double x) {
        this.sample(x, this.defaultPosition);
    }

    public void sample(double x, Point p) {
        this.receiver.update(new Sample(new Measurement(x), new Identifier(this.name, p), UntypedMetric.AssumedType.GAUGE));
    }

    public PointBuilder builder() {
        return new PointBuilder(this.defaultPosition);
    }
}

