/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jdisc.http.server.jetty;

import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import javax.net.ssl.SSLHandshakeException;

enum SslHandshakeFailure {
    INCOMPATIBLE_PROTOCOLS("jdisc.http.ssl.handshake.failure.incompatible_protocols", "INCOMPATIBLE_CLIENT_PROTOCOLS", "(Client requested protocol \\S+? is not enabled or supported in server context|The client supported protocol versions \\[.+?\\] are not accepted by server preferences \\[.+?\\])"),
    INCOMPATIBLE_CIPHERS("jdisc.http.ssl.handshake.failure.incompatible_ciphers", "INCOMPATIBLE_CLIENT_CIPHER_SUITES", "no cipher suites in common"),
    MISSING_CLIENT_CERT("jdisc.http.ssl.handshake.failure.missing_client_cert", "MISSING_CLIENT_CERTIFICATE", "Empty (server|client) certificate chain"),
    EXPIRED_CLIENT_CERTIFICATE("jdisc.http.ssl.handshake.failure.expired_client_cert", "EXPIRED_CLIENT_CERTIFICATE", "PKIX path validation failed: java.security.cert.CertPathValidatorException: validity check failed"),
    INVALID_CLIENT_CERT("jdisc.http.ssl.handshake.failure.invalid_client_cert", "INVALID_CLIENT_CERTIFICATE", "(PKIX path (building|validation) failed: .+)|(Invalid CertificateVerify signature)");

    private final String metricName;
    private final String failureType;
    private final Predicate<String> messageMatcher;

    private SslHandshakeFailure(String metricName, String failureType, String messagePattern) {
        this.metricName = metricName;
        this.failureType = failureType;
        this.messageMatcher = Pattern.compile(messagePattern).asMatchPredicate();
    }

    String metricName() {
        return this.metricName;
    }

    String failureType() {
        return this.failureType;
    }

    static Optional<SslHandshakeFailure> fromSslHandshakeException(SSLHandshakeException exception) {
        String message = exception.getMessage();
        if (message == null || message.isBlank()) {
            return Optional.empty();
        }
        for (SslHandshakeFailure failure : SslHandshakeFailure.values()) {
            if (!failure.messageMatcher.test(message)) continue;
            return Optional.of(failure);
        }
        return Optional.empty();
    }
}

