/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jdisc.http.server.jetty;

import com.google.common.base.Preconditions;
import com.yahoo.jdisc.Request;
import com.yahoo.jdisc.ResourceReference;
import com.yahoo.jdisc.handler.AbstractRequestHandler;
import com.yahoo.jdisc.handler.CompletionHandler;
import com.yahoo.jdisc.handler.ContentChannel;
import com.yahoo.jdisc.handler.DelegatedRequestHandler;
import com.yahoo.jdisc.handler.RequestHandler;
import com.yahoo.jdisc.handler.ResponseHandler;
import com.yahoo.jdisc.http.HttpRequest;
import com.yahoo.jdisc.http.server.jetty.CompletionHandlerUtils;
import com.yahoo.jdisc.http.server.jetty.RequestException;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

class FormPostRequestHandler
extends AbstractRequestHandler
implements ContentChannel,
DelegatedRequestHandler {
    private final ByteArrayOutputStream accumulatedRequestContent = new ByteArrayOutputStream();
    private final RequestHandler delegateHandler;
    private final String contentCharsetName;
    private final boolean removeBody;
    private Charset contentCharset;
    private HttpRequest request;
    private ResourceReference requestReference;
    private ResponseHandler responseHandler;

    public FormPostRequestHandler(RequestHandler delegateHandler, String contentCharsetName, boolean removeBody) {
        this.delegateHandler = Objects.requireNonNull(delegateHandler);
        this.contentCharsetName = Objects.requireNonNull(contentCharsetName);
        this.removeBody = removeBody;
    }

    public ContentChannel handleRequest(Request request, ResponseHandler responseHandler) {
        Preconditions.checkArgument((boolean)(request instanceof HttpRequest), (Object)("Expected HttpRequest, got " + request));
        Objects.requireNonNull(responseHandler, "responseHandler");
        this.contentCharset = FormPostRequestHandler.getCharsetByName(this.contentCharsetName);
        this.responseHandler = responseHandler;
        this.request = (HttpRequest)request;
        this.requestReference = request.refer();
        return this;
    }

    public void write(ByteBuffer buf, CompletionHandler completionHandler) {
        assert (buf.hasArray());
        this.accumulatedRequestContent.write(buf.array(), buf.arrayOffset() + buf.position(), buf.remaining());
        completionHandler.completed();
    }

    public void close(CompletionHandler completionHandler) {
        try (ResourceReference ref = this.requestReference;){
            byte[] requestContentBytes = this.accumulatedRequestContent.toByteArray();
            String content = new String(requestContentBytes, this.contentCharset);
            completionHandler.completed();
            Map<String, List<String>> parameterMap = FormPostRequestHandler.parseFormParameters(content);
            FormPostRequestHandler.mergeParameters(parameterMap, this.request.parameters());
            ContentChannel contentChannel = this.delegateHandler.handleRequest((Request)this.request, this.responseHandler);
            if (contentChannel != null) {
                if (!this.removeBody) {
                    ByteBuffer byteBuffer = ByteBuffer.wrap(requestContentBytes);
                    contentChannel.write(byteBuffer, CompletionHandlerUtils.NOOP_COMPLETION_HANDLER);
                }
                contentChannel.close(CompletionHandlerUtils.NOOP_COMPLETION_HANDLER);
            }
        }
    }

    private static Charset getCharsetByName(String charsetName) throws RequestException {
        try {
            Charset charset = Charset.forName(charsetName);
            if (charset == null) {
                throw new RequestException(415, "Unsupported charset " + charsetName);
            }
            return charset;
        }
        catch (IllegalCharsetNameException | UnsupportedCharsetException e) {
            throw new RequestException(415, "Unsupported charset " + charsetName, e);
        }
    }

    private static Map<String, List<String>> parseFormParameters(String formContent) {
        String[] params;
        if (formContent.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, List<String>> parameterMap = new HashMap<String, List<String>>();
        for (String param : params = formContent.split("&")) {
            String[] parts = param.split("=");
            String paramName = FormPostRequestHandler.urlDecode(parts[0]);
            String paramValue = parts.length > 1 ? FormPostRequestHandler.urlDecode(parts[1]) : "";
            LinkedList<String> currentValues = (LinkedList<String>)parameterMap.get(paramName);
            if (currentValues == null) {
                currentValues = new LinkedList<String>();
                parameterMap.put(paramName, currentValues);
            }
            currentValues.add(paramValue);
        }
        return parameterMap;
    }

    private static String urlDecode(String encoded) {
        try {
            return URLDecoder.decode(encoded, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Whoa, JVM doesn't support UTF-8 today.", e);
        }
    }

    private static void mergeParameters(Map<String, List<String>> source, Map<String, List<String>> destination) {
        for (Map.Entry<String, List<String>> entry : source.entrySet()) {
            List<String> destinationValues = destination.get(entry.getKey());
            if (destinationValues != null) {
                destinationValues.addAll((Collection<String>)entry.getValue());
                continue;
            }
            destination.put(entry.getKey(), entry.getValue());
        }
    }

    public RequestHandler getDelegate() {
        return this.delegateHandler;
    }
}

