/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jdisc.http.filter;

import com.yahoo.jdisc.HeaderFields;
import com.yahoo.jdisc.http.Cookie;
import com.yahoo.jdisc.http.HttpResponse;
import com.yahoo.jdisc.http.filter.JDiscCookieWrapper;
import com.yahoo.jdisc.http.servlet.ServletOrJdiscHttpResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;

public abstract class DiscFilterResponse {
    private final ServletOrJdiscHttpResponse parent;
    private final HeaderFields untreatedHeaders;
    private final List<Cookie> untreatedCookies;

    public DiscFilterResponse(ServletOrJdiscHttpResponse parent) {
        this.parent = parent;
        this.untreatedHeaders = new HeaderFields();
        parent.copyHeaders(this.untreatedHeaders);
        this.untreatedCookies = this.getCookies();
    }

    public Enumeration<String> getAttributeNames() {
        return Collections.enumeration(this.parent.context().keySet());
    }

    public Object getAttribute(String name) {
        return this.parent.context().get(name);
    }

    public void setAttribute(String name, Object value) {
        this.parent.context().put(name, value);
    }

    public void removeAttribute(String name) {
        this.parent.context().remove(name);
    }

    public HeaderFields getUntreatedHeaders() {
        return this.untreatedHeaders;
    }

    public List<Cookie> getUntreatedCookies() {
        return this.untreatedCookies;
    }

    public abstract void setHeader(String var1, String var2);

    public abstract void removeHeaders(String var1);

    public abstract void setHeaders(String var1, String var2);

    public abstract void setHeaders(String var1, List<String> var2);

    public abstract void addHeader(String var1, String var2);

    public abstract String getHeader(String var1);

    public List<Cookie> getCookies() {
        return this.parent.decodeSetCookieHeader();
    }

    public abstract void setCookies(List<Cookie> var1);

    public int getStatus() {
        return this.parent.getStatus();
    }

    public abstract void setStatus(int var1);

    public HttpResponse getParentResponse() {
        if (this.parent instanceof HttpResponse) {
            return (HttpResponse)this.parent;
        }
        throw new UnsupportedOperationException("getParentResponse is not supported for " + this.parent.getClass().getName());
    }

    public void addCookie(JDiscCookieWrapper cookie) {
        if (cookie != null) {
            ArrayList<Cookie> cookies = new ArrayList<Cookie>();
            List<Cookie> c = this.getCookies();
            if (c != null && !c.isEmpty()) {
                cookies.addAll(c);
            }
            cookies.add(cookie.getCookie());
            this.setCookies(cookies);
        }
    }

    public void sendError(int errorCode) throws IOException {
        this.setStatus(errorCode);
    }

    public void setCookie(String name, String value) {
        Cookie cookie = new Cookie(name, value);
        this.setCookies(Arrays.asList(cookie));
    }
}

