/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.jdisc.state;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.inject.Inject;
import com.yahoo.collections.Tuple2;
import com.yahoo.component.provider.ComponentRegistry;
import com.yahoo.container.jdisc.state.CountMetric;
import com.yahoo.container.jdisc.state.GaugeMetric;
import com.yahoo.container.jdisc.state.JsonUtil;
import com.yahoo.container.jdisc.state.MetricDimensions;
import com.yahoo.container.jdisc.state.MetricGatherer;
import com.yahoo.container.jdisc.state.MetricSet;
import com.yahoo.container.jdisc.state.MetricSnapshot;
import com.yahoo.container.jdisc.state.MetricValue;
import com.yahoo.container.jdisc.state.MetricsPacketsHandlerConfig;
import com.yahoo.container.jdisc.state.SnapshotProvider;
import com.yahoo.container.jdisc.state.StateHandler;
import com.yahoo.container.jdisc.state.StateMonitor;
import com.yahoo.jdisc.Request;
import com.yahoo.jdisc.Response;
import com.yahoo.jdisc.Timer;
import com.yahoo.jdisc.handler.AbstractRequestHandler;
import com.yahoo.jdisc.handler.ContentChannel;
import com.yahoo.jdisc.handler.ResponseDispatch;
import com.yahoo.jdisc.handler.ResponseHandler;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class MetricsPacketsHandler
extends AbstractRequestHandler {
    private static final ObjectMapper jsonMapper = new ObjectMapper();
    static final String APPLICATION_KEY = "application";
    static final String TIMESTAMP_KEY = "timestamp";
    static final String STATUS_CODE_KEY = "status_code";
    static final String STATUS_MSG_KEY = "status_msg";
    static final String METRICS_KEY = "metrics";
    static final String DIMENSIONS_KEY = "dimensions";
    static final String PACKET_SEPARATOR = "\n\n";
    private final StateMonitor monitor;
    private final Timer timer;
    private final SnapshotProvider snapshotProvider;
    private final String applicationName;

    @Inject
    public MetricsPacketsHandler(StateMonitor monitor, Timer timer, ComponentRegistry<SnapshotProvider> snapshotProviders, MetricsPacketsHandlerConfig config) {
        this.monitor = monitor;
        this.timer = timer;
        this.snapshotProvider = StateHandler.getSnapshotProviderOrThrow(snapshotProviders);
        this.applicationName = config.application();
    }

    public ContentChannel handleRequest(final Request request, ResponseHandler handler) {
        new ResponseDispatch(){

            protected Response newResponse() {
                Response response = new Response(200);
                response.headers().add("Content-Type", "application/json");
                return response;
            }

            protected Iterable<ByteBuffer> responseContent() {
                return Collections.singleton(ByteBuffer.wrap(MetricsPacketsHandler.this.buildMetricOutput(request.getUri().getQuery())));
            }
        }.dispatch(handler);
        return null;
    }

    private byte[] buildMetricOutput(String query) {
        try {
            if (query != null && query.equals("array-formatted")) {
                return this.getMetricsArray();
            }
            String output = MetricsPacketsHandler.jsonToString(this.getStatusPacket()) + this.getAllMetricsPackets() + "\n";
            return output.getBytes(StandardCharsets.UTF_8);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Bad JSON construction.", e);
        }
    }

    private byte[] getMetricsArray() throws JsonProcessingException {
        ObjectNode root = jsonMapper.createObjectNode();
        ArrayNode jsonArray = jsonMapper.createArrayNode();
        jsonArray.add(this.getStatusPacket());
        this.getPacketsForSnapshot(this.getSnapshot(), this.applicationName, this.timer.currentTimeMillis()).forEach(arg_0 -> ((ArrayNode)jsonArray).add(arg_0));
        MetricGatherer.getAdditionalMetrics().forEach(arg_0 -> ((ArrayNode)jsonArray).add(arg_0));
        root.set(METRICS_KEY, (JsonNode)jsonArray);
        return MetricsPacketsHandler.jsonToString((JsonNode)root).getBytes(StandardCharsets.UTF_8);
    }

    private JsonNode getStatusPacket() {
        ObjectNode packet = jsonMapper.createObjectNode();
        packet.put(APPLICATION_KEY, this.applicationName);
        StateMonitor.Status status = this.monitor.status();
        packet.put(STATUS_CODE_KEY, status.ordinal());
        packet.put(STATUS_MSG_KEY, status.name());
        return packet;
    }

    private static String jsonToString(JsonNode jsonObject) throws JsonProcessingException {
        return jsonMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)jsonObject);
    }

    private String getAllMetricsPackets() throws JsonProcessingException {
        StringBuilder ret = new StringBuilder();
        List<JsonNode> metricsPackets = this.getPacketsForSnapshot(this.getSnapshot(), this.applicationName, this.timer.currentTimeMillis());
        for (JsonNode packet : metricsPackets) {
            ret.append(PACKET_SEPARATOR);
            ret.append(MetricsPacketsHandler.jsonToString(packet));
        }
        return ret.toString();
    }

    private MetricSnapshot getSnapshot() {
        return this.snapshotProvider.latestSnapshot();
    }

    private List<JsonNode> getPacketsForSnapshot(MetricSnapshot metricSnapshot, String application, long timestamp) {
        if (metricSnapshot == null) {
            return Collections.emptyList();
        }
        ArrayList<JsonNode> packets = new ArrayList<JsonNode>();
        for (Map.Entry<MetricDimensions, MetricSet> snapshotEntry : metricSnapshot) {
            MetricDimensions metricDimensions = snapshotEntry.getKey();
            MetricSet metricSet = snapshotEntry.getValue();
            ObjectNode packet = jsonMapper.createObjectNode();
            this.addMetaData(timestamp, application, packet);
            this.addDimensions(metricDimensions, packet);
            this.addMetrics(metricSet, packet);
            packets.add((JsonNode)packet);
        }
        return packets;
    }

    private void addMetaData(long timestamp, String application, ObjectNode packet) {
        packet.put(APPLICATION_KEY, application);
        packet.put(TIMESTAMP_KEY, TimeUnit.MILLISECONDS.toSeconds(timestamp));
    }

    private void addDimensions(MetricDimensions metricDimensions, ObjectNode packet) {
        if (metricDimensions == null) {
            return;
        }
        Iterator dimensionsIterator = metricDimensions.iterator();
        if (dimensionsIterator.hasNext()) {
            ObjectNode jsonDim = jsonMapper.createObjectNode();
            packet.set(DIMENSIONS_KEY, (JsonNode)jsonDim);
            for (Map.Entry dimensionEntry : metricDimensions) {
                jsonDim.put((String)dimensionEntry.getKey(), (String)dimensionEntry.getValue());
            }
        }
    }

    private void addMetrics(MetricSet metricSet, ObjectNode packet) {
        ObjectNode metrics = jsonMapper.createObjectNode();
        packet.set(METRICS_KEY, (JsonNode)metrics);
        for (Map.Entry<String, MetricValue> metric : metricSet) {
            String name = metric.getKey();
            MetricValue value = metric.getValue();
            if (value instanceof CountMetric) {
                metrics.put(name + ".count", ((CountMetric)value).getCount());
                continue;
            }
            if (value instanceof GaugeMetric) {
                GaugeMetric gauge = (GaugeMetric)value;
                metrics.put(name + ".average", JsonUtil.sanitizeDouble(gauge.getAverage())).put(name + ".last", JsonUtil.sanitizeDouble(gauge.getLast())).put(name + ".max", JsonUtil.sanitizeDouble(gauge.getMax()));
                if (!gauge.getPercentiles().isPresent()) continue;
                for (Tuple2<String, Double> prefixAndValue : gauge.getPercentiles().get()) {
                    metrics.put(name + "." + (String)prefixAndValue.first + "percentile", ((Double)prefixAndValue.second).doubleValue());
                }
                continue;
            }
            throw new UnsupportedOperationException("Unknown metric class: " + value.getClass().getName());
        }
    }
}

