/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.handler.threadpool;

import com.google.common.util.concurrent.ForwardingExecutorService;
import com.yahoo.container.handler.threadpool.ThreadPoolMetric;
import com.yahoo.container.handler.threadpool.WorkerCompletionTimingThreadPoolExecutor;
import com.yahoo.container.protect.ProcessTerminator;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;

class ExecutorServiceWrapper
extends ForwardingExecutorService {
    private final WorkerCompletionTimingThreadPoolExecutor wrapped;
    private final ThreadPoolMetric metric;
    private final ProcessTerminator processTerminator;
    private final long maxThreadExecutionTimeMillis;
    private final int queueCapacity;
    private final Thread metricReporter;
    private final AtomicBoolean closed = new AtomicBoolean(false);

    ExecutorServiceWrapper(WorkerCompletionTimingThreadPoolExecutor wrapped, ThreadPoolMetric metric, ProcessTerminator processTerminator, long maxThreadExecutionTimeMillis, String name, int queueCapacity) {
        this.wrapped = wrapped;
        this.metric = metric;
        this.processTerminator = processTerminator;
        this.maxThreadExecutionTimeMillis = maxThreadExecutionTimeMillis;
        this.queueCapacity = queueCapacity;
        metric.reportThreadPoolSize(wrapped.getPoolSize());
        metric.reportActiveThreads(wrapped.getActiveCount());
        this.metricReporter = new Thread(this::reportMetrics);
        this.metricReporter.setName(name + "-threadpool-metric-reporter");
        this.metricReporter.setDaemon(true);
        this.metricReporter.start();
    }

    private void reportMetrics() {
        try {
            while (!this.closed.get()) {
                this.metric.reportThreadPoolSize(this.wrapped.getPoolSize());
                this.metric.reportActiveThreads(this.wrapped.getActiveCount());
                this.metric.reportWorkQueueSize(this.wrapped.getQueue().size());
                this.metric.reportWorkQueueCapacity(this.queueCapacity);
                Thread.sleep(100L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void shutdown() {
        super.shutdown();
        this.closed.set(true);
    }

    public void execute(Runnable command) {
        try {
            super.execute(command);
        }
        catch (RejectedExecutionException e) {
            this.metric.reportRejectRequest();
            long timeSinceLastReturnedThreadMillis = System.currentTimeMillis() - this.wrapped.lastThreadAssignmentTimeMillis;
            if (timeSinceLastReturnedThreadMillis > this.maxThreadExecutionTimeMillis) {
                this.processTerminator.logAndDie("No worker threads have been available for " + timeSinceLastReturnedThreadMillis + " ms. Shutting down.", true);
            }
            throw e;
        }
    }

    protected ExecutorService delegate() {
        return this.wrapped;
    }
}

